<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Admin extends GSController {
	
	public function index() {
		$this->load->model("database/Madmin");
		
		if($this->CheckSession()) {
			redirect("admin/notice_board");die;
		}
		
		$message="";
		
		if(IsPostBack){
			$email = trim($_POST['email']);
			$password = trim($_POST['password']);
			if ($this->Madmin->authenticate($email, $password)) {
				$uType = $this->session->GetCurrentUserType();
				if($uType == "AD" && $this->session->GetAdminData()->role == 'A'){
					redirect("admin/notice_board");
				} else {
					redirect("admin");
				}
				
			} else {
				$message = "User ID/password combination incorrect.";
			}
		}
		
		$this->load->model("database/Madmin");
		$rData=array();
		$rData['loginObj']=$this->Madmin;
		$rData['title'] = "Ichhamati Degree College, Ranirbandar, Dinajpur";
		$rData['field'] = "User ID";
		$rData['msg'] = $message;
		$this->GetDefaultConfiguration($rData);
		$this->LoginPanel($rData);
	}
	
	public function delete_enrollment(){
	    $this->CheckSession(true);
		$pdata = array();
		
		$uriData = $this->GetUriArray();
		$batch_id = '';
		$std_reg = '';
		$ss_id = '';
		
		if(isset($uriData['std_reg'])){
			$std_reg = $uriData['std_reg'];
		}
		
		if(isset($uriData['batch_id'])){
			$batch_id = $uriData['batch_id'];
		}
		
		if(isset($uriData['ss_id'])){
			$ss_id = $uriData['ss_id'];
		}
		
		if(empty($batch_id) || empty($std_reg) || empty($ss_id)){
		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Invalid Data!','msg_type' => 'error'));
			redirect("admin");die;
		}
		
		$this->load->model("database/Mstd_subjects");
        $this->Mstd_subjects = new Mstd_subjects();
        $this->Mstd_subjects->ss_id($ss_id);
	    $this->Mstd_subjects->Delete();
	    
	    redirect("admin/enrollment_form/batch_id/$batch_id/std_reg/$std_reg");die;
	}
	
	
	public function delete_student() {
	    
		$this->CheckSession(true);
		
		$reg_id = $_REQUEST["reg_id"];
	
	
		if(!empty($reg_id)){
		    	//echo $reg_id;die;
		    	
	   //$this->load->model("database/Mstd_subjects");
       /// $this->Mstd_subjects = new Mstd_subjects();
        //$this->Mstd_subjects->ss_id($ss_id);
	   // $this->Mstd_subjects->Delete();		    	
		    	
		    	
		    $query_std_subjects = "DELETE FROM std_subjects WHERE std_reg = $reg_id";
            $records = $this->db->query($query_std_subjects);
           // $sub_data = $records->result();
            
            $query_std = "DELETE FROM students WHERE std_reg = $reg_id limit 1";
            $records2 = $this->db->query($query_std);
            //$sub_data2 = $records2->result();
            
            echo json_encode("s");
		    
		
		}else{
			echo json_encode("s");
		}
	}
	
	
	public function delete_student_enroll() {
	    
		$this->CheckSession(true);
		
		$reg_id = $_REQUEST["reg_id"];
		$year_no = $_REQUEST["year_no"];
			
		//echo 'ww';die;
	//	echo json_encode($reg_id);die;
		
	
	    
		if(!empty($reg_id)){
		  
	
		    	
		    $query_std_subjects = "DELETE FROM std_subjects WHERE std_reg = $reg_id AND year_no=$year_no";
            $records = $this->db->query($query_std_subjects);
           
            
            
            
            echo json_encode("s");
		    
		
		}else{
			echo json_encode("s");
		}
	}
	
	
	public function exam_result_print(){
	    $this->CheckSession(true);
		$pdata = array();
		$uriData = $this->GetUriArray();
		$batch_id = '';
		$year_no = '';
		
		if(isset($uriData['batch_id'])){
			$batch_id = $uriData['batch_id'];
		}
		
		if(isset($uriData['year_no'])){
			$year_no = $uriData['year_no'];
		}
	
		$pdata = array();
	
		$data = $this->session->flashdata('message');
		$pdata['msg_type'] = isset($data['msg_type']) ? $data['msg_type'] : '' ;
		$pdata['msg'] =  isset($data['msg']) ? $data['msg'] : '' ;
		
		$exam_name = $this->getBatchTitle($batch_id , $year_no);
		
		$batch_group = 'A';
		$batch_data = '';
		$this->load->model("database/Mbatch");
		$this->Mbatch->batch_id($batch_id);
		if($this->Mbatch->Select()){
		    $batch_data = $this->Mbatch;
		}
		
		if(empty($batch_data)){
		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Invalid Batch ID!','msg_type' => 'error'));
			redirect("admin/batches");die; 
		}
		
		$batch_group = $batch_data->batch_group;
		
		$subArr = array();
    	 $ScienceSub = ScienceSub();
    	 $ArtsSub = ArtsSub();
    	 $CommerceSub = CommerceSub();
    	 
    	 if($batch_group == 'A') {
    	     $subArr = $ScienceSub;
    	 }elseif($batch_group == 'B'){
    	     $subArr = $ArtsSub;
    	 }else{
    	     $subArr = $CommerceSub;
    	 }
    	 
    	 $subStr = implode(",",$subArr);
    	 
    	$query_subjects = "SELECT * FROM subjects WHERE sub_id IN ($subStr)";
		$records = $this->db->query($query_subjects);
		$all_sub = $records->result();
		
		if(empty($all_sub)){
		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Something went wrong!','msg_type' => 'error'));
			redirect("admin/batches");die;
		}
		
		$pdata['all_sub'] = $all_sub;
		
		$this->load->model("database/Mstd_subjects");
    	$this->Mstd_subjects = new Mstd_subjects();
    	$this->Mstd_subjects->batch_id($batch_id);
    	$this->Mstd_subjects->year_no($year_no);
    	$sub_data = $this->Mstd_subjects->SelectAll();
    	
    
    	
    	
    	if(empty($sub_data)){
    	    $sub_data = array();
    	    //$this->session->set_flashdata('message', array('url' => 'home','msg' => 'Invalid Batch ID!','msg_type' => 'error'));
			//redirect("admin/batch_subjects/batch_id/$batch_id");die; 
    	}
    	//https://www.ichhamatidegreecollege.edu.bd/idcm/admin/batch_subjects/batch_id/2
    	
    	$pdata['sub_data'] = $sub_data;
    	
    	$master_stdArr = array();
    	$std_cgpa = array();
    	
    	foreach($sub_data as $sd){
    	    $master_stdArr[$sd->std_reg][$sd->sub_id] = $sd->total;
    	}
    	$PairSub = PairSub();
    	
    	$fcount=0;
    	$abcount=0;
    	$passcount=0;
    	$gpa5=0;
    	$totalst=0;
    	
    	foreach($master_stdArr as $key=>$value){
    	    
    		$this->load->model("database/Mstudents");
    		$this->Mstudents=new Mstudents();
    		$stdObj = $this->Mstudents;
    		if(!empty($key)){
    		    $this->Mstudents=new Mstudents();
        		$this->Mstudents->std_reg($key);
        		if($this->Mstudents->Select()){
        		    $stdObj = $this->Mstudents;
        		}else{
        		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Invalid Batch or Student ID!','msg_type' => 'error'));
    			    redirect("admin/batches");die;   
        		}
    		} 
    		
    		$opt_ids = $stdObj->opt_ids;
    		
    		if(empty($opt_ids)){
    		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Optional Subject missing!','msg_type' => 'error'));
    			redirect("admin/batches");die;   
    		}
    		
    		$opt_idArr = explode (",", $opt_ids);
    		
    	    
    	    $foundArr = array();
    	    $totalGP = 0;
    	    $sub_no = 0;
    	    $f=0;
    	    
    	    foreach($value as $k=>$v){
    	        $opt_found = 'N';
    	        $PairSub_str = $PairSub[$k];
    	        $PairSubArr = explode (",", $PairSub_str);
    	        $total = 0;
    	        
    	        if(in_array($k,$opt_idArr)){
    	            $opt_found = 'Y';
    	        }
    	        
    	        if(!in_array($k,$foundArr)){
    	            $i = 0;
    	            foreach($PairSubArr as $PA){
    	                if(isset($value[$PA])){
    	                    $i++;
    	                   $total = $total + $value[$PA]; 
    	                }
    	                
    	            }
    	            if($i < 1){
    	                $avg = 0;
    	            }else{
    	               $avg = $total / $i; 
    	            }
    	            
    	            
    	            $grading = $this->GetGrading($avg);
            		$LG = $grading->LG;
            		$GP = $grading->GP;
            		
            	
            	
            		if($opt_found != 'Y' && $GP=='0.00'){
            		    $f++;
            		    //echo $f;	
            		}
            		
            		if($opt_found == 'Y'){
            		    if($GP > 2){
            		        $GP = $GP - 2;
            		    }else{
            		        $GP = 0;
            		    }
            		    
            		}else{
            		    $sub_no++;
            		}
            		
            		$totalGP = $totalGP + $GP;
            		
            		
            		
            		//echo 'Opt F--'.$opt_found.'--Total: ' .$total .'-av-'. $avg . '-LG-' . $LG . '-GP-'.$GP. '--tG--'. $totalGP.'<br>';
            		
            		
    	        }
    	        
    	        
    	        
    	        foreach($PairSubArr as $PA){
    	            $foundArr[] = $PA;
    	        }
    	        
    	    }
    	    if($f>0){
    	       $cgpa='F'.$f; 
    	       $fcount++;
    	    }else{
    	      $passcount++;
    	      $cgpa = $totalGP / $sub_no;
    	      $cgpa = number_format((float)$cgpa, 2, '.', '');
    	      
    	      if($cgpa=='5.00'){
    	          $gpa5++;
    	      }
    	      
    	    }
    	    $std_cgpa[$key] = $cgpa;
    	    
    	    $totalst=$fcount+$passcount;
    	    
    	    //echo '<br>--Total GP : --'.$totalGP. '-sub_no-'. $sub_no. '--CG Saju--'.$cgpa.'<br>'; 
    	    
    	    //GPrint($std_cgpa);
    	}
    	
    	//GPrint($std_cgpa);die;
    	
    	$pdata['master_stdArr'] = $master_stdArr;
    	
    	$pdata['totalst'] = $totalst;
    	$pdata['fcount'] = $fcount;
    	$pdata['passcount'] = $passcount;
    	$pdata['gpa5'] = $gpa5;
    	
    	
    	$pdata['std_cgpa'] = $std_cgpa;
		
		$pdata['exam_name'] = $exam_name;
		$pdata['LoadViews'] = "exam_result_print";
		$this->LoadView_print($pdata);
	}
	
	
	public function std_result_print(){
	    $this->CheckSession(true);
		$pdata = array();
		$uriData = $this->GetUriArray();
		$batch_id = '';
		$year_no = '';
		$std_reg = '';
		
		if(isset($uriData['batch_id'])){
			$batch_id = $uriData['batch_id'];
		}
		
		if(isset($uriData['year_no'])){
			$year_no = $uriData['year_no'];
		}
		
		if(isset($uriData['std_reg'])){
			$std_reg = $uriData['std_reg'];
		}
		
	
		$pdata = array();
	
		$data = $this->session->flashdata('message');
		$pdata['msg_type'] = isset($data['msg_type']) ? $data['msg_type'] : '' ;
		$pdata['msg'] =  isset($data['msg']) ? $data['msg'] : '' ;
		
		$exam_name = $this->getBatchTitle($batch_id , $year_no);
		
		$batch_group = 'A';
		$batch_data = '';
		$this->load->model("database/Mbatch");
		$this->Mbatch->batch_id($batch_id);
		if($this->Mbatch->Select()){
		    $batch_data = $this->Mbatch;
		}
		
		if(empty($batch_data)){
		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Invalid Batch ID!','msg_type' => 'error'));
			redirect("admin/batches");die; 
		}
		
		$batch_group = $batch_data->batch_group;
    	 
		
		$this->load->model("database/Mstd_subjects");
    	$this->Mstd_subjects = new Mstd_subjects();
    	$this->Mstd_subjects->batch_id($batch_id);
    	$this->Mstd_subjects->year_no($year_no);
    	$this->Mstd_subjects->std_reg($std_reg);
    	$sub_data = $this->Mstd_subjects->SelectAll("","sub_id","ASC");
    	
    	if(empty($sub_data)){
    	     $this->session->set_flashdata('message', array('url' => 'home','msg' => 'No data found!','msg_type' => 'error'));
			 redirect("admin/std_list/batch_id/$batch_id");die; 
    	}
    	
    	$master_stdArr = array();
    	$std_cgpa = array();
    	
    	foreach($sub_data as $sd){
    	    $master_stdArr[$sd->std_reg][$sd->sub_id] = $sd->total;
    	}
    	$PairSub = PairSub();
    	$final_data = array();
    	foreach($master_stdArr as $key=>$value){
    	    
    		$this->load->model("database/Mstudents");
    		$this->Mstudents=new Mstudents();
    		$stdObj = $this->Mstudents;
    		if(!empty($key)){
    		    $this->Mstudents=new Mstudents();
        		$this->Mstudents->std_reg($key);
        		if($this->Mstudents->Select()){
        		    $stdObj = $this->Mstudents;
        		}else{
        		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Invalid Batch or Student ID!','msg_type' => 'error'));
    			    redirect("admin/batches");die;   
        		}
    		} 
    		
    		$opt_ids = $stdObj->opt_ids;
    		
    		if(empty($opt_ids)){
    		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Optional Subject missing!','msg_type' => 'error'));
    			redirect("admin/batches");die;   
    		}
    		
    		$opt_idArr = explode (",", $opt_ids);
    	    
    	    $foundArr = array();
    	    $totalGP = 0;
    	    $sub_no = 0;
    	    
    	    $f=1;
    	    
    	    foreach($value as $k=>$v){
    	        $opt_found = 'N';
    	        $PairSub_str = $PairSub[$k];
    	        $PairSubArr = explode (",", $PairSub_str);
    	        $total = 0;
    	        
    	        if(in_array($k,$opt_idArr)){
    	            $opt_found = 'Y';
    	        }
    	        
    	        $sub_name = '-';
    	        $sub_code = '505';
    	        
    	        if(!in_array($k,$foundArr)){
    	            $i = 0;
    	            foreach($PairSubArr as $PA){
    	                $query_subjects = "SELECT * FROM subjects WHERE sub_id IN ($PA)";
                		$records = $this->db->query($query_subjects);
                		$sub_data = $records->result();
                		if(isset($sub_data[0]->short_name)){
                		    $sub_name = $sub_data[0]->short_name;
                		}
                		
    	                if(isset($value[$PA])){
    	                    $i++;
    	                   $total = $total + $value[$PA]; 
    	                }
    	                
    	                if($PA < $sub_code){
    	                   $sub_code = $PA; 
    	                }
    	            }
    	            if($i < 1){
    	                $avg = 0;
    	            }else{
    	               $avg = $total / $i; 
    	            }
    	            
    	            $grading = $this->GetGrading($avg);
            		$LG = $grading->LG;
            		$GP = $grading->GP;
            		
            		if($opt_found != 'Y' && $GP=='0.00'){
            		    $f=0;
            		    //echo $f;	
            		}
            		
            		if($opt_found == 'Y'){
            		    $sub_code = $sub_code . '(Optional)';
            		}
            		
            		$obj=new stdClass();
        			$obj->sub_name=$sub_name;
        			$obj->sub_code=$sub_code;
        			$obj->total=$total;
        			$obj->LG=$LG;
        			$obj->GP=$GP;
        			$final_data[] = $obj;
            		
            		if($opt_found == 'Y'){
            		    if($GP > 2){
            		        $GP = $GP - 2;
            		    }else{
            		        $GP = 0;
            		    }
            		    
            		}else{
            		    $sub_no++;
            		}
            		
            		$totalGP = $totalGP + $GP;
            		
    	        }
    	        
    	        foreach($PairSubArr as $PA){
    	            $foundArr[] = $PA;
    	        }
    	        
    	    }
    	    if($f==0){
    	       $cgpa='Fail'; 
    	    }else{
    	    $cgpa = $totalGP / $sub_no;
    	    $cgpa = number_format((float)$cgpa, 2, '.', '');
    	    }
    	    $std_cgpa[$key] = $cgpa;
    	}
    	
    	$pdata['master_stdArr'] = $master_stdArr;
    	$pdata['final_data'] = $final_data;
    	$pdata['stdObj'] = $stdObj;
    	$pdata['cgpa'] = $cgpa;
		
		$pdata['exam_name'] = $exam_name;
		$pdata['LoadViews'] = "std_result_print";
		$this->LoadView_print($pdata);
	}
	
	
	public function std_admit_print_all(){
	    $this->CheckSession(true);
		$pdata = array();
		$uriData = $this->GetUriArray();
		$batch_id = '';
		$year_no = '';
		$std_reg = '';
		
		if(isset($uriData['batch_id'])){
			$batch_id = $uriData['batch_id'];
		}
		
		if(isset($uriData['year_no'])){
			$year_no = $uriData['year_no'];
		}
		
		//echo $batch_id;
		//echo $year_no;die;
	
		$pdata = array();
	
		$data = $this->session->flashdata('message');
		$pdata['msg_type'] = isset($data['msg_type']) ? $data['msg_type'] : '' ;
		$pdata['msg'] =  isset($data['msg']) ? $data['msg'] : '' ;
		
		$exam_name = $this->getBatchTitle($batch_id , $year_no);
		
		$batch_group = 'A';
		$batch_data = '';
		$this->load->model("database/Mbatch");
		$this->Mbatch->batch_id($batch_id);
		if($this->Mbatch->Select()){
		    $batch_data = $this->Mbatch;
		}
		
		if(empty($batch_data)){
		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Invalid Batch ID!','msg_type' => 'error'));
			redirect("admin/batches");die; 
		}
		
		$batch_group = $batch_data->batch_group;
		
        //echo $batch_group;die;
		
		$this->load->model("database/Mstd_subjects");
    	$this->Mstd_subjects = new Mstd_subjects();
    	$this->Mstd_subjects->batch_id($batch_id);
    	$this->Mstd_subjects->year_no($year_no);
    	$sub_data = $this->Mstd_subjects->SelectAll("","sub_id","ASC");
    	
    	
    	
    	if(empty($sub_data)){
    	     $this->session->set_flashdata('message', array('url' => 'home','msg' => 'No data found!','msg_type' => 'error'));
			 redirect("admin/std_list/batch_id/$batch_id");die; 
    	}
    	
    	$query_subjects = "SELECT sb.std_reg, sb.batch_id, sb.year_no, sb.sub_id, sj.sub_title,st.std_roll,st.std_session,st.opt_ids, st.name,st.fname,st.mname FROM std_subjects as sb 
                        LEFT JOIN subjects AS sj ON sj.sub_id=sb.sub_id
                        LEFT JOIN students AS st ON st.std_reg=sb.std_reg
                        WHERE sb.batch_id=$batch_data->batch_id AND sb.year_no=$batch_data->year_no ORDER BY st.std_roll ASC, sj.sub_id ASC";
        $records = $this->db->query($query_subjects);
        $sub_data = $records->result();
       // Gprint($sub_data);die;
        $masterArr=array();
        
        foreach($sub_data as $sd){
            
            $masterArr[$sd->std_reg][$sd->sub_id]=$sd->sub_title;
            $masterArr[$sd->std_reg]['std_roll']=$sd->std_roll;
            $masterArr[$sd->std_reg]['std_name']=$sd->name;
            $masterArr[$sd->std_reg]['st_session']=$sd->std_session;
            $masterArr[$sd->std_reg]['opt_ids']=$sd->opt_ids;
            $masterArr[$sd->std_reg]['std_fname']=$sd->fname;
            $masterArr[$sd->std_reg]['std_mname']=$sd->mname;
            
            	
        }
        
        
    	//Gprint($masterArr);die;
    	
    	
		$pdata['masterArr']=$masterArr;
		$pdata['exam_name'] = $exam_name;
		$pdata['LoadViews'] = "std_admit_print_all";
		$this->LoadView_print($pdata);
	}
	
	
	public function std_admit_print(){
	    $this->CheckSession(true);
		$pdata = array();
		$uriData = $this->GetUriArray();
		$batch_id = '';
		$year_no = '';
		$std_reg = '';
		
		if(isset($uriData['batch_id'])){
			$batch_id = $uriData['batch_id'];
		}
		
		if(isset($uriData['year_no'])){
			$year_no = $uriData['year_no'];
		}
		
		if(isset($uriData['std_reg'])){
			$std_reg = $uriData['std_reg'];
		}
		
	
		$pdata = array();
	
		$data = $this->session->flashdata('message');
		$pdata['msg_type'] = isset($data['msg_type']) ? $data['msg_type'] : '' ;
		$pdata['msg'] =  isset($data['msg']) ? $data['msg'] : '' ;
		
		$exam_name = $this->getBatchTitle($batch_id , $year_no);
		
		$batch_group = 'A';
		$batch_data = '';
		$this->load->model("database/Mbatch");
		$this->Mbatch->batch_id($batch_id);
		if($this->Mbatch->Select()){
		    $batch_data = $this->Mbatch;
		}
		
		if(empty($batch_data)){
		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Invalid Batch ID!','msg_type' => 'error'));
			redirect("admin/batches");die; 
		}
		
		$batch_group = $batch_data->batch_group;
		
		$this->load->model("database/Mstd_subjects");
    	$this->Mstd_subjects = new Mstd_subjects();
    	$this->Mstd_subjects->batch_id($batch_id);
    	$this->Mstd_subjects->year_no($year_no);
    	$this->Mstd_subjects->std_reg($std_reg);
    	$sub_data = $this->Mstd_subjects->SelectAll("","sub_id","ASC");
    	
    	
    	
    	if(empty($sub_data)){
    	     $this->session->set_flashdata('message', array('url' => 'home','msg' => 'No data found!','msg_type' => 'error'));
			 redirect("admin/std_list/batch_id/$batch_id");die; 
    	}
    	
    	$query_student = "SELECT std_roll, std_reg, std_session, name, fname, mname FROM students
                        WHERE std_reg=$std_reg";
        $records1 = $this->db->query($query_student);
        $st_data = $records1->result();
    	
    	//GPrint($st_data);
    	
        $query_subjects = "SELECT sb.std_reg, sb.sub_id, st.opt_ids, sj.sub_title FROM std_subjects as sb 
                        LEFT JOIN subjects AS sj ON sj.sub_id=sb.sub_id 
                        LEFT JOIN students AS st ON st.std_reg=sb.std_reg
                        WHERE sb.std_reg=$std_reg AND sb.year_no=$year_no ORDER BY sj.sub_id ASC";
        $records = $this->db->query($query_subjects);
        $sub_data = $records->result();
                		
       // GPrint($sub_data);
    
    	
    	$pdata['st_data'] = $st_data;
    	$pdata['sub_data'] = $sub_data;
		
		$pdata['exam_name'] = $exam_name;
		$pdata['LoadViews'] = "std_admit_print";
		$this->LoadView_print($pdata);
	}
	
	
	
	public function testimonial(){
	    $this->CheckSession(true);
	    
		$pdata = array();
	
		$data = $this->session->flashdata('message');
		$pdata['msg_type'] = isset($data['msg_type']) ? $data['msg_type'] : '' ;
		$pdata['msg'] =  isset($data['msg']) ? $data['msg'] : '' ;
		
		$query_students = "SELECT st.std_reg, st.name, st.fname, st.mname, st.batch_id, st.std_roll, st.std_session, st.sub_ids, st.opt_ids,b.batch_group,t.serial_no, t.test_sl, t.dois, t.hsc_gpa, t.passing_year,st.gender, st.status  FROM students as st
		                   LEFT JOIN testimonial AS t ON t.std_reg = st.std_reg
		                   LEFT JOIN batch AS b ON b.batch_id = st.batch_id 
		                   WHERE t.status='A' ORDER BY t.dois DESC";
        $records = $this->db->query($query_students);
        $std_data = $records->result();
        //GPrint($std_data);die;
       
        
		$pdata['std_data'] = $std_data;
		
	
		$pdata['LoadViews'] = "testimonial";
		$this->LoadView($pdata);
	}
	
	public function testimonial_others(){
	    $this->CheckSession(true);
	    $pdata = array();
	    $data = $this->session->flashdata('message');
		$pdata['msg_type'] = isset($data['msg_type']) ? $data['msg_type'] : '' ;
		$pdata['msg'] =  isset($data['msg']) ? $data['msg'] : '' ;
	    
		$query_students = "SELECT * FROM testimonial_others ORDER BY dois DESC";
        $records = $this->db->query($query_students);
        $std_data = $records->result();
        //GPrint($std_data);die;
       
        
		$pdata['std_data'] = $std_data;
	
	
		$pdata['LoadViews'] = "testimonial_others";
		$this->LoadView($pdata);
	}
	
	
	public function testimonial_print(){
	    $this->CheckSession(true);
	    $uriData = $this->GetUriArray();
		
		$std_reg = '';
		
		
		
		if(isset($uriData['std_reg'])){
			$std_reg = $uriData['std_reg'];
		}
	    
		$pdata = array();
		$query_students = "SELECT st.std_reg, st.name, st.fname, st.mname, st.batch_id, st.std_roll, st.std_session, st.sub_ids, st.opt_ids, st.permanent_address,st.dob, b.batch_group,t.test_sl, t.dois, t.hsc_gpa, t.passing_year  FROM students as st
		                   LEFT JOIN testimonial AS t ON t.std_reg = st.std_reg
		                   LEFT JOIN batch AS b ON b.batch_id = st.batch_id 
		                   WHERE t.status='A' AND st.std_reg=$std_reg ORDER BY t.dois DESC";
        $records = $this->db->query($query_students);
        $std_data = $records->result();
        $sub_ids = $std_data[0]->sub_ids;
        //GPrint($std_data);
        $query_sub = "SELECT sb.sub_id, sb.name1, sb.short_name FROM subjects as sb
		                   WHERE sb.name1='A' AND sb.sub_id IN ($sub_ids) ORDER BY sb.sub_id ASC";
        $records2 = $this->db->query($query_sub);
        $sub_data = $records2->result();
        
		$pdata['st_data'] = $std_data;
		$pdata['sub_data'] = $sub_data;
	
		$pdata['LoadViews'] = "testimonial_print";
		$this->LoadView_print($pdata);
	}
	
	public function testimonial_form(){
	    $this->CheckSession(true);
		$pdata = array();
		$data = $this->session->flashdata('message');
		$pdata['msg_type'] = isset($data['msg_type']) ? $data['msg_type'] : '' ;
		$pdata['msg'] =  isset($data['msg']) ? $data['msg'] : '' ;
		
		$query_students = "SELECT std_reg, name FROM students";
        $records = $this->db->query($query_students);
        $st_data = $records->result();
		$pdata['st_data'] = $st_data;
		$pdata['LoadViews'] = "testimonial_form";
		$this->LoadView($pdata);
	}
	
	public function testimonial_others_form(){
	    $this->CheckSession(true);
		$pdata = array();
	    $std_class = $this->input->post("std_class", true); 
	    $std_group = $this->input->post("std_group", true); 
	    //echo $std_group;die;
	    $pdata['std_class']=$std_class;
	    $pdata['std_group']=$std_group;
	
		$pdata['LoadViews'] = "testimonial_others_form";
		$this->LoadView($pdata);
	}
	
	
	public function testimonial_add_others(){
	    $this->CheckSession(true);
		$pdata = array();
		
		$test_sl = $this->input->post("test_sl", true);
    	$std_reg= $this->input->post("std_reg", true);
    	$dois = $this->input->post("dois", true);
    	$gpa = $this->input->post("gpa", true); 
    	$passing_year = $this->input->post("passing_year", true); 
    	$std_roll = $this->input->post("std_roll", true); 
    	$name = $this->input->post("name", true);
	    $fname = $this->input->post("fname", true); 
		$mname = $this->input->post("mname", true);
    	$std_session= $this->input->post("std_session", true); 
    	$present_address = $this->input->post("present_address", true); 
    	$std_class = $this->input->post("std_class", true); 	
    	$std_division = $this->input->post("std_division", true); 
    	$dob = $this->input->post("dob", true); 
        $tsub1 = $this->input->post("sub1", true); 
        $tsub2 = $this->input->post("sub2", true); 
        $tsub3 = $this->input->post("sub3", true); 
        $tsub4 = $this->input->post("sub4", true); 
        $tsub5 = $this->input->post("sub5", true); 
        $tsub6 = $this->input->post("sub6", true); 
        $tsub7 = $this->input->post("sub7", true); 
        $toc1 = $this->input->post("oc1", true); 
        $toc2 = $this->input->post("oc2", true); 
        $toc3 = $this->input->post("oc3", true); 
        $toc4 = $this->input->post("oc4", true); 
        $toc5 = $this->input->post("oc5", true); 
        $toc6 = $this->input->post("oc6", true); 
        $toc7 = $this->input->post("oc7", true); 
        
        $sub1=$tsub1.''.$toc1;
        $sub2=$tsub2.''.$toc2;
        $sub3=$tsub3.''.$toc3;
        $sub4=$tsub4.''.$toc4;
        $sub5=$tsub5.''.$toc5;
        $sub6=$tsub6.''.$toc6;
        $sub7=$tsub7.''.$toc7;
        
	
        //echo $test_sl.$gpa.$std_session.$std_class.$sub1.$sub2.$sub3.$sub4.$sub5.$sub6.$sub7.$dois.$passing_year;die;
	    
	    $query_students = "SELECT * FROM testimonial_others WHERE test_sl=$test_sl";
        $records = $this->db->query($query_students);
        $std_data = $records->result();
        
       // GPrint($std_data);die;
	    
		if(!empty($std_data)){
		    $this->session->set_flashdata('message', array('url' => 'home','msg' => "You have already used this Sl Number",'msg_type' => 'success'));
    	    redirect("admin/testimonial_others_form");
		}
		else{
		
		$this->load->model("database/Mtestimonial_others");
		$this->Mtestimonial_others=new Mtestimonial_others();
		$this->Mtestimonial_others->std_reg($std_reg);
		$this->Mtestimonial_others->passing_year($passing_year);
		$this->Mtestimonial_others->test_sl($test_sl);
		$this->Mtestimonial_others->dois($dois);
		$this->Mtestimonial_others->dob($dob);
		$this->Mtestimonial_others->gpa($gpa);
		$this->Mtestimonial_others->std_roll($std_roll);
		$this->Mtestimonial_others->name($name);
		$this->Mtestimonial_others->fname($fname);
		$this->Mtestimonial_others->mname($mname);
		$this->Mtestimonial_others->std_session($std_session);
		$this->Mtestimonial_others->present_address($present_address);
		$this->Mtestimonial_others->std_class($std_class);
		$this->Mtestimonial_others->std_division($std_division);
		$this->Mtestimonial_others->sub1($sub1);
		$this->Mtestimonial_others->sub2($sub2);
		$this->Mtestimonial_others->sub3($sub3);
		$this->Mtestimonial_others->sub4($sub4);
		$this->Mtestimonial_others->sub5($sub5);
		$this->Mtestimonial_others->sub6($sub6);
		$this->Mtestimonial_others->sub7($sub7);
	
		
		$this->Mtestimonial_others->Save();
		$this->session->set_flashdata('message', array('url' => 'home','msg' => "Successfully Added.",'msg_type' => 'success'));
    	redirect("admin/testimonial_others"); 
		}
		
	
	}
	
		public function testimonial_print_others(){
	    $this->CheckSession(true);
	    $uriData = $this->GetUriArray();
		
		$test_sl = '';
		
		
		
		if(isset($uriData['test_sl'])){
			$test_sl = $uriData['test_sl'];
		}
	    
		$pdata = array();
		$query_students = "SELECT * FROM testimonial_others
		                   WHERE test_sl=$test_sl ";
        $records = $this->db->query($query_students);
        $std_data = $records->result();
      
        
		$pdata['st_data'] = $std_data;
	
		$pdata['LoadViews'] = "testimonial_print_others";
		$this->LoadView_print($pdata);
	}
	
	
	public function testimonial_form_edit(){
	    $this->CheckSession(true);
	    
	     $uriData = $this->GetUriArray();
		
		 $serial_no = '';
		
		if(isset($uriData['serial_no'])){
			$serial_no = $uriData['serial_no'];
		}
	    
		$pdata = array();
		$data = $this->session->flashdata('message');
		$pdata['msg_type'] = isset($data['msg_type']) ? $data['msg_type'] : '' ;
		$pdata['msg'] =  isset($data['msg']) ? $data['msg'] : '' ;
		
		$query_students = "SELECT std_reg, name FROM students";
        $records = $this->db->query($query_students);
        $st_data = $records->result();
		
		$query_students2 = "SELECT * FROM testimonial WHERE serial_no=$serial_no";
        $records2 = $this->db->query($query_students2);
        $single_data = $records2->result();
        
        //GPrint($single_data);die;
        
		$pdata['st_data'] = $st_data;
		$pdata['single_data'] = $single_data;
		$pdata['LoadViews'] = "testimonial_form_edit";
		$this->LoadView($pdata);
	}
	
	public function testimonial_form_others_edit(){
	    $this->CheckSession(true);
	    
	     $uriData = $this->GetUriArray();
		
		 $id = '';
		
		if(isset($uriData['id'])){
			$id = $uriData['id'];
		}
	    
		$pdata = array();
		$data = $this->session->flashdata('message');
		$pdata['msg_type'] = isset($data['msg_type']) ? $data['msg_type'] : '' ;
		$pdata['msg'] =  isset($data['msg']) ? $data['msg'] : '' ;
		
		
		$query_students2 = "SELECT * FROM testimonial_others WHERE id=$id";
        $records2 = $this->db->query($query_students2);
        $single_data = $records2->result();
        
        //GPrint($single_data);die;

		$pdata['single_data'] = $single_data;
		$pdata['LoadViews'] = "testimonial_form_others_edit";
		$this->LoadView($pdata);
	}
	
	
	public function testimonial_add(){
	    $this->CheckSession(true);
	    $std_reg = $this->input->post("std_reg", true); 
	    $hsc_gpa = $this->input->post("hsc_gpa", true); 
	    $passing_year = $this->input->post("passing_year", true); 
		$test_sl = $this->input->post("test_sl", true);
	    $dois = $this->input->post("dois", true);
	    //echo $std_reg.$hsc_gpa.$passing_year.$test_sl.$dois;die;
	    
	    $query_students = "SELECT * FROM testimonial WHERE test_sl=$test_sl";
        $records = $this->db->query($query_students);
        $std_data = $records->result();
        
       // GPrint($std_data);die;
	    
		if(!empty($std_data)){
		    $this->session->set_flashdata('message', array('url' => 'home','msg' => "You have already used this Sl Number",'msg_type' => 'success'));
    	    redirect("admin/testimonial_form");
		}
		else{
		
		$this->load->model("database/Mtestimonial");
		$this->Mtestimonial=new Mtestimonial();
		$this->Mtestimonial->std_reg($std_reg);
		$this->Mtestimonial->hsc_gpa($hsc_gpa);
		$this->Mtestimonial->passing_year($passing_year);
		$this->Mtestimonial->test_sl($test_sl);
		$this->Mtestimonial->dois($dois);
		
		$this->Mtestimonial->Save();
		$this->session->set_flashdata('message', array('url' => 'home','msg' => "Successfully Added.",'msg_type' => 'success'));
    	redirect("admin/testimonial"); 
		}
		
	}
	
	public function testimonial_update_others(){
	    $this->CheckSession(true);
	    $id = $this->input->post("id", true); 
	    $test_sl = $this->input->post("test_sl", true);
    	$std_reg= $this->input->post("std_reg", true);
    	$dois = $this->input->post("dois", true);
    	$gpa = $this->input->post("gpa", true); 
    	$passing_year = $this->input->post("passing_year", true); 
    	$std_roll = $this->input->post("std_roll", true); 
    	$name = $this->input->post("name", true);
	    $fname = $this->input->post("fname", true); 
		$mname = $this->input->post("mname", true);
    	$std_session= $this->input->post("std_session", true); 
    	$present_address = $this->input->post("present_address", true); 
    	$std_class = $this->input->post("std_class", true); 	
    	$std_division = $this->input->post("std_division", true); 
    	$dob = $this->input->post("dob", true); 
        $sub1 = $this->input->post("sub1", true); 
        $sub2 = $this->input->post("sub2", true); 
        $sub3 = $this->input->post("sub3", true); 
        $sub4 = $this->input->post("sub4", true); 
        $sub5 = $this->input->post("sub5", true); 
        $sub6 = $this->input->post("sub6", true); 
        $sub7 = $this->input->post("sub7", true); 
	     //, 
	   // std_session=$std_session, present_address=$present_address, std_class=$std_class, std_division=$std_division, dob='$dob', sub1=$sub1, sub2=$sub2,
	    //sub3=$sub3, sub4=$sub4, sub5=$sub5, sub6=$sub6, sub7=$sub7
	    $query_update = "UPDATE testimonial_others SET test_sl=$test_sl,std_reg=$std_reg,dois='$dois',gpa=$gpa,passing_year=$passing_year, std_roll=$std_roll, name='$name', fname='$fname', mname='$mname',
	    std_session=$std_session, present_address='$present_address', std_class='$std_class', std_division='$std_division', dob='$dob', sub1='$sub1', sub2='$sub2',
	    sub3='$sub3', sub4='$sub4', sub5='$sub5', sub6='$sub6', sub7='$sub7' WHERE id=$id ";
        $records = $this->db->query($query_update);
      
		$this->session->set_flashdata('message', array('url' => 'home','msg' => "Successfully Updated.",'msg_type' => 'success'));
    	redirect("admin/testimonial_others"); 
		
		
	}
	
	public function testimonial_update(){
	    $this->CheckSession(true);
	    $serial_no = $this->input->post("serial_no", true); 
	    $std_reg = $this->input->post("std_reg", true); 
	    $hsc_gpa = $this->input->post("hsc_gpa", true); 
	    $passing_year = $this->input->post("passing_year", true); 
		$test_sl = $this->input->post("test_sl", true);
	    $dois = $this->input->post("dois", true);
	    //echo $dois;die;
	   
	    $query_update = "UPDATE testimonial set std_reg=$std_reg,hsc_gpa=$hsc_gpa,passing_year=$passing_year, test_sl=$test_sl, dois='$dois' WHERE serial_no=$serial_no ";
        $records = $this->db->query($query_update);
      
		$this->session->set_flashdata('message', array('url' => 'home','msg' => "Successfully Updated.",'msg_type' => 'success'));
    	redirect("admin/testimonial"); 
		
		
	}
	
	
	public function delete_testimonial_others() {
	    
		$this->CheckSession(true);
		$reg_id = $_REQUEST["reg_id"];
	    
		if(!empty($reg_id)){
	
		    $query_std_subjects = "DELETE FROM testimonial_others WHERE std_reg = $reg_id";
            $records = $this->db->query($query_std_subjects);
            
            echo json_encode("s");
		
		}else{
			echo json_encode("s");
		}
	}
	
	public function delete_testimonial() {
	    
		$this->CheckSession(true);
		
		$reg_id = $_REQUEST["reg_id"];
		
			
		//echo 'ww';die;
	//	echo json_encode($reg_id);die;
		
	
	    
		if(!empty($reg_id)){
		  
	
		    	
		    $query_std_subjects = "DELETE FROM testimonial WHERE std_reg = $reg_id";
            $records = $this->db->query($query_std_subjects);
           
            
            
            
            echo json_encode("s");
		    
		
		}else{
			echo json_encode("s");
		}
	}
	
	
	public function exam_result_print_bk(){
	    $this->CheckSession(true);
		$pdata = array();
		$uriData = $this->GetUriArray();
		$batch_id = '';
		$year_no = '';
		
		if(isset($uriData['batch_id'])){
			$batch_id = $uriData['batch_id'];
		}
		
		if(isset($uriData['year_no'])){
			$year_no = $uriData['year_no'];
		}
	
		$pdata = array();
	
		$data = $this->session->flashdata('message');
		$pdata['msg_type'] = isset($data['msg_type']) ? $data['msg_type'] : '' ;
		$pdata['msg'] =  isset($data['msg']) ? $data['msg'] : '' ;
		
		$exam_name = $this->getBatchTitle($batch_id , $year_no);
		
		$batch_group = 'A';
		$batch_data = '';
		$this->load->model("database/Mbatch");
		$this->Mbatch->batch_id($batch_id);
		if($this->Mbatch->Select()){
		    $batch_data = $this->Mbatch;
		}
		
		if(empty($batch_data)){
		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Invalid Batch ID!','msg_type' => 'error'));
			redirect("admin/batches");die; 
		}
		
		$batch_group = $batch_data->batch_group;
		
		$subArr = array();
    	 $ScienceSub = ScienceSub();
    	 $ArtsSub = ArtsSub();
    	 $CommerceSub = CommerceSub();
    	 
    	 if($batch_group == 'A') {
    	     $subArr = $ScienceSub;
    	 }elseif($batch_group == 'B'){
    	     $subArr = $ArtsSub;
    	 }else{
    	     $subArr = $CommerceSub;
    	 }
    	 
    	 $subStr = implode(",",$subArr);
    	 
    	$query_subjects = "SELECT * FROM subjects WHERE sub_id IN ($subStr)";
		$records = $this->db->query($query_subjects);
		$all_sub = $records->result();
		
		if(empty($all_sub)){
		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Something went wrong!','msg_type' => 'error'));
			redirect("admin/batches");die;
		}
		
		$pdata['all_sub'] = $all_sub;
		
		$this->load->model("database/Mstd_subjects");
    	$this->Mstd_subjects = new Mstd_subjects();
    	$this->Mstd_subjects->batch_id($batch_id);
    	$this->Mstd_subjects->year_no($year_no);
    	$sub_data = $this->Mstd_subjects->SelectAll();
    	
    	
    	if(empty($sub_data)){
    	    $sub_data = array();
    	    //$this->session->set_flashdata('message', array('url' => 'home','msg' => 'Invalid Batch ID!','msg_type' => 'error'));
			//redirect("admin/batch_subjects/batch_id/$batch_id");die; 
    	}
    	//https://www.ichhamatidegreecollege.edu.bd/idcm/admin/batch_subjects/batch_id/2
    	
    	$pdata['sub_data'] = $sub_data;
    	
    	
    	$master_stdArr = array();
    	
    	foreach($sub_data as $sd){
    	    $master_stdArr[$sd->std_reg][$sd->sub_id] = $sd->LG;
    	}
    	
    	$pdata['master_stdArr'] = $master_stdArr;
		
		$pdata['exam_name'] = $exam_name;
		$pdata['LoadViews'] = "exam_result_print";
		$this->LoadView_print($pdata);
	}
	
	private function LoadView_print($rData) {
		$this->load->view("common_view_print",$rData);
	}
	
	public function sub_details(){
	    $this->CheckSession(true);
		$pdata = array();
		$uriData = $this->GetUriArray();
		$batch_id = '';
		$code = '';
		$year_no = '';
		$pos_id='';
		
		$data = $this->session->flashdata('message');
		if(isset($data['msg_type'])){
		    $pdata['msg_type'] = $data['msg_type'];
		    $pdata['msg'] = $data['msg'];
		}
		
		if(isset($uriData['batch_id'])){
			$batch_id = $uriData['batch_id'];
		}
		if(isset($uriData['pos_id'])){
			$pos_id = $uriData['pos_id'];
		}
		if(isset($uriData['code'])){
			$code = $uriData['code'];
		}
		if(isset($uriData['year_no'])){
			$year_no = $uriData['year_no'];
		}
		
		if(empty($batch_id) || empty($code) || empty($year_no)){
		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Invalid Batch ID!','msg_type' => 'error'));
			redirect("admin/batches");die; 
		}
		
		$batch_group = 'A';
		$batch_data = '';
		$title = '';
		$this->load->model("database/Mbatch");
		$this->Mbatch->batch_id($batch_id);
		if($this->Mbatch->Select()){
		    $batch_data = $this->Mbatch;
		}
		
		if(empty($batch_data)){
		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Invalid Batch ID!','msg_type' => 'error'));
			redirect("admin/batches");die; 
		}
		
		$batch_group = $batch_data->batch_group;
	    $batch_group_title = $batch_data->batch_group;
	    $year_no_str = $batch_data->year_no;
	    
	    if($batch_data->year_no == 1){
	        $year_no_str = '1st Year';
	    }else{
	        $year_no_str = '2nd Year';
	    }
	    if($batch_data->batch_group == 'A'){
    		$batch_group_title = "<span class='badge bg-green'>Science</span>";
    	}elseif($batch_data->batch_group == 'B'){
    		$batch_group_title = "<span class='badge bg-red'>Arts</span>";
    	}else{
    	    $batch_group_title = "<span class='badge bg-yellow'>Commerce</span>";
        }
	    $title .= $batch_data->batch_title;
	    $title .= ' '.$batch_data->batch_year;
	    $title .= ' - '.$year_no_str ;
	    $title .= ' - Group: '.$batch_group_title;		  
	    
	    $pdata['title'] = $title;
		$pdata['batch_id'] = $batch_id;
		$pdata['batch_group'] = $batch_group;
		$pdata['year_no'] = $year_no;
		
		$query_subjects = "SELECT * FROM subjects WHERE sub_id IN ($code)";
		$records = $this->db->query($query_subjects);
		$sub_data = $records->result();
		
		if(empty($sub_data)){
		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Something went wrong!','msg_type' => 'error'));
			redirect("admin/batches");die;
		}
		
		$pdata['sub_data'] = $sub_data;

        $query_std_subjects = "SELECT ss.*,s.name, s.std_roll FROM std_subjects AS ss LEFT JOIN students AS s ON ss.std_reg = s.std_reg WHERE ss.batch_id = $batch_id AND ss.sub_id = $code AND ss.year_no = $year_no ORDER BY s.std_roll ASC;";
		$records = $this->db->query($query_std_subjects);
		$std_sub_data = $records->result();
        $pdata['std_sub_data'] = $std_sub_data;
        
       // GPrint($std_sub_data);die;
        
        $practical_found = 'N';
        $eng_found = 'N';
        $practical_sub = array(275,123,124,125,126,174,175,176,177,178,179,265,266);
        
        if(in_array($code, $practical_sub)){
            $practical_found = 'Y';
        }
        if($code == '107' || $code == '108' || $code == '102'){
            $eng_found = 'Y';
        }
        $pdata['practical_found'] = $practical_found;
        $pdata['eng_found'] = $eng_found;
        
        $pdata['pos_id'] = $pos_id;
        
        $pdata['LoadViews'] = "sub_details";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);
	}
	
	public function getBatchTitle($batch_id = '' , $year_no = ''){
        $batch_group = 'A';
		$batch_data = '';
		$title = '';
		$this->load->model("database/Mbatch");
		$this->Mbatch->batch_id($batch_id);
		if($this->Mbatch->Select()){
		    $batch_data = $this->Mbatch;
		}
		
		if(empty($batch_data)){
		    return $title;
		}
		
		$batch_group = $batch_data->batch_group;
	    $batch_group_title = $batch_data->batch_group;
	    $year_no_str = '';
	    
	    if($year_no == 1){
	        $year_no_str = 'First Terminal,';
	    }elseif($year_no == 2){
	        $year_no_str = 'Promotion Test';
	    }else{
	        $year_no_str = 'Test';
	    }
	    if($batch_data->batch_group == 'A'){
    		$batch_group_title = "<span class='badge bg-green'>Science</span>";
    	}elseif($batch_data->batch_group == 'B'){
    		$batch_group_title = "<span class='badge bg-red'>Arts</span>";
    	}else{
    	    $batch_group_title = "<span class='badge bg-yellow'>Commerce</span>";
        }
	    $title .= $batch_data->batch_title;
	    $title .= ' '.$batch_data->batch_year;
	    $title .= ' - '.$year_no_str ;
	    $title .= ' - Group: '.$batch_group_title;	
	    return $title;
	}
	
	public function GetGrading($percent = ''){
		$gp_arr = array('A+'=>'5.00','A'=>'4.00','A-'=>'3.5','B'=>'3.00','C'=>'2.00','D'=>'1.00','F'=>'0.00');
		$LG = '';
		if($percent >= 80){
			$LG = 'A+';
		}elseif($percent >= 70 && $percent < 80){
			$LG = 'A';
		}elseif($percent >= 60 && $percent < 70){
			$LG = 'A-';
		}elseif($percent >= 50 && $percent < 60){
			$LG = 'B';
		}elseif($percent >= 40 && $percent < 50){
			$LG = 'C';
		}elseif($percent >= 33 && $percent < 40){
			$LG = 'D';
		}else{
			$LG = 'F';
		}
		$GP = '';
		if(isset($gp_arr[$LG])){
			$GP = $gp_arr[$LG];
		}
		$obj=new stdClass();
		$obj->LG = $LG;
		$obj->GP = $GP;
		//GPrint($obj);
		return $obj;
	} 
	
	public function save_marks(){
		$ss_id = $this->input->post("ss_id", true);
		$sub_id = $this->input->post("sub_id", true);
		$batch_id = $this->input->post("batch_id", true);
		$year_no = $this->input->post("year_no", true);
		$pos_id = $this->input->post("pos_id", true);
		$theory = $this->input->post("theory", true);
		$MCQ = $this->input->post("MCQ", true);
		$practical = $this->input->post("practical", true);
		
		$practical_found = 'N';
        $practical_sub = array(275,123,124,125,126,174,175,176,177,178,179,265,266);
        
        if(in_array($sub_id, $practical_sub)){
            $practical_found = 'Y';
        }
        
        $eng_found = 'N';
        if($sub_id == '107' || $sub_id == '108' || $sub_id == '102'){
            $eng_found = 'Y';
        }
		
		//$this->session->set_flashdata('message', array('url' => 'home','msg' => 'Successfully saved!','msg_type' => 'success'));
		//redirect("admin/sub_details/code/$sub_id/batch_id/$batch_id/year_no/$year_no");die;
		
		$pos_str = '';
		
		$casting = intdiv($pos_id, 10);
		$cur_pos_id = $casting * 10;
		if($cur_pos_id > 9){
			$pos_str = 'pos_id/'.$cur_pos_id;
		}
		
	
		
		$marksArr = array($theory,$MCQ,$practical);
		$is_clean = 'Y';
		foreach ($marksArr as $ma){
			if(!empty($ma)){
				if($ma > 0){
				}elseif($ma === '0'){
				}elseif($ma === '0.00'){
				}else{
					$is_clean = 'N';
				}				
			}
		}
		
		if($is_clean == 'N'){
			$this->session->set_flashdata('message', array('url' => 'home','msg' => 'Invalid input!','msg_type' => 'error'));
			redirect("admin/sub_details/code/$sub_id/batch_id/$batch_id/year_no/$year_no");die;
		}
		
		$total_marks = array_sum($marksArr);
		if($total_marks > 100){
			$this->session->set_flashdata('message', array('url' => 'home','msg' => "Total marks should not be greater than 100!",'msg_type' => 'error'));
			redirect("admin/sub_details/code/$sub_id/batch_id/$batch_id/year_no/$year_no");die;
		}
		$percent = number_format($total_marks, 0);
		
		$grading = $this->GetGrading($percent);
		$LG = $grading->LG;
		$GP = $grading->GP;
		
		if($practical_found == 'Y'){
		    if($theory < 17 || $MCQ < 8 || $practical < 8){
		        $LG = 'F';
		        $GP = '0.00';
		    }
		}else{
		    if($eng_found == 'N'){
		        if($theory < 23 || $MCQ < 10 ){
		            $LG = 'F';
		            $GP = '0.00';
		        }
		    }else{
		       if($theory < 33){
		            $LG = 'F';
		            $GP = '0.00';
		        } 
		    }
		   
		}
		
		
		//https://stackoverflow.com/questions/732979/php-whats-an-alternative-to-empty-where-string-0-is-not-treated-as-empty
		
		$this->load->model("database/Mstd_subjects");
    	$this->Mstd_subjects = new Mstd_subjects();
    	$this->Mstd_subjects->ss_id($ss_id);
    	if($theory==="0"||$theory){$this->Mstd_subjects->theory($theory);}else{$this->Mstd_subjects->theory('theory = NULL',false);}
    	if($MCQ==="0"||$MCQ){$this->Mstd_subjects->MCQ($MCQ);}else{$this->Mstd_subjects->MCQ('MCQ = NULL',false);}
    	if($practical==="0"||$practical){$this->Mstd_subjects->practical($practical);}else{$this->Mstd_subjects->practical('practical = NULL',false);}
    	        
		if($practical_found == 'N'){
			if($eng_found == 'N'){
    			if(($theory==="0"||$theory)&&($MCQ==="0"||$MCQ)){
    				$this->Mstd_subjects->total($total_marks);
    				$this->Mstd_subjects->LG($LG);
    				$this->Mstd_subjects->GP($GP);
    			}else{
    				$this->Mstd_subjects->total('total = NULL',false);
    				$this->Mstd_subjects->LG('LG = NULL',false);
    				$this->Mstd_subjects->GP('GP = NULL',false);
    			}			    
			}else{
    			if(($theory==="0"||$theory)){
    				$this->Mstd_subjects->total($total_marks);
    				$this->Mstd_subjects->LG($LG);
    				$this->Mstd_subjects->GP($GP);
    			}else{
    				$this->Mstd_subjects->total('total = NULL',false);
    				$this->Mstd_subjects->LG('LG = NULL',false);
    				$this->Mstd_subjects->GP('GP = NULL',false);
    			}			    
			}

		}else{
			if(($theory==="0"||$theory)&&($MCQ==="0"||$MCQ)&&($practical==="0"||$practical)){
				$this->Mstd_subjects->total($total_marks);
				$this->Mstd_subjects->LG($LG);
				$this->Mstd_subjects->GP($GP);
			}else{
				$this->Mstd_subjects->total('total = NULL',false);
				$this->Mstd_subjects->LG('LG = NULL',false);
				$this->Mstd_subjects->GP('GP = NULL',false);
			}
		}
		
		if($this->Mstd_subjects->Update()){
			$this->session->set_flashdata('message', array('url' => 'home','msg' => 'Successfully saved!','msg_type' => 'success'));
			redirect("admin/sub_details/code/$sub_id/batch_id/$batch_id/year_no/$year_no/$pos_str");die;
		}else{
			$this->session->set_flashdata('message', array('url' => 'home','msg' => 'No changes found or Data type not matched!','msg_type' => 'error'));
			redirect("admin/sub_details/code/$sub_id/batch_id/$batch_id/year_no/$year_no/$pos_str");die;
		}
	}
	
	public function batch_subjects(){
	    $this->CheckSession(true);
		$pdata = array();
		
		$uriData = $this->GetUriArray();
		$batch_id = '';
		
		if(isset($uriData['batch_id'])){
			$batch_id = $uriData['batch_id'];
		}
		
		$batch_group = 'A';
		$batch_data = '';
		$title = '';
		$this->load->model("database/Mbatch");
		$this->Mbatch->batch_id($batch_id);
		if($this->Mbatch->Select()){
		    $batch_data = $this->Mbatch;
		}
		
		if(empty($batch_data)){
		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Invalid Batch ID!','msg_type' => 'error'));
			redirect("admin/batches");die; 
		}
		
	    $batch_group = $batch_data->batch_group;
	    $batch_group_title = $batch_data->batch_group;
	    $year_no = $batch_data->year_no;
	    
	    if($batch_data->year_no == 1){
	        $year_no = '1st Year';
	    }else{
	        $year_no = '2nd Year';
	    }
	    if($batch_data->batch_group == 'A'){
    		$batch_group_title = "<span class='badge bg-green'>Science</span>";
    	}elseif($batch_data->batch_group == 'B'){
    		$batch_group_title = "<span class='badge bg-red'>Arts</span>";
    	}else{
    	    $batch_group_title = "<span class='badge bg-yellow'>Commerce</span>";
        }
	    $title .= $batch_data->batch_title;
	    $title .= ' '.$batch_data->batch_year;
	    $title .= ' - '.$year_no ;
	    $title .= ' - Group: '.$batch_group_title;		  
	    
	    $pdata['title'] = $title;
		$pdata['batch_id'] = $batch_id;
		$pdata['batch_group'] = $batch_group;
		
		
		$subArr = array();
    	 $ScienceSub = ScienceSub();
    	 $ArtsSub = ArtsSub();
    	 $CommerceSub = CommerceSub();
    	 
    	 if($batch_group == 'A') {
    	     $subArr = $ScienceSub;
    	 }elseif($batch_group == 'B'){
    	     $subArr = $ArtsSub;
    	 }else{
    	     $subArr = $CommerceSub;
    	 }
    	 
    	 $subStr = implode(",",$subArr);
    	//Gprint($subStr);die;
    	//$query_subjects = "SELECT sj.sub_id, sj.sub_title, COUNT(distinct ss.std_reg) AS numstd FROM subjects sj 
		//                   LEFT JOIN std_subjects ss ON ss.sub_id = sj.sub_id 
		//                   WHERE sj.sub_id in ($subStr) AND ss.batch_id=$batch_id AND ss.year_no=$batch_data->year_no GROUP BY sj.sub_id";
		$query_subjects = "SELECT * FROM subjects WHERE sub_id in ($subStr)";
		$records = $this->db->query($query_subjects);
		$sub_data = $records->result();
		//Gprint($sub_data);die;
			
	
			
		if(empty($sub_data)){
		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Something went wrong!','msg_type' => 'error'));
			redirect("admin/batches");die;
		}
		
		$pdata['sub_data'] = $sub_data;
    	//Gprint($sub_data);die;
		
		$pdata['LoadViews'] = "batch_subjects";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);
	}
	
	public function do_enrollment(){
		$this->CheckSession(true);
		$std_reg = $this->input->post("std_reg", true); 
	    $year_no = $this->input->post("year_no", true); 
	    $subArr = $this->input->post("subArr", true); 
	    $batch_id = $this->input->post("batch_id", true); 
	    if(is_array($subArr) || is_object($subArr)){
	        foreach($subArr as $sa){
	            $sub_found = 'N';
    			$this->load->model("database/Mstd_subjects");
    	        $this->Mstd_subjects = new Mstd_subjects();
    	        $this->Mstd_subjects->std_reg($std_reg);
    	        $this->Mstd_subjects->batch_id($batch_id);
    	        $this->Mstd_subjects->sub_id($sa);
    	        $this->Mstd_subjects->year_no($year_no);
    		    if($this->Mstd_subjects->Select()){
    		        $sub_found = 'Y';
    		    }
    		    if($sub_found == 'N'){
    		        $this->Mstd_subjects = new Mstd_subjects();
    	            $this->Mstd_subjects->std_reg($std_reg);
    	            $this->Mstd_subjects->batch_id($batch_id);
    	            $this->Mstd_subjects->sub_id($sa);
    	            $this->Mstd_subjects->year_no($year_no);
    	            $this->Mstd_subjects->Save();
    		    }
	        }
	        $this->session->set_flashdata('message', array('url' => 'home','msg' => "Successfully enrolled.",'msg_type' => 'success'));
    		redirect("admin/enrollment_form/batch_id/$batch_id/std_reg/$std_reg");die;
	        
	    }else{
	        $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Invalid Data!','msg_type' => 'error'));
			redirect("admin/enrollment_form/batch_id/$batch_id/std_reg/$std_reg");die;
	    }
	    redirect("admin/enrollment_form/batch_id/$batch_id/std_reg/$std_reg");die;
	}
	
	public function enrollment_form(){
		$this->CheckSession(true);
		$pdata = array();
		
		$uriData = $this->GetUriArray();
		$batch_id = '';
		$std_reg = '';
		
		if(isset($uriData['std_reg'])){
			$std_reg = $uriData['std_reg'];
		}
		
		if(isset($uriData['batch_id'])){
			$batch_id = $uriData['batch_id'];
		}
		
		if(empty($batch_id)){
			$this->session->set_flashdata('message', array('url' => 'home','msg' => 'Something went wrong!','msg_type' => 'error'));
			redirect("admin/batches");die;
		}
		$batch_group2 = 'A';
		$batch_data = '';
		$title = '';
		$this->load->model("database/Mbatch");
		$this->Mbatch->batch_id($batch_id);
		if($this->Mbatch->Select()){
		    $batch_data = $this->Mbatch;
		}
		
		if(empty($batch_data)){
		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Invalid Batch ID!','msg_type' => 'error'));
			redirect("admin/batches");die; 
		}
		
		$year_no = $batch_data->year_no;
		$pdata['year_no'] = $year_no;
		
		$this->load->model("database/Mstudents");
		$this->Mstudents=new Mstudents();
		$stdObj = $this->Mstudents;
		if(!empty($std_reg)){
		    $this->Mstudents=new Mstudents();
    		$this->Mstudents->std_reg($std_reg);
    		if($this->Mstudents->Select()){
    		    $stdObj = $this->Mstudents;
    		}else{
    		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Invalid Batch or Student ID!','msg_type' => 'error'));
			    redirect("admin/batches");die;   
    		}
		}
		
		$sub_ids = $stdObj->sub_ids;
		
		//Gprint($sub_ids);die;
		
		if(empty($sub_ids)){
		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Something went wrong!','msg_type' => 'error'));
			redirect("admin/batches");die;
		}
		
		$pdata['stdObj'] = $stdObj;
		
		$query_subjects = "SELECT * FROM subjects WHERE sub_id IN ($sub_ids)";
		$records = $this->db->query($query_subjects);
		$sub_data = $records->result();
		
		if(empty($sub_data)){
		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Something went wrong!','msg_type' => 'error'));
			redirect("admin/batches");die;
		}
		
		$subArr = array();
		
		foreach ($sub_data as $sd){
		    $sub_found = 'N';
		    $ss_id = '';
			$this->load->model("database/Mstd_subjects");
	        $this->Mstd_subjects = new Mstd_subjects();
	        $this->Mstd_subjects->std_reg($std_reg);
	        $this->Mstd_subjects->sub_id($sd->sub_id);
	        $this->Mstd_subjects->year_no($year_no);
		    if($this->Mstd_subjects->Select()){
		        $sub_found = 'Y';
		        $ss_id = $this->Mstd_subjects->ss_id;
		    }
		    $obj=new stdClass();
			$obj->sub_id=$sd->sub_id;
			$obj->sub_title=$sd->sub_title;
			$obj->short_code = $sd->short_code;
			$obj->sub_found = $sub_found;
			$obj->ss_id = $ss_id;
			$subArr[] = $obj;
		}
		
		//GPrint($subArr);die;
		$pdata['subArr'] = $subArr;
	
		if(!empty($batch_data)){
		    $batch_group = $batch_data->batch_group;
		    $batch_group2 = $batch_data->batch_group;
		    
		    if($batch_data->year_no == 1){
		        $year_no = '1st Year';
		    }else{
		        $year_no = '2nd Year';
		    }
		    if($batch_data->batch_group == 'A'){
        		$batch_group = "<span class='badge bg-green'>Science</span>";
        	}elseif($batch_data->batch_group == 'B'){
        		$batch_group = "<span class='badge bg-red'>Arts</span>";
        	}else{
        	    $batch_group = "<span class='badge bg-yellow'>Commerce</span>";
            }
		    $title .= $batch_data->batch_title;
		    $title .= ' '.$batch_data->batch_year;
		    $title .= ' -  '.$year_no ;
		    $title .= ' - Group: '.$batch_group;		    
		}else{
		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Invalid Batch ID!','msg_type' => 'error'));
			redirect("admin/batches");die;   
		}
		
		$pdata['title'] = $title;
		$pdata['batch_id'] = $batch_id;
		
		$pdata['batch_group'] = $batch_group2;
		
		$data = $this->session->flashdata('message');
		if(isset($data['msg_type'])){
		    $pdata['msg_type'] = $data['msg_type'];
		    $pdata['msg'] = $data['msg'];
		}
		
	   
		$pdata['LoadViews'] = "enrollment_form";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);
	}	
	
	public function student_form(){
	    $subToCodeArr = SubToCodeArr();
	    //GPrint($subToCodeArr);die;
		$this->CheckSession(true);
		$pdata = array();
		
		$uriData = $this->GetUriArray();
		$batch_id = '';
		$std_reg = '';
		$readonly = 'N';
		
		if(isset($uriData['std_reg'])){
			$std_reg = $uriData['std_reg'];
		}
		if(isset($uriData['readonly'])){
			$readonly = $uriData['readonly'];
		}
		
		$pdata['readonly'] = $readonly;
		
		
		//echo $std_reg;die;
		//$this->Mcommon_notice = new Mcommon_notice();
		//$pdata['noticeObj'] = $this->Mcommon_notice;
		
		$this->load->model("database/Mstudents");
		$this->Mstudents=new Mstudents();
		$stdObj = $this->Mstudents;
		if(!empty($std_reg)){
		    $this->Mstudents=new Mstudents();
    		$this->Mstudents->std_reg($std_reg);
    		if($this->Mstudents->Select()){
    		    $stdObj = $this->Mstudents;
    		}else{
    		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Invalid Batch or Student ID!','msg_type' => 'error'));
			redirect("admin/batches");die;   
    		}
		}
		
		$pdata['stdObj'] = $stdObj;
		
		
		
		if(isset($uriData['batch_id'])){
			$batch_id = $uriData['batch_id'];
		}
		
		if(empty($batch_id)){
			$this->session->set_flashdata('message', array('url' => 'home','msg' => 'Something went wrong!','msg_type' => 'error'));
			redirect("admin/batches");die;
		}
		$batch_group2 = 'A';
		$batch_data = '';
		$title = '';
		$this->load->model("database/Mbatch");
		$this->Mbatch->batch_id($batch_id);
		if($this->Mbatch->Select()){
		    $batch_data = $this->Mbatch;
		}
		
		if(!empty($batch_data)){
		    $batch_group = $batch_data->batch_group;
		    $batch_group2 = $batch_data->batch_group;
		    
		    if($batch_data->year_no == 1){
		        $year_no = '1st Year';
		    }else{
		        $year_no = '2nd Year';
		    }
		    if($batch_data->batch_group == 'A'){
        		$batch_group = "<span class='badge bg-green'>Science</span>";
        	}elseif($batch_data->batch_group == 'B'){
        		$batch_group = "<span class='badge bg-red'>Arts</span>";
        	}else{
        	    $batch_group = "<span class='badge bg-yellow'>Commerce</span>";
            }
		    $title .= $batch_data->batch_title;
		    $title .= ' '.$batch_data->batch_year;
		    $title .= ' -  '.$year_no ;
		    $title .= ' - Group: '.$batch_group;		    
		}else{
		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Invalid Batch ID!','msg_type' => 'error'));
			redirect("admin/batches");die;   
		}
		
		$pdata['title'] = $title;
		$pdata['batch_id'] = $batch_id;
		
		$pdata['batch_group'] = $batch_group2;
		
		$data = $this->session->flashdata('message');
		if(isset($data['msg_type'])){
		    $pdata['msg_type'] = $data['msg_type'];
		    $pdata['msg'] = $data['msg'];
		}
		
	
		$pdata['LoadViews'] = "student_form";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);
	}
	
	
	public function add_edit_std(){
	    
	    //$this->CheckSession(true);
	    $batch_id = $this->input->post("batch_id", true); 
	    $batch_group = $this->input->post("batch_group", true); 
	    $isEdit = $this->input->post("isEdit", true); 
	    $std_reg = $this->input->post("std_reg", true); 
	    $std_roll = $this->input->post("std_roll", true); 
	    $std_session = $this->input->post("std_session", true); 
		$name = $this->input->post("name", true);
	    $gender = $this->input->post("gender", true);
	    $std_mobile = $this->input->post("std_mobile", true); 
	    $email = $this->input->post("email", true); 
	    $fname = $this->input->post("fname", true); 
		$mname = $this->input->post("mname", true);
		
		$guardian_name = $this->input->post("guardian_name", true);
	    $guardian_mobile = $this->input->post("guardian_mobile", true);
	    $permanent_address = $this->input->post("permanent_address", true); 
	    $present_address = $this->input->post("present_address", true); 
	    $dob = $this->input->post("dob", true); 
		$ssc_equi = $this->input->post("ssc_equi", true);
		
		$ssc_board = $this->input->post("ssc_board", true); 
	    $passing_year = $this->input->post("passing_year", true); 
	    $cgpa = $this->input->post("cgpa", true); 
		$comments = $this->input->post("comments", true);
		
		$subArr = $this->input->post("subArr", true);
		$opt_ids = $this->input->post("opt_ids", true);
		
		
		$err_redirect_url = "admin/student_form/batch_id/$batch_id";
		if($isEdit == 'Y'){
		   $err_redirect_url = "admin/student_form/batch_id/$batch_id/std_reg/$std_reg"; 
		}
		
		$this->load->model("database/Mstudents");
		if($isEdit == 'N'){
		    $this->Mstudents=new Mstudents();
		    $this->Mstudents->std_reg($std_reg);
		    if($this->Mstudents->Select()){
		        $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Duplicate Registration ID. Please try again.','msg_type' => 'error'));
			    redirect($err_redirect_url); 
		    }
		}
		
		
		if(empty($subArr) || empty($opt_ids)){
		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Please select compulsory and optional subjects!','msg_type' => 'error'));
			redirect($err_redirect_url); 
		}
		
		if($batch_group == 'C'){
		    array_push($subArr,$opt_ids);
		}
		
		//GPrint($subArr); echo $opt_ids;die;
		
		$sub_number = count($subArr);
		
		if($sub_number != 4){
		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Please choose any 4 of selective subjects!','msg_type' => 'error'));
			redirect($err_redirect_url); 
		}
		
		if(!in_array($opt_ids, $subArr)){
				$this->session->set_flashdata('message', array('url' => 'home','msg' => 'Wrong selection of optional subjects. Please try again.','msg_type' => 'error'));
				redirect($err_redirect_url); 
		}
		
		
		$common_codes = '101,102,107,108,275,';
		$selective_codes = '';
		$subToCodeArr = SubToCodeArr();
		
		foreach($subArr as $sa){
		    if(isset($subToCodeArr[$sa])){
		       $selective_codes .=  $subToCodeArr[$sa] . ',';
		    }
		}
		$selective_codes = rtrim($selective_codes, ',');
		
		$opt_codes = '';
		if(isset($subToCodeArr[$opt_ids])){
		       $opt_codes =  $subToCodeArr[$opt_ids];
		}
		
		$final_sub_codes = $common_codes . $selective_codes;
		
		$final_sub_codesArr = explode (",", $final_sub_codes);
		$opt_codesArr = explode (",", $opt_codes);
		
		$count1 = count($final_sub_codesArr);
		$count2 = count($opt_codesArr);
		
		if($count1 != 13 || $count2 != 2){
		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Something went wrong!','msg_type' => 'error'));
			redirect($err_redirect_url); 
		}
		//$this->load->model("database/Mstudents");
		$this->Mstudents=new Mstudents();
		$this->Mstudents->batch_id($batch_id);
		$this->Mstudents->std_reg($std_reg);
		$this->Mstudents->std_roll($std_roll);
		$this->Mstudents->std_session($std_session);
		$this->Mstudents->sub_ids($final_sub_codes);
		$this->Mstudents->opt_ids($opt_codes);
		$this->Mstudents->name($name);
		$this->Mstudents->gender($gender);
		$this->Mstudents->std_mobile($std_mobile);
		$this->Mstudents->email($email);
		$this->Mstudents->fname($fname);
		$this->Mstudents->mname($mname);
		$this->Mstudents->guardian_name($guardian_name);
		$this->Mstudents->guardian_mobile($guardian_mobile);
		$this->Mstudents->permanent_address($permanent_address);
		$this->Mstudents->present_address($present_address);
		$this->Mstudents->dob($dob);
		$this->Mstudents->ssc_equi($ssc_equi);
		$this->Mstudents->ssc_board($ssc_board);
		$this->Mstudents->passing_year($passing_year);
		$this->Mstudents->cgpa($cgpa);
		$this->Mstudents->comments($comments);
		
		if($isEdit == 'N'){
    		if($this->Mstudents->Save()){
    		   $this->session->set_flashdata('message', array('url' => 'home','msg' => "Successfully Added.",'msg_type' => 'success'));
    		   redirect("admin/std_list/batch_id/$batch_id"); 
    		}else{
    		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Something went wrong!','msg_type' => 'error'));
    			redirect($err_redirect_url); 
    		}		    
		}else{
    		if($this->Mstudents->Update()){
    		   $this->session->set_flashdata('message', array('url' => 'home','msg' => "Successfully Updated.",'msg_type' => 'success'));
    		   redirect("admin/std_list/batch_id/$batch_id"); 
    		}else{
    		    $this->session->set_flashdata('message', array('url' => 'home','msg' => 'Something went wrong!','msg_type' => 'error'));
    			redirect($err_redirect_url); 
    		}		    
		}
	    redirect("admin/std_list/batch_id/$batch_id");
	}
	
	
	public function std_list(){
		$this->CheckSession(true);
		$session_data = $this->session->GetAdminData();
		//GPrint($session_data);die;
		
		$uriData = $this->GetUriArray();
		$batch_id = '';
		
		if(isset($uriData['batch_id'])){
			$batch_id = $uriData['batch_id'];
		}
		
		if(empty($batch_id)){
			$this->session->set_flashdata('message', array('url' => 'home','msg' => 'Something went wrong!','msg_type' => 'error'));
			redirect("admin/batches");die;
		}
		
		
		$pdata = array();
		
		$pdata['batch_id'] = $batch_id;
	
		
		$data = $this->session->flashdata('message');
		if(isset($data['msg_type'])){
		    $pdata['msg_type'] = $data['msg_type'];
		    $pdata['msg'] = $data['msg'];
		}
		
		
		
	
		$std_data = array();
		$this->load->model("database/Mstudents");
		$this->Mstudents->batch_id($batch_id);
		$std_data = $this->Mstudents->SelectAll("","std_roll","ASC");
		
		//GPrint($std_data);die;
		
		
		$batch_data = '';
		$this->load->model("database/Mbatch");
		$this->Mbatch->batch_id($batch_id);
		if($this->Mbatch->Select()){
		    $batch_data = $this->Mbatch;
		}
	
		//GPrint($batch_data->year_no);die;
	
        
       
		
	   // GPrint($masterArr);die;
		
		$title = '';
		
		if(!empty($batch_data)){
		    if($batch_data->year_no == 1){
		        $year_no = '1st Year';
		    }else{
		        $year_no = '2nd Year';
		    }
		    if($batch_data->batch_group == 'A'){
        		$batch_group = "<span class='badge bg-green'>Science</span>";
        	}elseif($batch_data->batch_group == 'B'){
        		$batch_group = "<span class='badge bg-red'>Arts</span>";
        	}else{
        	    $batch_group = "<span class='badge bg-yellow'>Commerce</span>";
            }
		    $title .= $batch_data->batch_title;
		    $title .= ' '.$batch_data->batch_year;
		    $title .= ' -  '.$year_no ;
		    $title .= ' - Group: '.$batch_group;
		}
		
	$pdata['title'] = $title;		
	
	   $pdata['batch_data'] = $batch_data;
		$pdata['std_data'] = $std_data;
		$pdata['session_data'] = $session_data;
		
	//	$pdata['LoadViews'] = "std_admit_print";
	
		$pdata['LoadViews'] = "std_list";
		$this->LoadView($pdata);
	}
	
	public function std_details(){
	    $uriData = $this->GetUriArray();
		$std_reg = '';
		
		if(isset($uriData['std_reg'])){
			$std_reg = $uriData['std_reg'];
		}
		
		if(empty($std_reg)){
			$this->session->set_flashdata('message', array('url' => 'home','msg' => 'Something went wrong!','msg_type' => 'error'));
			redirect("admin/batches");die;
		}
		
		$std_data = array();
		$this->load->model("database/Mstudents");
		$this->Mstudents->std_reg($std_reg);
		if($this->Mstudents->Select()){
		    $std_data = $this->Mstudents;
		}
		
		$pdata['std_data'] = $std_data;
	
		$pdata['LoadViews'] = "std_details";
		$this->LoadView($pdata);
		
	
	}
	

	
	public function course_std_excel(){
        $this->CheckSession(true);
		$pdata = array();
		$uriData = $this->GetUriArray();
		$batch_id = '';
		$year_no = '';
		$year_name='';
		$group_name='';
		$std_reg = '';
		$group='';
		
		$examArr = array('1'=>'First Terminal','2'=>'Promotion Test','3'=>'Test Exam');
		$grpArr = array('A'=>'Science','B'=>'Arts','C'=>'Commerce');
		
		
		if(isset($uriData['batch_id'])){
			$batch_id = $uriData['batch_id'];
		}
		
		if(isset($uriData['year_no'])){
			$year_no = $uriData['year_no'];
		}
        //https://www.ichhamatidegreecollege.edu.bd/idcm/admin/course_std_excel
        
        $year_name=$examArr[$year_no];
        //echo $batch_id.'-'.$year_name; die;
        
        
        $query_std = "SELECT st.std_reg, st.std_roll, st.std_session, st.name, st.fname, st.mname,st.permanent_address,st.std_session,st.sub_ids,st.opt_ids,st.gender,st.dob,st.std_mobile, bt.batch_year,bt.batch_group FROM students as st 
                        LEFT JOIN batch AS bt ON bt.batch_id=st.batch_id
                        WHERE st.batch_id=$batch_id ORDER BY st.std_roll ASC";
        $records = $this->db->query($query_std);
        $std_data = $records->result();
        
        //Gprint($std_data);die;
        //echo $std_data[0]->batch_group;die;
        $group=$std_data[0]->batch_group;
        
        $group_name=$grpArr[$group];
        //Gprint($group_name.$std_data->batch_group );die;
		
		
		$this->load->library("excel");
		$object = new PHPExcel();
		
		$object->setActiveSheetIndex(0);
		
		$from = "A1"; // or any value
		$to = "L5"; // or any value
		$object->getActiveSheet()->getStyle("$from:$to")->getFont()->setBold( true );
		$object->getActiveSheet()->getStyle("A5:L5")->getFont()->setBold( true );
		$object->getActiveSheet()->setTitle('Students Info');//Left below corner TAB name
		
		$table_columns = array("Roll Number", "Registration Number","Session", "Student's Name", "Father's Name", "Mother's Name","Address", "Mobile", "Sub Code", "Opt. Sub", "Gender", "DOB");
		
	
		
		$title1 = 'Ichhamati Degree College, Ranirbandar, Dinajpur';
		$hsc='Higher Secondary Certificate';
		$title2 = 'Year: '.$std_data[0]->batch_year;
		$title3 = 'Group: '.$group_name;
		
		
		
		
		
		$object->getActiveSheet()->setCellValueByColumnAndRow(0, 1, $title1);
		$object->getActiveSheet()->setCellValueByColumnAndRow(0, 2, $hsc);
		$object->getActiveSheet()->setCellValueByColumnAndRow(0, 3, $title2);
		$object->getActiveSheet()->setCellValueByColumnAndRow(0, 4, $title3);
		$object->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
		$object->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
		$object->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
		$column = 0;
		
		foreach($table_columns as $field){
			$object->getActiveSheet()->setCellValueByColumnAndRow($column, 5, $field);
			$column++;
		}
		
		$excel_row = 6;
		foreach ($std_data as $sd){
			$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $sd->std_roll);
			$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $sd->std_reg);
			$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $sd->std_session);
			$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $sd->name);
			$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $sd->fname);
			$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $sd->mname);
			$object->getActiveSheet()->setCellValueByColumnAndRow(6, $excel_row, $sd->permanent_address);
			$object->getActiveSheet()->setCellValueByColumnAndRow(7, $excel_row, $sd->std_mobile);
			$object->getActiveSheet()->setCellValueByColumnAndRow(8, $excel_row, $sd->sub_ids);
			$object->getActiveSheet()->setCellValueByColumnAndRow(9, $excel_row, $sd->opt_ids);
			$object->getActiveSheet()->setCellValueByColumnAndRow(10, $excel_row, $sd->gender);
			$object->getActiveSheet()->setCellValueByColumnAndRow(11, $excel_row, $sd->dob);
	
			$excel_row++;			
		}

		
		
		$filename = 'HSC_'.$std_data[0]->batch_year.'_'.$group_name.'.xls';
		
	//	Gprint($object);die;
	    ob_end_clean();
		$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel5');
		header('Content-Type: application/vnd.ms-excel');
		header("Content-Disposition: attachment;filename=$filename");
		$object_writer->save('php://output');
	}
	
	
	
	public function batches(){
		$this->CheckSession(true);
		$pdata = array();
		$pdata['title'] = "Notice Board";
		
		$data = $this->session->flashdata('message');
		if(isset($data['msg_type'])){
		    $pdata['msg_type'] = $data['msg_type'];
		    $pdata['msg'] = $data['msg'];
		}
		
	
		$batch_data = array();
		$this->load->model("database/Mbatch");
		$batch_data = $this->Mbatch->SelectAll("","batch_id","desc");
	
		if(empty($batch_data)){
			$batch_data = array();
		}
	
		$pdata['batch_data'] = $batch_data;
	
		$pdata['LoadViews'] = "batches";
		$this->LoadView($pdata);
	}
	
	public function add_edit_batch(){

		$batch_id = $this->input->post("batch_id", true); 
		$isEdit = $this->input->post("isEdit", true);
	    $batch_title = $this->input->post("batch_title", true);
	    $batch_year = $this->input->post("batch_year", true); 
	    $year_no = $this->input->post("year_no", true); 
	    $batch_group = $this->input->post("batch_group", true); 
		$status = $this->input->post("status", true);
		

		$this->load->model("database/Mbatch");
	
		if($isEdit == 'N'){
			$this->Mbatch=new Mbatch();
			$this->Mbatch->batch_title($batch_title);
			$this->Mbatch->batch_year($batch_year);
			$this->Mbatch->year_no($year_no);
			$this->Mbatch->batch_group($batch_group);
			$this->Mbatch->status($status);
			$this->Mbatch->Save();
			$this->session->set_flashdata('message', array('url' => 'home','msg' => "Successfully Added.",'msg_type' => 'success'));
			redirect("admin/batches");
		}
		
		if($isEdit == 'Y'){
			$this->Mbatch=new Mbatch();
			$this->Mbatch->batch_id($batch_id);
			$this->Mbatch->batch_title($batch_title);
			$this->Mbatch->batch_year($batch_year);
			$this->Mbatch->year_no($year_no);
			$this->Mbatch->batch_group($batch_group);
			$this->Mbatch->status($status);
			$this->Mbatch->Update();
			
			$this->session->set_flashdata('message', array('url' => 'home','msg' => "Successfully Updated.",'msg_type' => 'success'));
			redirect("admin/batches");
		}
	
		redirect("admin/batches");
	}
	
	
    public function getBatchInfo(){
		$batch_id = $_REQUEST["batch_id"];
		$records = array();
		$this->load->model("database/Mbatch");
		$this->Mbatch->batch_id($batch_id);
		if($this->Mbatch->Select()){
			$records = $this->Mbatch;
		}
		//GPrint($records);
		echo json_encode($records);
	}
	
	
	
	public function notice_board(){
		$this->CheckSession(true);
		$pdata = array();
		$pdata['title'] = "Notice Board";
		
		$data = $this->session->flashdata('message');
		if(isset($data['msg_type'])){
		    $pdata['msg_type'] = $data['msg_type'];
		    $pdata['msg'] = $data['msg'];
		}
		
	
		$notice_data = array();
		$this->load->model("database/Mcommon_notice");
		//$this->Mcommon_notice->status('A');
		//$notice_data = $this->Mcommon_notice->selectAll("","creation_date","desc");
		$notice_data = $this->Mcommon_notice->SelectAll("","id","desc");
	
		if(empty($notice_data)){
			$notice_data = array();
		}
	
		$pdata['notice_data'] = $notice_data;
	
	
		$this->Mcommon_notice = new Mcommon_notice();
		$pdata['noticeObj'] = $this->Mcommon_notice;
		$pdata['LoadViews'] = "notice_board";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);
	}
	
	public function page_content(){
		$this->CheckSession(true);
		$pdata = array();
		$pdata['title'] = "Results & Forms";
		
		$data = $this->session->flashdata('message');
		if(isset($data['msg_type'])){
		    $pdata['msg_type'] = $data['msg_type'];
		    $pdata['msg'] = $data['msg'];
		}
	
		$content_all = array();
		$this->load->model("database/Mcontent");
		$this->Mcontent->cid(1);
		if($this->Mcontent->Select()){
		    $content_all = $this->Mcontent;
		}
	
		if(empty($content_all)){
			$content_all = array();
		}
	
		$pdata['content_all'] = $content_all;
	
	
		$pdata['LoadViews'] = "page_content";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);
	}	
	
	public function update_page_content(){
		$page_name = $this->input->post("page_name", true); 
		$page_content = $this->input->post("page_content", true);
		$this->load->model("database/Mcontent");
		$this->Mcontent=new Mcontent();
		$this->Mcontent->cid(1);
		$this->Mcontent->$page_name($page_content);
		$this->Mcontent->Update();
		$this->session->set_flashdata('message', array('url' => 'home','msg' => "Successfully Updated.",'msg_type' => 'success'));
		redirect("admin/page_content");
	}
	
	public function res_forms(){
		$this->CheckSession(true);
		$pdata = array();
		$pdata['title'] = "Results & Forms";
		
		$data = $this->session->flashdata('message');
		if(isset($data['msg_type'])){
		    $pdata['msg_type'] = $data['msg_type'];
		    $pdata['msg'] = $data['msg'];
		}
		
	
		$res_data = array();
		$this->load->model("database/Mres_and_forms");
		$res_data = $this->Mres_and_forms->SelectAll("","rid","desc");
	
		if(empty($res_data)){
			$res_data = array();
		}
	
		$pdata['res_data'] = $res_data;
	
	
		$pdata['LoadViews'] = "res_forms";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);
	}	
	
	public function teachers(){
		$this->CheckSession(true);
		$pdata = array();
		$pdata['title'] = "Teachers";
		
		$data = $this->session->flashdata('message');
		if(isset($data['msg_type'])){
		    $pdata['msg_type'] = $data['msg_type'];
		    $pdata['msg'] = $data['msg'];
		}
		
        $query_tr_data = "SELECT t.*,d.dept_name FROM teachers AS t 
                            LEFT JOIN department AS d ON d.dept_id = t.dept_id
                            ORDER BY t.rank ASC;";
		$records_tr_data = $this->db->query($query_tr_data);
		$tr_data = $records_tr_data->result();
		
		
		if (is_array($tr_data) || is_object($tr_data)){
			$pdata['tr_data'] = $tr_data;
		}else{
			$pdata['tr_data'] = array();
		}
		
		
		$query_dept = "SELECT * FROM department";
		$records = $this->db->query($query_dept);
		$dept_data = $records->result();
	
		$dept_options = '<option value="">--Select--</option>';
		if (is_array($dept_data) || is_object($dept_data)){
			foreach ($dept_data as $dd){
				$dept_options .= "<option value='$dd->dept_id'>$dd->dept_name</option>";
			}
		}
	
		$pdata['dept_options'] = $dept_options;
		
	
		$pdata['LoadViews'] = "teachers";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);
	}
	
	public function events(){
		$this->CheckSession(true);
		$pdata = array();
		$data = $this->session->flashdata('message');
		if(isset($data['msg_type'])){
		    $pdata['msg_type'] = $data['msg_type'];
		    $pdata['msg'] = $data['msg'];
		}
		
		$pdata['title'] = "News_Events";
		//echo "dffd";die;
		$events_data = array();
		$this->load->model("database/Mevents");
		$this->Mevents=new Mevents();
		$events_data = $this->Mevents->SelectAll("","ev_id","desc");
	    //GPrint($events_data);die;
		if(empty($events_data)){
			$events_data = array();
		}
	
		$pdata['events_data'] = $events_data;
	
	
		
		$pdata['LoadViews'] = "events";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);
	}
	
	
	
	
	
	
	public function images(){
	   
		$this->CheckSession(true);
		$pdata = array();
		$data = $this->session->flashdata('message');
		if(isset($data['msg_type'])){
		    $pdata['msg_type'] = $data['msg_type'];
		    $pdata['msg'] = $data['msg'];
		}
		
		
		
		$img_data = array();
		$this->load->model("database/Mimages");
		$this->Mimages = new Mimages();
		$img_data = $this->Mimages->selectAll("","img_id","desc");
	
		if(empty($img_data)){
			$img_data = array();
		}
		$pdata['img_data'] = $img_data;
	
		$pdata['LoadViews'] = "images";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);
	}
	
    public function add_edit_image(){
		//GPrint($_POST);die;
		$isEdit = $this->input->post("isEdit", true);
		$hidden_img_id = $this->input->post("hidden_img_id", true);
		$status = $this->input->post("status", true);
		$img_type = $this->input->post("img_type", true);

		$this->load->model("database/Mimages");
	
		if($isEdit == 'N'){
			if($_FILES['file_upload']['error']==0){
				$original_file_name = $_FILES['file_upload']['name'];
				$ext = pathinfo($original_file_name, PATHINFO_EXTENSION);
				if($ext != 'jpg'){
					$this->session->set_flashdata('message', array('url' => 'home','msg' => "Only jpg file is acceptable.",'msg_type' => 'error'));
					redirect("admin/images");
				}
				$this->Mimages=new Mimages();
				$this->Mimages->img_type($img_type);
				$this->Mimages->status($status);
				$this->Mimages->Save();
				$rid = $this->Mimages->GetUpdateDB()->insert_id();
				
				if($img_type == 'G'){
				    $folder_name = base_url().'img/gallery/';
				}elseif($img_type == 'S'){
				    $folder_name = base_url().'img/slide/';  
				}else{
				    $folder_name = base_url().'img/others/';  
				}
				
				$down_link = $folder_name .$rid.'.'.$ext;
				$down_file_name = $rid.'.'.$ext;
				
				if($img_type == 'G'){
				    $physical_link = BASEPATH."../img/gallery/$down_file_name";
				}elseif($img_type == 'S'){
				    $physical_link = BASEPATH."../img/slide/$down_file_name";
				}else{
				    $physical_link = BASEPATH."../img/others/$down_file_name";
				}
					
			
				if(file_exists($physical_link)){
					unlink($physical_link);
				}
				if(copy($_FILES['file_upload']['tmp_name'], $physical_link)){
					$this->session->set_flashdata('message', array('url' => 'home','msg' => "Image upload Successfull.",'msg_type' => 'success'));
					redirect("admin/images");
				}else{
					$this->session->set_flashdata('message', array('url' => 'home','msg' => "Failed to upload image.",'msg_type' => 'error'));
					redirect("admin/images");
				}
			}else{
				redirect("admin/images");
			}
		}
		
		if($isEdit == 'Y'){
			$this->Mimages=new Mimages();
			$this->Mimages->img_id($hidden_img_id);
			$this->Mimages->img_type($img_type);
			$this->Mimages->status($status);
			$this->Mimages->Update();
			if($_FILES['file_upload']['error']==0){
				$original_file_name = $_FILES['file_upload']['name'];
				$ext = pathinfo($original_file_name, PATHINFO_EXTENSION);
				if($ext != 'jpg'){
					$this->session->set_flashdata('message', array('url' => 'home','msg' => "Only jpg file is acceptable.",'msg_type' => 'error'));
					redirect("admin/images");
				}
				$down_file_name = $hidden_img_id.'.'.$ext;
				if($img_type == 'G'){
				    $physical_link = BASEPATH."../img/gallery/$down_file_name";
				}elseif($img_type == 'S'){
				    $physical_link = BASEPATH."../img/slide/$down_file_name";
				}else{
				    $physical_link = BASEPATH."../img/others/$down_file_name";
				}
				
				if(file_exists($physical_link)){
					unlink($physical_link);
				}
				if(copy($_FILES['file_upload']['tmp_name'], $physical_link)){
					$this->session->set_flashdata('message', array('url' => 'home','msg' => "Image upload Successfull.",'msg_type' => 'success'));
					redirect("admin/images");
				}else{
					$this->session->set_flashdata('message', array('url' => 'home','msg' => "Failed to upload Image.",'msg_type' => 'error'));
					redirect("admin/images");
				}
			}
			$this->session->set_flashdata('message', array('url' => 'home','msg' => "Successfully Updated.",'msg_type' => 'success'));
			redirect("admin/images");
		}
		
	
		redirect("admin/images");
	}
	
    public function add_teacher_file(){
        $type = $this->input->post("type", true);
		$teacher_id = $this->input->post("teacher_id", true);
			
			if($_FILES['file_upload']['error']==0){
				$original_file_name = $_FILES['file_upload']['name'];
				$ext = pathinfo($original_file_name, PATHINFO_EXTENSION);
				if($type == 'img'){
				    if($ext != 'jpg'){
    					$this->session->set_flashdata('message', array('url' => 'home','msg' => "Only jpg file is acceptable.",'msg_type' => 'error'));
    					redirect("admin/teachers");
				    }
				}
				
				if($type == 'cv'){
				    if($ext != 'pdf'){
    					$this->session->set_flashdata('message', array('url' => 'home','msg' => "Only pdf file is acceptable.",'msg_type' => 'error'));
    					redirect("admin/teachers");
				    }
				}
				
				
				if($type == 'img'){
				    $folder_name = base_url().'img/teachers/';
				}else{
				    $folder_name = base_url().'files/cv';  
				}
				
				$down_link = $folder_name .$teacher_id.'.'.$ext;
				$down_file_name = $teacher_id.'.'.$ext;
				
				if($type == 'img'){
				    $physical_link = BASEPATH."../img/teachers/$down_file_name";
				}else{
				    $physical_link = BASEPATH."../files/cv/$down_file_name";
				}
					
			
				if(file_exists($physical_link)){
					unlink($physical_link);
				}
				if(copy($_FILES['file_upload']['tmp_name'], $physical_link)){
					$this->session->set_flashdata('message', array('url' => 'home','msg' => "File upload Successfull.",'msg_type' => 'success'));
					redirect("admin/teachers");
				}else{
					$this->session->set_flashdata('message', array('url' => 'home','msg' => "Failed to upload.",'msg_type' => 'error'));
					redirect("admin/teachers");
				}
			}else{
				redirect("admin/teachers");
			}		
	}	


	public function getTeacherInfo(){
		$teacher_id = $_REQUEST["teacher_id"];
		$records = array();
		$this->load->model("database/Mteachers");
		$this->Mteachers->teacher_id($teacher_id);
		if($this->Mteachers->Select()){
			$records = $this->Mteachers;
		}
		echo json_encode($records);
	}
	
	 public function add_edit_teacher(){


		$teacher_id = $this->input->post("teacher_id", true); 
		$isEdit = $this->input->post("isEdit", true);
	    $name = $this->input->post("name", true);
	    $designation = $this->input->post("designation", true); 
	    $gender = $this->input->post("gender", true); 
	    $dept_id = $this->input->post("dept_id", true); 
	    $mobile_no = $this->input->post("mobile_no", true);
	    $rank = $this->input->post("rank", true); 
	    $email = $this->input->post("email", true);
	    $type = $this->input->post("type", true);
		$status = $this->input->post("status", true);
		$short_bio = $this->input->post("short_bio", true);
		

		$this->load->model("database/Mteachers");
	
		if($isEdit == 'N'){
			$this->Mteachers=new Mteachers();
			$this->Mteachers->name($name);
			$this->Mteachers->designation($designation);
			$this->Mteachers->mobile_no($mobile_no);
			$this->Mteachers->rank($rank);
			$this->Mteachers->gender($gender);
			$this->Mteachers->dept_id($dept_id);
			$this->Mteachers->email($email);
			$this->Mteachers->short_bio($short_bio);
			$this->Mteachers->type($type);
			$this->Mteachers->status($status);
			$this->Mteachers->Save();
			$this->session->set_flashdata('message', array('url' => 'home','msg' => "Successfully Added.",'msg_type' => 'success'));
			redirect("admin/teachers");
		}
		
		if($isEdit == 'Y'){
			$this->Mteachers=new Mteachers();
			$this->Mteachers->teacher_id($teacher_id);
			$this->Mteachers->name($name);
			$this->Mteachers->designation($designation);
			$this->Mteachers->mobile_no($mobile_no);
			$this->Mteachers->rank($rank);
			$this->Mteachers->gender($gender);
			$this->Mteachers->dept_id($dept_id);
			$this->Mteachers->email($email);
			$this->Mteachers->short_bio($short_bio);
			$this->Mteachers->type($type);
			$this->Mteachers->status($status);
			$this->Mteachers->Update();
			
			$this->session->set_flashdata('message', array('url' => 'home','msg' => "Successfully Updated.",'msg_type' => 'success'));
			redirect("admin/teachers");
		}
	
		redirect("admin/teachers");
	}	

	
	public function add_edit_results_and_forms(){
		//GPrint($_POST);die;
		$rid = $this->input->post("rid", true); 
		$isEdit = $this->input->post("isEdit", true);
	    $rtitle = $this->input->post("rtitle", true);
	    $rtype = $this->input->post("rtype", true);
	    $rdate = $this->input->post("rdate", true); 
	    $file_upload = $this->input->post("file_upload", true);
		$status = $this->input->post("status", true);

		$this->load->model("database/Mres_and_forms");
	
		if($isEdit == 'N'){
			if($_FILES['file_upload']['error']==0){
				$original_file_name = $_FILES['file_upload']['name'];
				$ext = pathinfo($original_file_name, PATHINFO_EXTENSION);
				//echo $ext;die;
				if($ext != 'pdf'){
					$this->session->set_flashdata('message', array('url' => 'home','msg' => "Only pdf file is acceptable.",'msg_type' => 'error'));
					redirect("admin/res_forms");
				}
				$this->Mres_and_forms=new Mres_and_forms();
				$this->Mres_and_forms->rtitle($rtitle);
				$this->Mres_and_forms->rtype($rtype);
				$this->Mres_and_forms->rdate($rdate);
				$this->Mres_and_forms->status($status);
				$this->Mres_and_forms->Save();
				$rid = $this->Mres_and_forms->GetUpdateDB()->insert_id();
			
				$folder_name = base_url().'files/res_forms/';
				
				$down_link = $folder_name .$rid.'.'.$ext;
				$down_file_name = $rid.'.'.$ext;
		
				$physical_link = BASEPATH."../files/res_forms/$down_file_name";
			
				if(file_exists($physical_link)){
					unlink($physical_link);
				}
				if(copy($_FILES['file_upload']['tmp_name'], $physical_link)){
					$this->session->set_flashdata('message', array('url' => 'home','msg' => "File upload Successfull.",'msg_type' => 'success'));
					redirect("admin/res_forms");
				}else{
					$this->session->set_flashdata('message', array('url' => 'home','msg' => "Failed to upload file.",'msg_type' => 'error'));
					redirect("admin/res_forms");
				}
			}else{
				redirect("admin/res_forms");
			}
		}
		
		if($isEdit == 'Y'){
			$this->Mres_and_forms=new Mres_and_forms();
			
			$this->Mres_and_forms->rid($rid);
			$this->Mres_and_forms->rtitle($rtitle);
			$this->Mres_and_forms->rtype($rtype);
			$this->Mres_and_forms->rdate($rdate);
			$this->Mres_and_forms->status($status);
	
			$this->Mres_and_forms->Update();
			if($_FILES['file_upload']['error']==0){
				$original_file_name = $_FILES['file_upload']['name'];
				$ext = pathinfo($original_file_name, PATHINFO_EXTENSION);
				if($ext != 'pdf'){
					$this->session->set_flashdata('message', array('url' => 'home','msg' => "Only PDF file is acceptable.",'msg_type' => 'error'));
					redirect("admin/res_forms");
				}
				$down_file_name = $rid.'.'.$ext;
				$physical_link = BASEPATH."../files/res_forms/$down_file_name";
			
				
				if(file_exists($physical_link)){
					unlink($physical_link);
				}
				if(copy($_FILES['file_upload']['tmp_name'], $physical_link)){
					$this->session->set_flashdata('message', array('url' => 'home','msg' => "File upload Successfull.",'msg_type' => 'success'));
					redirect("admin/res_forms");
				}else{
					$this->session->set_flashdata('message', array('url' => 'home','msg' => "Failed to upload pdf.",'msg_type' => 'error'));
					redirect("admin/res_forms");
				}
			}
			$this->session->set_flashdata('message', array('url' => 'home','msg' => "Successfully Updated.",'msg_type' => 'success'));
			redirect("admin/res_forms");
		}
		redirect("admin/res_forms");
	}
	
   
	
	 public function add_edit_event(){
		//GPrint($_POST);die;
		$ev_id = $this->input->post("ev_id", true); 
		$isEdit = $this->input->post("isEdit", true);
	    $ev_title = $this->input->post("ev_title", true);
	    $ev_desc = $this->input->post("ev_desc", true); 
	    $file_upload = $this->input->post("file_upload", true);
	    $event_date = $this->input->post("ev_date", true); 
		$status = $this->input->post("status", true);
		
		//echo $event_date;die;

		$this->load->model("database/Mevents");
	
		if($isEdit == 'N'){
			if($_FILES['file_upload']['error']==0){
				$original_file_name = $_FILES['file_upload']['name'];
				$ext = pathinfo($original_file_name, PATHINFO_EXTENSION);
				//echo $ext;die;
				if($ext != 'jpg'){
					$this->session->set_flashdata('message', array('url' => 'home','msg' => "Only jpg file is acceptable.",'msg_type' => 'error'));
					redirect("admin/events");
				}
				$this->Mevents=new Mevents();
				$this->Mevents->ev_title($ev_title);
				$this->Mevents->ev_desc($ev_desc);
				$this->Mevents->ev_date($event_date);
				$this->Mevents->status($status);
				$this->Mevents->Save();
				$rid = $this->Mevents->GetUpdateDB()->insert_id();
			
				$folder_name = base_url().'img/event/';
				
				$down_link = $folder_name .$rid.'.'.$ext;
				$down_file_name = $rid.'.'.$ext;
		
				$physical_link = BASEPATH."../img/event/$down_file_name";
			
				if(file_exists($physical_link)){
					unlink($physical_link);
				}
				if(copy($_FILES['file_upload']['tmp_name'], $physical_link)){
					$this->session->set_flashdata('message', array('url' => 'home','msg' => "Image upload Successfull.",'msg_type' => 'success'));
					redirect("admin/events");
				}else{
					$this->session->set_flashdata('message', array('url' => 'home','msg' => "Failed to upload image.",'msg_type' => 'error'));
					redirect("admin/events");
				}
			}else{
				redirect("admin/events");
			}
		}
		
		if($isEdit == 'Y'){
			$this->Mevents=new Mevents();
			
			$this->Mevents->ev_id($ev_id);
			$this->Mevents->ev_title($ev_title);
			$this->Mevents->ev_desc($ev_desc);
			$this->Mevents->ev_date($event_date);
			$this->Mevents->status($status);
	
			$this->Mevents->Update();
			if($_FILES['file_upload']['error']==0){
				$original_file_name = $_FILES['file_upload']['name'];
				$ext = pathinfo($original_file_name, PATHINFO_EXTENSION);
				if($ext != 'jpg'){
					$this->session->set_flashdata('message', array('url' => 'home','msg' => "Only jpg file is acceptable.",'msg_type' => 'error'));
					redirect("admin/images");
				}
				$down_file_name = $ev_id.'.'.$ext;
				$physical_link = BASEPATH."../img/event/$down_file_name";
			
				
				if(file_exists($physical_link)){
					unlink($physical_link);
				}
				if(copy($_FILES['file_upload']['tmp_name'], $physical_link)){
					$this->session->set_flashdata('message', array('url' => 'home','msg' => "Image upload Successfull.",'msg_type' => 'success'));
					redirect("admin/events");
				}else{
					$this->session->set_flashdata('message', array('url' => 'home','msg' => "Failed to upload Image.",'msg_type' => 'error'));
					redirect("admin/events");
				}
			}
			$this->session->set_flashdata('message', array('url' => 'home','msg' => "Successfully Updated.",'msg_type' => 'success'));
			redirect("admin/events");
		}
		redirect("admin/events");
	}	
	
	
	public function getUploadImage(){
		$img_id = $_REQUEST["img_id"];
		$records = array();
		$this->load->model("database/Mimages");
		$this->Mimages=new Mimages();
		$this->Mimages->img_id($img_id);
		if($this->Mimages->Select()){
			$records = $this->Mimages;
		}
		echo json_encode($records);
	}
	
	
	public function getSingleNotice(){
		$notice_id = $_REQUEST["notice_id"];
		$records = array();
		$this->load->model("database/Mcommon_notice");
		$this->Mcommon_notice->id($notice_id);
		if($this->Mcommon_notice->Select()){
			$records = $this->Mcommon_notice;
		}
		echo json_encode($records);
	}
	

	
	public function getSingleEvent(){
		$ev_id = $_REQUEST["ev_id"];
		$records = array();
		$this->load->model("database/Mevents");
		$this->Mevents->ev_id($ev_id);
		if($this->Mevents->Select()){
			$records = $this->Mevents;
		}
		//GPrint($records);
		echo json_encode($records);
	}
	
	public function getResultForm(){
		$rid = $_REQUEST["rid"];
		$records = array();
		$this->load->model("database/Mres_and_forms");
		$this->Mres_and_forms->rid($rid);
		if($this->Mres_and_forms->Select()){
			$records = $this->Mres_and_forms;
		}
		//GPrint($records);
		echo json_encode($records);
	}
	
	public function add_edit_common_notice(){
		$this->CheckSession(true);
		$this->load->model("database/Mcommon_notice");
		$isEdit = $this->input->post("isEdit", true);
		$notice_id = $this->input->post("notice_id", true);
		
		if($isEdit == 'N' && $notice_id == 'N'){
			if($this->Mcommon_notice->GetFromPostData()){
				if($this->Mcommon_notice->Save()){
				    $notice_id = $this->Mcommon_notice->GetUpdateDB()->insert_id();
				    $this->session->set_flashdata('message', array('url' => 'home','msg' => "Successfully added.",'msg_type' => 'success'));
					//redirect("admin/notice_board");
				}
			}
		}
		if($isEdit == 'Y' && !empty($notice_id)){
			$this->Mcommon_notice->id($notice_id);
			if($this->Mcommon_notice->Select()){
				if($this->Mcommon_notice->GetFromPostData()){
					$this->Mcommon_notice->id($notice_id);
					if($this->Mcommon_notice->Update()){
					    $this->session->set_flashdata('message', array('url' => 'home','msg' => "Successfully added.",'msg_type' => 'success'));
						//redirect("admin/notice_board");
					}
				}
		
			}
		}
			if($_FILES['file_upload']['error']==0){
				$original_file_name = $_FILES['file_upload']['name'];
				$ext = pathinfo($original_file_name, PATHINFO_EXTENSION);
				if($ext != 'pdf'){
					$this->session->set_flashdata('message', array('url' => 'home','msg' => "Only jpg file is acceptable.",'msg_type' => 'error'));
					redirect("admin/notice_board");
				}
				
				$folder_name = base_url().'files/notice/';
				$down_link = $folder_name .$notice_id.'.'.$ext;
				$down_file_name = $notice_id.'.'.$ext;
				$physical_link = BASEPATH."../files/notice/$down_file_name";
			
				if(file_exists($physical_link)){
					unlink($physical_link);
				}
				if(copy($_FILES['file_upload']['tmp_name'], $physical_link)){
					$this->session->set_flashdata('message', array('url' => 'home','msg' => "Successfully added.",'msg_type' => 'success'));
				}else{
					$this->session->set_flashdata('message', array('url' => 'home','msg' => "Failed to upload.",'msg_type' => 'error'));
				}
			}		
		redirect("admin/notice_board");		
	}
	
	
	public function bookings(){
		$this->load->model("database/Mbooking");
		$this->Mbooking = new Mbooking();
		//$booking_data = $this->Mbooking->SelectAll();
		//$booking_data = $this->Mbooking->SelectJoin("", $orderBy = 'booking_id', $order = 'desc');
		
		//SELECT `booking`.*, `rt`.`rtype_name` FROM (`booking`) LEFT JOIN `room_type` AS rt ON `rt`.`rtype_id`=`booking`.`rtype_id` ORDER BY `booking_id` desc
		
		$query_booking = "SELECT `booking`.*, `rt`.`rtype_name` FROM (`booking`) 
							LEFT JOIN `room_type` AS rt ON `rt`.`rtype_id`=`booking`.`rtype_id` 
							WHERE booking.status != 'R'
							ORDER BY `booking_id` desc;";
		$records_booking = $this->db->query($query_booking);
		$booking_data = $records_booking->result();
		
		
		if (is_array($booking_data) || is_object($booking_data)){
			$pdata['booking_data'] = $booking_data;
		}else{
			$pdata['booking_data'] = array();
		}
		$this->load->model("database/Mroom_type");
		$this->Mroom_type = new Mroom_type();
		$rtype_data = $this->Mroom_type->SelectAll();
		if (is_array($rtype_data) || is_object($rtype_data)){
			$pdata['rtype_data'] = $rtype_data;
		}else{
			$pdata['rtype_data'] = array();
		}
		
		
	
		$pdata['title'] = "Booking";
		$pdata['sub_title'] = "Booking";
		$pdata['LoadViews'] = "booking";
		$this->LoadView($pdata);
	}
	
	public function archive(){
		$this->load->model("database/Mbooking");
		$this->Mbooking = new Mbooking();
		//$booking_data = $this->Mbooking->SelectAll();
		//$booking_data = $this->Mbooking->SelectJoin("", $orderBy = 'booking_id', $order = 'desc');
		
		//SELECT `booking`.*, `rt`.`rtype_name` FROM (`booking`) LEFT JOIN `room_type` AS rt ON `rt`.`rtype_id`=`booking`.`rtype_id` ORDER BY `booking_id` desc
		
		$query_booking = "SELECT `booking`.*, `rt`.`rtype_name` FROM (`booking`) 
							LEFT JOIN `room_type` AS rt ON `rt`.`rtype_id`=`booking`.`rtype_id` 
							WHERE booking.status = 'R'
							ORDER BY `booking_id` desc;";
		$records_booking = $this->db->query($query_booking);
		$booking_data = $records_booking->result();
		
		
		if (is_array($booking_data) || is_object($booking_data)){
			$pdata['booking_data'] = $booking_data;
		}else{
			$pdata['booking_data'] = array();
		}
		$this->load->model("database/Mroom_type");
		$this->Mroom_type = new Mroom_type();
		$rtype_data = $this->Mroom_type->SelectAll();
		if (is_array($rtype_data) || is_object($rtype_data)){
			$pdata['rtype_data'] = $rtype_data;
		}else{
			$pdata['rtype_data'] = array();
		}
		
		$pdata['title'] = "Booking";
		$pdata['sub_title'] = "Booking";
		$pdata['LoadViews'] = "archive_page";
		$this->LoadView($pdata);
	}
	
	
	
	public function room_types(){
		$this->load->model("database/Mroom_type");
		$this->Mroom_type = new Mroom_type();
		$rtype_data = $this->Mroom_type->SelectAll();
		if (is_array($rtype_data) || is_object($rtype_data)){
			$pdata['rtype_data'] = $rtype_data;
		}else{
			$pdata['rtype_data'] = array();
		}
	
		$pdata['title'] = "Room Type";
		$pdata['sub_title'] = "Room Type";
		$pdata['LoadViews'] = "room_type";
		$this->LoadView($pdata);
	}	
	
	public function add_edit_room_type(){
		$this->CheckSession(true);
		$this->load->model("database/Mroom_type");
		$isEdit = $this->input->post("isEdit", true);
		$rtype_id = $this->input->post("hidden_rtype_id", true);
	
		if($isEdit == 'N' && $rtype_id == 'N'){
			if($this->Mroom_type->GetFromPostData()){
				if($this->Mroom_type->Save()){
					$this->AddInfo("Successfully added.",true);
					redirect("admin/room_types");
				}
			}
		}
		if($isEdit == 'Y' && !empty($rtype_id)){
			$this->Mroom_type->rtype_id($rtype_id);
			if($this->Mroom_type->Select()){
				if($this->Mroom_type->GetFromPostData()){
					$this->Mroom_type->rtype_id($rtype_id);
					if($this->Mroom_type->Update()){
						$this->AddInfo("Successfully updated.",true);
						redirect("admin/room_types");
					}
				}
	
			}
		}
		redirect("admin/room_types");
	}
	
	public function add_edit_booking(){
		$this->CheckSession(true);
		$this->load->model("database/Mbooking");
		$isEdit = $this->input->post("isEdit", true);
		$booking_id = $this->input->post("hidden_booking_id", true);
	
		//echo 'is edit: '. $isEdit. ' ID: '. $booking_id ;
		
		if($isEdit == 'N' && $booking_id == 'N'){
			if($this->Mbooking->GetFromPostData()){
				if($this->Mbooking->Save()){
					$this->AddInfo("Successfully added.",true);
					redirect("admin/bookings");
				}
			}
		}
		
		if($isEdit == 'Y' && !empty($booking_id)){
			$this->Mbooking->booking_id($booking_id);
			if($this->Mbooking->Select()){
				if($this->Mbooking->GetFromPostData()){
					$this->Mbooking->booking_id($booking_id);
					if($this->Mbooking->Update()){
						$this->AddInfo("Successfully updated.",true);
						redirect("admin/bookings");
					}
				}
	
			}
		}
		redirect("admin/bookings");
	}
	
	public function getRoomType(){
		$rtype_id = $_REQUEST["rtype_id"];
		$records = array();
		$this->load->model("database/Mroom_type");
		$this->Mroom_type->rtype_id($rtype_id);
		if($this->Mroom_type->Select()){
			$records = $this->Mroom_type;
		}
		echo json_encode($records);
	}
	
	
	public function getBooking(){
		$booking_id = $_REQUEST["booking_id"];
		$records = array();
		$this->load->model("database/Mbooking");
		$this->Mbooking->booking_id($booking_id);
		if($this->Mbooking->Select()){
			$records = $this->Mbooking;
		}
		echo json_encode($records);
	}
	
	
	public function bookings_per_day(){
		$begin = new DateTime(date("Y-m-d"));
		$end = new DateTime( date("Y-m-d"). '- 30 day' );
		
		$interval = DateInterval::createFromDateString('1 day');
		$period = new DatePeriod($end, $interval, $begin);
		
		$num_per_day_booking = '';
		
		foreach ( $period as $dt ){
			$date = $dt->format( "Y-m-d" );
			$date1 = $date . ' 00:00:00';
			$date2 = $date . ' 23:59:59';
			$sql_num_per_day = "SELECT count(booking_id) as num_bookings_per_day FROM booking WHERE creation_date BETWEEN '$date1' AND '$date2';";
			$records_num_per_day = $this->db->query($sql_num_per_day);
			$num_per_day = $records_num_per_day->result()[0]->num_bookings_per_day;
			//GPrint($num_per_day);
			$date_format = date('M d', strtotime($date));
				
			$num_per_day_booking .= "{y: '$date_format', a: $num_per_day},";
		}
		
		$num_per_day_booking = rtrim($num_per_day_booking, ',');
		$pdata['num_per_day_booking'] = $num_per_day_booking;
		
		$pdata['title'] = "Bookings/Day";
		$pdata['sub_title'] = "Bookings/Day";
		$pdata['LoadViews'] = "bookings_per_day";
		$this->LoadView($pdata);
	}
	
	
	
	
	

	
	public function logout() {
		$utype = $this->session->GetCurrentUserType();
		$this->session->UnsetAllUserData();
		if($utype == 'AD'){
			redirect("");
		}
		if($utype == 'VT'){
			redirect("");
		}
	
	}
	
	

	
	
	
	function __construct() {
		parent::__construct ();
		//$this->CheckSession(true);
	}
	
	

	
	public function CheckSession($autoRedirect=false){
		$utype = $this->session->GetCurrentUserType();
		if($utype=="AD"){
			return true;
		} elseif($utype=="VT") {
			return true;
		}
		else {
			if($autoRedirect) {
					redirect("task/admin");
				}
		}
	}
	
	public function LoginPanel($rData) {
		$this->load->view("login",$rData);
	}
	
	private function LoadView($rData) {
		$this->load->view("common_view",$rData);
	}
	
	private  function LoadPanel($rData){
		$this->load->view("userBody",$rData);
	}
	

	


	


}
?>