<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Main extends GSController {
	
	public function index() {
		redirect("main/view_batch");
	}
	function __construct() {
		parent::__construct ();
		//$this->CheckSession(true);
	}
	
	public function logout() {
		$utype = $this->session->GetCurrentUserType();
		if($utype=="AD"){
			$this->session->UnsetAllUserData();
			redirect("main/admin");
		}
		if($utype=="IN"){
			$this->session->UnsetAllUserData();
			redirect("main/instructor");
		}
	}
	
	public function cup(){
		GPrint("Hello corporate cup");
	}
	
	public function lock_screen() {
		$this->CheckSession(true);
		$this->session->UnsetAllUserData();
		if(!$_SESSION['lock_userid']) {
			redirect("main/admin");
		}
		$rData=array();
		$rData['lock_username'] = $_SESSION['lock_username'];
		$rData['lock_userid'] = $_SESSION['lock_userid'];
		//$this->GetDefaultConfiguration($rData);
		$this->lock_screen_panel($rData);
	}
	

	
	public function instructor() {
		
		$utype = $this->session->GetCurrentUserType();
		if($utype=="AD") {
			redirect("main/view_batch");
			die;
		}
		
		$message="";
		$this->load->model("database/Minstructor");
		if($this->CheckSession()) {
			redirect("main/view_inst_profile");
		}
		if(IsPostBack){
			$this->load->helper("functions");
			$email = trim($_POST['userid']);//for instructor, it is email address not User ID. userID used for admin
			$password = trim($_POST['password']);
			$instructor_id = $this->Minstructor->authenticate($email, $password);
			if (!empty($instructor_id)) {
				log_action('Login', "{$this->session->GetInstructorData()->instructor_name} logged in.");
				//$_SESSION['lock_userid'] = $this->session->GetInstructorData()->instructor_id;
				//$_SESSION['lock_username'] = $this->session->GetInstructorData()->instructor_name;
				//$utype = $this->session->GetCurrentUserType();
				//echo $utype; die;
				//GPrint($_SESSION);die;
				
				redirect("main/view_inst_profile");
			} else {
				$message = "E-mail/password combination incorrect.";
			}
		}
		$rData=array();
		$rData['msg'] = $message;
		$rData['title'] = "Instructor Login";
		$rData['field'] = "Email";
		$this->GetDefaultConfiguration($rData);
		$this->LoginPanel($rData);
	}
	
	public function view_inst_profile() {
		$this->CheckSession(true);
		$this->load->model("database/Minstructor");
		$instructor_id = $this->session->GetInstructorData()->instructor_id;
		$pdata = array();
		$pdata['sub_title'] = "";
		if(!empty($instructor_id)){
			$this->Minstructor->instructor_id($instructor_id); //id is the pk coloumn name  trainee_name
			$this->Minstructor->Select();
			$pdata['title'] = $this->Minstructor->instructor_name;
			$pdata['instructorObj'] = $this->Minstructor;
			$this->GetDefaultConfiguration($pdata);
			$pdata['LoadViews']="instructor_profile_view";
			$this->LoadPanel($pdata);
		} else {
			redirect("main/instructor");
		}
	}
	
	public function admin() {		
		//$this->load->library("session2");
		$this->load->model("database/Madmin");
		
		if($this->CheckSession()) {
			redirect("main/view_batch");
			die;
		}
		
		$message="";
		
		if(IsPostBack){			
			$this->load->helper("functions");
			$username = trim($_POST['userid']);
			$password = trim($_POST['password']);
			if ($this->Madmin->authenticate($username, $password)) {
				//$this->session->GetAdminData ()->fullname;				
				log_action('Login', "{$this->session->GetAdminData ()->fullname} logged in.");
				$_SESSION['lock_userid'] = $this->session->GetAdminData()->userid; //stored only for locked screen page 
				$_SESSION['lock_username'] = $this->session->GetAdminData()->fullname;//stored only for locked screen page
				redirect("main/view_batch");
			} else {
				$message = "User ID/password combination incorrect.";
			}
		}
		
		$this->load->model("database/Madmin");
		$rData=array();
		$rData['loginObj']=$this->Madmin;
		$rData['title'] = "Admin Login";
		$rData['field'] = "User ID";
		$rData['msg'] = $message;
		$this->GetDefaultConfiguration($rData);
		$this->LoginPanel($rData);		
	}
	
	public function register() {
		$this->load->view('register');
	}
	
	/*
	 * GetAdminData() returns the Admin session data.
	 * GetCurrentUserType() returns "AD" for admin
	 * AdminSession Object
		(
		    [userid] => 111
		    [fullname] => walid
		    [role] => A
		    [email] => walid_tee@yahoo.com
		    [LoggedIn] => 1
		)
	*
	*GetInstructorData() returns Instructor session data
	*GetCurrentUserType() returns "IN" for admin
	*InstructorSession Object
		(
		    [instructor_id] => 33
		    [instructor_name] => Musfiq rahim
		    [email] => safikul@gmail.com
		    [LoggedIn] => 1
		)

	 */
	public function CheckSession($autoRedirect=false){
		$utype = $this->session->GetCurrentUserType();
		//GPrint($this->session->GetAdminData());die;
			if($utype=="AD"){
				return true;
			} else if($utype=="IN") {
				return true;
			}
			else {
				if($autoRedirect) {
					redirect("main/admin");
				}
			}
	}
	
	
	public function view_batch() {
		$this->CheckSession(true);		
		$pdata = array();
		$pdata['title'] = "Batch List";
		$pdata['sub_title'] = "";
		$this->load->model("database/Mbatch");
		
		if($this->session->GetCurrentUserType()=="IN") {
			$instructor_id = $this->session->GetInstructorData()->instructor_id;
			$this->Mbatch->instructor_id($instructor_id);//WHERE instructor_id=33
		}
		
		$batch_data = $this->Mbatch->SelectJoin();
		$pdata['delete_url'] = site_url("main/delete_batch");
		$pdata['batch_list'] = $batch_data;
		$pdata['LoadViews'] = "batch_list";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadPanel($pdata);
	}
	
	public function add_topics() {
		
		$this->CheckSession(true);
		$uriData = $this->GetUriArray();
		
		$this->load->model("database/Mtopics");
		
		if(IsPostBack){
			$searchByCourse = trim($_POST['course_id']);
			if($this->Mtopics->GetFromPostData()){
				if($this->Mtopics->Save()){
					$this->AddInfo("Successfully Added",true);
					redirect("main/view_topics/id/".$searchByCourse );
				}
			}
		}
		
		$rData=array();
		$rData['title'] = "Add Topics";
		$rData['sub_title'] = "";
		if(!empty($uriData['id'])){
			
			$rData['current_course_id'] = $uriData['id'];
			
			if($this->session->GetCurrentUserType()=="IN") {
				
				$instructor_id = $this->session->GetInstructorData()->instructor_id;
				$this->load->model("database/Mbatch");
				$this->Mbatch->instructor_id($instructor_id);
				$course_id = $this->Mbatch->SelectAll('course_id');
				$isFound = false;
				foreach ($course_id as $id){
					if($id->course_id == $uriData['id']) {
						$isFound = true;
						break;
					}
				}
				if($isFound) {
					$rData['topicObj']=$this->Mtopics;
					$this->GetDefaultConfiguration($rData);
					$rData['LoadViews']="topic_form";
					$rData['AutoMsgShow']=false;
					$this->LoadPanel($rData);
				} else {
					redirect("main/view_topics");
				}
			} else {
				$rData['topicObj']=$this->Mtopics;
				$this->GetDefaultConfiguration($rData);
				$rData['LoadViews']="topic_form";
				$rData['AutoMsgShow']=false;
				$this->LoadPanel($rData);
			}
		} else {
			$rData['current_course_id'] = "";
			$rData['topicObj']=$this->Mtopics;
			$this->GetDefaultConfiguration($rData);
			$rData['LoadViews']="topic_form";
			$rData['AutoMsgShow']=false;
			$this->LoadPanel($rData);
		}
		
	}
	
	
	
	public function edit_topic() {
		$this->CheckSession(true);
		$this->load->model("database/Mtopics");
		$pdata = array();
		$pdata['title'] = "Topic Edit";
		$pdata['sub_title'] = "";
		$pdata['isEdit']=false;
		$uriData = $this->GetUriArray(); // Like $uriData = $this->uri->uri_to_assoc();
		if(IsPostBack){
			$this->Mtopics=new Mtopics(); //topic_id, topic_name, course_id
			if($this->Mtopics->GetFromPostData()){
				$this->Mtopics->topic_id($uriData['id']);
				$this->Mtopics->topic_name($this->Mtopics->topic_name);
				$this->Mtopics->course_id($this->Mtopics->course_id);
				if($this->Mtopics->Update()){
					$this->AddInfo("Successfully Updated",true);
					redirect("main/view_topics/id/". $this->Mtopics->course_id);
				}
			}
		}
		if(!empty($uriData['id'])){
			$pdata['isEdit']=true;
			$pdata['current_course_id'] = $uriData['id'];
			$this->Mtopics=new Mtopics();
			$this->Mtopics->topic_id($uriData['id']);
	
			if($this->Mtopics->Select()){
				$pdata['topicObj'] = $this->Mtopics;
			}else{
				$pdata['isEdit']=false;
			}
		}
		$this->GetDefaultConfiguration($pdata);
		$pdata['LoadViews']="topic_form";
		$pdata['AutoMsgShow']=false;
		$this->LoadPanel($pdata);
	}
	
	public function view_schedule() {
		$this->CheckSession(true);
		$uriData = $this->GetUriArray();
		$pdata = array();
		$pdata['title'] = "Batchwise Schedule";
		$pdata['sub_title'] = "";
		$pdata['property'] = "";
		$this->load->model("database/Mtopics");
		$pdata['topic_type'] = $this->Mtopics->topic_type;
		
		if($this->session->GetCurrentUserType()=="AD") {
			$this->load->model("database/Mcourse");//for dropdown menu
			$course_data = $this->Mcourse->SelectAll('course_id,course_name');
			$pdata['course_data'] = $course_data;
			$this->load->model("database/Mbatch");//for dropdown menu
			$batch_data = $this->Mbatch->SelectAll('id,batch_id');
			$pdata['batch_data'] = $batch_data;
		}
		
		if($this->session->GetCurrentUserType()=="IN") {
			$instructor_id = $this->session->GetInstructorData()->instructor_id;
			$this->load->model("database/Mbatch");
			$this->Mbatch->instructor_id($instructor_id);
			$batch_data = $this->Mbatch->SelectJoin();
			$pdata['course_data'] = $batch_data;//for dropdown menu
			$pdata['batch_data'] = $batch_data;//for dropdown menu
		}
		
		//GPrint($batch_data[0]->id);die;
		
		if(!IsPostBack && empty($uriData['id'])) {
			$query = "SELECT  schedule.*, top.topic_name, bat.batch_id AS batch_name
					FROM schedule, topics top, batch bat, course crs
					WHERE
					schedule.topic_id=top.topic_id AND schedule.batch_id=bat.id
					AND schedule.batch_id={$batch_data[0]->id} AND bat.course_id=crs.course_id ";
			
			$records = $this->db->query($query);
			$schedule_data = $records->result();
			
		}
		
		if(IsPostBack){
			$searchByBatch = trim($_POST['sortByBatch']);
			$query = "SELECT s.*,t.topic_id,t.topic_name,b.batch_id, b.id as batch_id, b.batch_id as batch_name 
						FROM batch b, topics t 
						LEFT JOIN schedule s ON t.topic_id=s.topic_id 
							WHERE t.course_id=b.course_id AND b.id=".$searchByBatch;
			
			$records = $this->db->query($query);
			$schedule_data = $records->result();
			$pdata['search_value'] = $searchByBatch;
			
		}
		
		$pdata['schedule_list'] = $schedule_data;
		$pdata['LoadViews'] = "schedule_list";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);
	}
	
	public function view_class_schedule() {
		$this->CheckSession(true);
		$uriData = $this->GetUriArray();
		$pdata = array();
		$pdata['title'] = "Class Schedule";
		$pdata['sub_title'] = "";
		$pdata['property'] = "";
		$this->load->model("database/Mclass_schedule");
		
		if($this->session->GetCurrentUserType()=="AD") {
			//$this->load->model("database/Mcourse");//for dropdown menu
			//$course_data = $this->Mcourse->SelectAll('course_id,course_name');
			//$pdata['course_data'] = $course_data;
			$this->load->model("database/Mbatch");//for dropdown menu
			$batch_data = $this->Mbatch->SelectAll('id,batch_id');
			$pdata['batch_data'] = $batch_data;
		}
		
		if($this->session->GetCurrentUserType()=="IN") {
			$instructor_id = $this->session->GetInstructorData()->instructor_id;
			$this->load->model("database/Mbatch");
			$this->Mbatch->instructor_id($instructor_id);
			$batch_data = $this->Mbatch->SelectJoin();
			//$pdata['course_data'] = $batch_data;//for dropdown menu
			$pdata['batch_data'] = $batch_data;//for dropdown menu
		}
		
		if(!IsPostBack && empty($uriData['id'])) {
			$this->Mclass_schedule->batch_id($batch_data[0]->id);
			$class_schedule_data = $this->Mclass_schedule->SelectJoin();
		}
		
		if(!IsPostBack && !empty($uriData['id'])) {
			$pdata['search_value'] = $uriData['id'];
			$this->Mclass_schedule->batch_id($uriData['id']);
			$class_schedule_data = $this->Mclass_schedule->SelectJoin();
		}
		
		if(IsPostBack){
			$searchByBatch = $this->input->post("sortByBatch", true);
			$pdata['search_value'] = $searchByBatch;
			$this->Mclass_schedule->batch_id($searchByBatch);
			$class_schedule_data = $this->Mclass_schedule->SelectJoin();
		}
		
		$pdata['class_schedule_data'] = $class_schedule_data;
		$pdata['action_url'] = site_url("main/requestForApproval");
		$pdata['delete_url'] = site_url("main/delete_class_schedule");
		$pdata['LoadViews'] = "class_schedule_list";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);
	}
	
	public function view_pending_request() {
		$this->CheckSession(true);
		$pdata = array();
		$pdata['title'] = "Pending Requests";
		$pdata['sub_title'] = "";
		$pdata['property'] = "";
		$this->load->model("database/Mclass_schedule");
		$this->Mclass_schedule->status('R');
		$pending_request_data = $this->Mclass_schedule->SelectJoin();
		$pdata['pending_request_data'] = $pending_request_data;
		$pdata['action_url'] = site_url("main/approveByAdmin");
		$pdata['cancel_url'] = site_url("main/cancelByAdmin");
		$pdata['LoadViews'] = "pending_request_list";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);
	}
	
	public function approveByAdmin() {
		$this->CheckSession(true);
		$pdata = array();
		$pdata['errType'] = "";
		$pdata['errMsg'] = "";
		$pdata['title'] = "Pending Requests";
		$pdata['sub_title'] = "";
		$uriData = $this->GetUriArray();
	
		if (isset($uriData['table_pk']) && !empty($uriData['table_pk'])) {
			$class_schedule_pid = $uriData['table_pk'];
	
				
			$this->load->model("database/Mclass_schedule");
			$this->Mclass_schedule->pk_id($class_schedule_pid);
	
			$this->Mclass_schedule = new Mclass_schedule();
			$this->Mclass_schedule->status('A');
			$this->Mclass_schedule->SetWhereUpdate("pk_id", $class_schedule_pid);
	
			if($this->Mclass_schedule->Update()){
				$pdata['errType'] = "success";
				$pdata['errMsg'] = "Request has been approved";
			} else {
				$pdata['errType'] = "error";
				$pdata['errMsg'] = "Approval Failed";
			}
	
	
		} else {
			$pdata['errType'] = "error";
			$pdata['errMsg'] = "Invalid  Id!";
		}
	
		$pdata['redirectUrl'] = site_url("main/view_pending_request");
		$pdata['LoadViews'] = "only_message";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadPanel($pdata);
	}
	
	public function cancelByAdmin() {
		$this->CheckSession(true);
		$pdata = array();
		$pdata['errType'] = "";
		$pdata['errMsg'] = "";
		$pdata['title'] = "Pending Requests";
		$pdata['sub_title'] = "";
		$uriData = $this->GetUriArray();
	
		if (isset($uriData['table_pk']) && !empty($uriData['table_pk'])) {
			$class_schedule_pid = $uriData['table_pk'];
	
			$this->load->model("database/Mclass_schedule");
			$this->Mclass_schedule->pk_id($class_schedule_pid);
	
			$this->Mclass_schedule = new Mclass_schedule();
			$this->Mclass_schedule->status('P');
			$this->Mclass_schedule->SetWhereUpdate("pk_id", $class_schedule_pid);
	
			if($this->Mclass_schedule->Update()){
				$pdata['errType'] = "success";
				$pdata['errMsg'] = "Request has been approved";
			} else {
				$pdata['errType'] = "error";
				$pdata['errMsg'] = "Approval Failed";
			}
	
		} else {
			$pdata['errType'] = "error";
			$pdata['errMsg'] = "Invalid  Id!";
		}
	
		$pdata['redirectUrl'] = site_url("main/view_pending_request");
		$pdata['LoadViews'] = "only_message";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadPanel($pdata);
	}
	
	public function requestForApproval() {
		$this->CheckSession(true);
		$pdata = array();
		$pdata['errType'] = "";
		$pdata['errMsg'] = "";
		$pdata['title'] = "Class Schedule";
		$pdata['sub_title'] = "";
		$uriData = $this->GetUriArray();
	
		if (isset($uriData['table_pk']) && !empty($uriData['table_pk'])) {
			$class_schedule_pid = $uriData['table_pk'];
		
			
				$this->load->model("database/Mclass_schedule");
				$this->Mclass_schedule->pk_id($class_schedule_pid);
				
				if($this->Mclass_schedule->Select()){
					$batch_id = $this->Mclass_schedule->batch_id;
				}
				
				$this->Mclass_schedule = new Mclass_schedule();
				$this->Mclass_schedule->status('R');
				$this->Mclass_schedule->SetWhereUpdate("pk_id", $class_schedule_pid);
				
				if($this->Mclass_schedule->Update()){
					$pdata['errType'] = "success";
					$pdata['errMsg'] = "Request has been sent";
				} else {
					$pdata['errType'] = "error";
					$pdata['errMsg'] = "Request Failed";
				}
				
		
			} else {
			$pdata['errType'] = "error";
			$pdata['errMsg'] = "Invalid  Id!";
		}
		
		$pdata['redirectUrl'] = site_url("main/view_class_schedule/id/" . $batch_id);
		$pdata['LoadViews'] = "only_message";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadPanel($pdata);
	}
	
	public function delete_class_schedule() {
		echo "It Works";
	}
	
	public function add_class_schedule() {
		$this->CheckSession(true);
		$uriData = $this->GetUriArray();
		$rData=array();
		
		if(!empty($uriData['id'])){
			$rData['current_batch_id'] = $uriData['id'];
		}
		
		$this->load->model("database/Mclass_schedule");
		if(IsPostBack){
			if($this->Mclass_schedule->GetFromPostData()){
				if($this->Mclass_schedule->Save()){
					$this->AddInfo("Successfully Added",true);
					redirect("main/view_class_schedule/id/".$uriData['id']);
					//redirect("main/view_trainee_details/id/".$uriData['id'] );
				}
			}
		}

		$rData['title'] = "Add Class Schedule";
		$rData['sub_title'] = "";
		$rData['classSeheduleObj']=$this->Mclass_schedule;
		$this->GetDefaultConfiguration($rData);
		$rData['multipath']=false; //This field is needed for photo upload and it sets enctype="multipart/form-data" on form action
		$rData['LoadViews']="class_schedule_form";
		$rData['AutoMsgShow']=false;
		$this->LoadPanel($rData);
	}
	
	public function edit_class_schedule() {
		echo "It works";
	}
	
	
	
	public function edit_schedule() {
		$this->CheckSession(true);
		$topic_id = $_REQUEST["topic_id"];
		$batch_id = $_REQUEST["batch_id"];
		
		$query = "SELECT s.*,t.topic_id,t.topic_name,b.batch_id,b.batch_id as batch_name, c.course_name, c.course_id 
						FROM batch b, course c, topics t
						LEFT JOIN schedule s ON t.topic_id=s.topic_id
							WHERE t.course_id=b.course_id AND b.course_id=c.course_id AND b.id=".$batch_id." AND t.topic_id=".$topic_id;
			
		$records = $this->db->query($query);
		echo json_encode($records->result());
		if(IsPostBack){
			
		}
	}
	
	public function delate_schedule() {
		$this->CheckSession(true);
		$table_pk = $_REQUEST["table_pk"];
		$result = "F";
		if (!empty($table_pk)) {
			$this->load->model("database/Mschedule");
			$this->Mschedule = new Mschedule();
			$this->Mschedule->id($table_pk);
			if ($this->Mschedule->Delete()) {
				$result = "S";
			}
		}
		echo json_encode($result);
		return;
	}
	
	public function update_schedule() {
		//This method works both for INSERT and UPDATE
		$this->CheckSession(true);
		$topic_id = $_REQUEST["topic_id"];
		$course_id = $_REQUEST["course_id"];
		$pk_id = $_REQUEST["pk_id"];
		$batch_id = $_REQUEST["batch_id"];
		$schedule_date = $_REQUEST["schedule_date"];
		$session_type = $_REQUEST["session_type"];
		$duration = $_REQUEST["duration"];
		$chkDuration = is_numeric ($duration);
		
		if(!is_numeric ($duration)) {
			echo "F"; return;
		}
		
		if(empty($pk_id)) {
			$query = "INSERT INTO schedule (course_id, topic_id, batch_id, schedule_date, session_type, duration) 
				VALUES ($course_id, $topic_id, $batch_id, '{$schedule_date}', '{$session_type}', $duration )";
			if($this->db->query($query)) {
				echo  "S";
			} else {
				echo "F";
			}
		} else {
			$query = "UPDATE schedule SET course_id = $course_id, topic_id = $topic_id, batch_id = $batch_id, 
			schedule_date = '{$schedule_date}', session_type = '{$session_type}', duration =  $duration 
					WHERE id = $pk_id LIMIT 1";
			if($this->db->query($query)) {
				echo  "S";
			} else {
				echo "F";
			}
		}
	}
	
	public function view_topics() {
		$this->CheckSession(true);
		$uriData = $this->GetUriArray();
		$pdata = array();
		$pdata['title'] = "Topic List";
		$pdata['sub_title'] = "";
		$pdata['property'] = "";
		$this->load->model("database/Mtopics");
	

		if($this->session->GetCurrentUserType()=="AD") {
			$this->load->model("database/Mcourse");//for dropdown menu
			$course_data = $this->Mcourse->SelectAll('course_id,course_name');
			$pdata['course_data'] = $course_data;
		}
		
		if($this->session->GetCurrentUserType()=="IN") {
			$instructor_id = $this->session->GetInstructorData()->instructor_id;
			$this->load->model("database/Mbatch");
			$this->Mbatch->instructor_id($instructor_id);//WHERE instructor_id=33
			$batch_data = $this->Mbatch->SelectJoin();//for dropdown menu
			$pdata['course_data'] = $batch_data;
		}
		
		if(!empty($uriData['id']) ){
			$pdata['search_value'] = $uriData['id'];
			$this->Mtopics->course_id($uriData['id']);
		}
		
		if(IsPostBack){
			$searchByCourse = trim($_POST['course_id']);
			$pdata['search_value'] = $searchByCourse;
			$this->Mtopics->course_id($searchByCourse);
		}
		
		if(!IsPostBack && empty($uriData['id'])) {
			foreach ($pdata['course_data'] as $course){
				$pdata['search_value'] = "";
				$this->Mtopics->course_id($course->course_id);break;//$this->Mtopics->course_id("7");
			}
		}

		$topic_data = $this->Mtopics->SelectJoin();
		$pdata['delete_url'] = site_url("main/delete_topic");
		$pdata['topic_list'] = $topic_data;
		$pdata['LoadViews'] = "topic_list";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadPanel($pdata);
	}
	
	

	
	public function view_course() {
		$this->CheckSession(true);
		$pdata = array();
		$pdata['title'] = "Course List";
		$pdata['sub_title'] = "";
		
		if($this->session->GetCurrentUserType()=="IN") {
			$instructor_id = $this->session->GetInstructorData()->instructor_id;
			$this->load->model("database/Mbatch");
			$this->Mbatch->instructor_id($instructor_id);//WHERE instructor_id=33
			$batch_data = $this->Mbatch->SelectAll('course_id');
			$batch_data = $this->Mbatch->SelectJoin();
			$pdata['course_list'] = $batch_data;
			}
		
		if($this->session->GetCurrentUserType()=="AD") {
			$this->load->model("database/Mcourse");
			$course_data = $this->Mcourse->SelectAll();
			$pdata['course_list'] = $course_data;
		}
		
		$pdata['delete_url'] = site_url("main/delete_course");
		$pdata['LoadViews'] = "course_list";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadPanel($pdata);
		
		//Old Style
/* 		$this->AddError("Test error");
		$this->AddInfo("Test info");
		$this->AddHiddenField("test", "hiddentest");
		$this->load->view('course_list', array('course_list' => $course_data)); */
	}
	
	public function delete_course() {
		$this->CheckSession(true);
		//--For course delete--http://localhost/genuity_training/index.php/main/delete_course/table_pk/1
		$pdata = array();
		$pdata['errType'] = "";
		$pdata['errMsg'] = "";
		$pdata['title'] = "Course List";
		$pdata['sub_title'] = "";
		$uriData = $this->uri->uri_to_assoc();

		if (isset($uriData['table_pk']) && !empty($uriData['table_pk'])) {
			$course_pid = $uriData['table_pk'];
			if(!empty($course_pid)){
				$this->load->model("database/Mcourse");
				$this->Mcourse = new Mcourse();
				$this->Mcourse->course_id($course_pid);//course_id is the primary key's coloumn name
				if ($this->Mcourse->Delete()) {
					$pdata['errType'] = "success";
					$pdata['errMsg'] = "Successfully Deleted";
				}else {
					$pdata['errType'] = "error";
					$pdata['errMsg'] = "Delete Failed";
				}
			} 
		}else {
			$pdata['errType'] = "error";
			$pdata['errMsg'] = "Invalid Batch Id!";
		}
		
		$pdata['redirectUrl'] = site_url("main/view_course");
		$pdata['LoadViews'] = "only_message";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadPanel($pdata);
	}

	public function delete_topic() {
		$this->CheckSession(true);
		$course_id = "";
		$pdata = array();
		$pdata['errType'] = "";
		$pdata['errMsg'] = "";
		$pdata['title'] = "Topic List";
		$pdata['sub_title'] = "";
		$uriData = $this->GetUriArray();
	
		if (isset($uriData['table_pk']) && !empty($uriData['table_pk'])) {
			$topic_pid = $uriData['table_pk'];
			if(!empty($topic_pid)){
				$this->load->model("database/Mtopics");
				$this->Mtopics->topic_id($uriData['table_pk']);
				if($this->Mtopics->Select()){
					$course_id = $this->Mtopics->course_id;
				}
				$this->Mtopics = new Mtopics();
				$this->Mtopics->topic_id($topic_pid);//topic_id is the primary key's coloumn name
				if ($this->Mtopics->Delete()) {
					$pdata['errType'] = "success";
					$pdata['errMsg'] = "Successfully Deleted";
				}else {
					$pdata['errType'] = "error";
					$pdata['errMsg'] = "Delete Failed";
				}
			}
		}else {
			$pdata['errType'] = "error";
			$pdata['errMsg'] = "Invalid Topic Id!";
		}
	//redirect("main/view_topics/id/". $this->Mtopics->course_id);
		$pdata['redirectUrl'] = site_url("main/view_topics/id/" . $course_id);
		$pdata['LoadViews'] = "only_message";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadPanel($pdata);
	}
	
	public function add_batch() {
		
		if($this->session->GetCurrentUserType()!="AD") {
			redirect("main/view_batch");
			die;
		}
		
		$this->CheckSession(true);
		$this->load->model("database/Mbatch");
		if(IsPostBack){
			if($this->Mbatch->GetFromPostData()){
				if($this->Mbatch->Save()){
					//$this->AddInfo("Successfully Added");
					//$this->Mbatch=new Mbatch();
					$this->AddInfo("Successfully Added",true);
					//$_POST[]
					redirect("main/add_batch");		
				}
			}
		}
		$rData=array();
		$rData['title'] = "Add batch";
		$rData['sub_title'] = "";
		$rData['batchObj']=$this->Mbatch;
		$this->GetDefaultConfiguration($rData);
		//$rData['ButtonValue']="Sumbitdd";
		$rData['LoadViews']="batch_form";
		$rData['AutoMsgShow']=false;
		$this->LoadPanel($rData);
	}
	
	public function add_course() {
		$this->CheckSession(true);
		$this->load->model("database/Mcourse");
	
		if(IsPostBack){
			if($this->Mcourse->GetFromPostData()){
				if($this->Mcourse->Save()){
					$this->AddInfo("Successfully Added",true);
					redirect("main/add_course");
				}
			}
		}
		$rData=array();
		$rData['title'] = "Add Course";
		$rData['sub_title'] = "";
		$rData['courseObj']=$this->Mcourse;
		$this->GetDefaultConfiguration($rData);
		$rData['LoadViews']="course_form";
		$rData['AutoMsgShow']=false;
		$this->LoadPanel($rData);
	}
	

	
	public function view_inst() {
		$this->CheckSession(true);
		$pdata = array();
		$pdata['title'] = "Instructor List";
		$pdata['sub_title'] = "";
		$this->load->model("database/Minstructor");
		$inst_data = $this->Minstructor->SelectAll('','instructor_id','DESC');
	
		//$pdata['delete_url'] = site_url("main/delete_course");
		$pdata['instructor_list'] = $inst_data;
		$pdata['LoadViews'] = "inst_list2";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadPanel($pdata);
	
	
		// 		$this->load->model("database/Minstructor");
		// 		$inst_data = $this->Minstructor->SelectAll();
		// 		$this->load->view('inst_list', array('inst_list' => $inst_data));
	}
	
	public function add_trainee() {
		$this->CheckSession(true);
		$this->load->model("database/Mtrainee");
	
		if(IsPostBack){
			if($this->Mtrainee->GetFromPostData()){
				 if($this->Mtrainee->Save()){
					$this->AddInfo("Successfully Added",true);
					 if($_FILES['file_upload']['error']==0){
						$id=$this->Mtrainee->GetUpdateDB()->insert_id();
						$dpath=BASEPATH."../img/trainee/".$id.'.jpg';
						if(file_exists($dpath)){
							unlink($dpath);
						}
						if(copy($_FILES['file_upload']['tmp_name'], $dpath)){
							$this->AddInfo("Image Successfully Uploaded",true);
							//redirect("main/add_instructor");
						}
					}	
				} 
			}
		}
	
		$rData=array();
		$rData['title'] = "Add Trainee";
		$rData['sub_title'] = "";
		$rData['traineeObj']=$this->Mtrainee;
		$this->GetDefaultConfiguration($rData);
		$rData['multipath']=true; //This field is needed for photo upload and it sets enctype="multipart/form-data" on form action
		$rData['LoadViews']="trainee_form";
		$rData['AutoMsgShow']=false;
		$this->LoadPanel($rData);
	}
	
	public function view_trainee2() { 
		$this->CheckSession(true);
		$pdata = array();
		$pdata['title'] = "Trainee List";
		$pdata['sub_title'] = "";
		$pdata['property'] = "";
		$pdata['search_value'] = "";
		$this->load->model("database/Mtrainee");
		
		if($this->session->GetCurrentUserType()=="IN") {
			$instructor_id = $this->session->GetInstructorData()->instructor_id;
			$this->load->model("database/Mbatch");
			$this->Mbatch->instructor_id($instructor_id);
			$batch_data = $this->Mbatch->SelectJoin();
			//GPrint($batch_data);die;
			$this->Mtrainee->batch_id($batch_data[0]->id);
			$trainee_data = $this->Mtrainee->SelectJoinAll();
			$pdata['course_data'] = $batch_data;//for dropdown menu
			$pdata['batch_data'] = $batch_data;//for dropdown menu
			$pdata['trainee_list'] = $trainee_data;
			$pdata['LoadViews'] = "trainee_view";
			$this->GetDefaultConfiguration($pdata);
			$this->LoadView($pdata);
		}
		
		if($this->session->GetCurrentUserType()=="AD") {
			$trainee_data = $this->Mtrainee->SelectJoinAll();
			$this->load->model("database/Mbatch");//for dropdown menu
			$batch_data = $this->Mbatch->SelectAll('id,batch_id');
			$this->load->model("database/Mcourse");//for dropdown menu
			$course_data = $this->Mcourse->SelectAll('course_id,course_name');
			$pdata['course_data'] = $course_data;
			$pdata['batch_data'] = $batch_data;
			$pdata['trainee_list'] = $trainee_data;
			$pdata['LoadViews'] = "trainee_view";
			$this->GetDefaultConfiguration($pdata);
			$this->LoadView($pdata);
		}

	}
	
	//id, trainee_id, trainee_name, institute, academic_bg, occupation, course_id, batch_id, mobile_number, email, course_fee, certificate_code, nid
	//SelectAllWithLike($QueryString = "", $orderBy = '', $order = 'asc', $limit = 0, $limitStart = 0)
	public function view_trainee() {
		$this->CheckSession(true);
		$this->load->model("database/Mtrainee");
		$pdata = array();
		$search_value = "";
		$property = "";
		$sub_query ="";
		if(IsPostBack){
			$property = trim($_POST['property']);
			$search_value = trim($_POST['search']);
			
			if($property=="batch_id")
				$sub_query .= "AND t.batch_id = '$search_value'";
			else if($property=="course_id")
				$sub_query .= "AND c.course_id = '$search_value'";
			else if($property=="trainee_name") 
				$sub_query .= "AND t.trainee_name LIKE  '%$search_value%'";
			else if($property=="trainee_id") 
				$sub_query .= "AND t.trainee_id LIKE  '%$search_value%'";
			else if($property=="mobile_number") 
				$sub_query .= "AND t.mobile_number LIKE  '%$search_value%'";			
		}
		
		$query = "SELECT t.*, c.course_name, b.batch_id AS batch_name
				FROM
					trainee t
				LEFT JOIN course c ON c.course_id=t.course_id
				LEFT JOIN batch b ON b.id=t.batch_id ";
		
		$pdata['search_value'] = $search_value;
		$pdata['property'] = $property;
		$this->load->model("database/Mbatch");
		
		if($this->session->GetCurrentUserType()=="IN") {
			$instructor_id = $this->session->GetInstructorData()->instructor_id;
			$this->Mbatch->instructor_id($instructor_id);
			$batch_data = $this->Mbatch->SelectJoin();
			//$this->Mtrainee->batch_id($batch_data[0]->id);
			$pdata['course_data'] = $batch_data;//for dropdown menu
			$pdata['batch_data'] = $batch_data;//for dropdown menu
		
			$query .= " LEFT JOIN instructor i ON i.instructor_id = b.instructor_id ";
			$sub_query .= " AND b.course_id=c.course_id AND i.instructor_id='$instructor_id' ";
		} else {
			$trainee_data = $this->Mtrainee->SelectJoinAll();
			$batch_data = $this->Mbatch->SelectAll('id,batch_id');
			$this->load->model("database/Mcourse");//for dropdown menu
			$course_data = $this->Mcourse->SelectAll('course_id,course_name');
			$pdata['course_data'] = $course_data;
			$pdata['batch_data'] = $batch_data;
		}
	
		$query .= " WHERE 1 ".$sub_query;
		
		$records = $this->db->query($query);
			
		$trainee_data = $records->result();

		if(!empty($trainee_data) && count($trainee_data) > 0){
			$pdata['title'] = "Trainee List";
			$pdata['sub_title'] = "";
			
			if($this->session->GetCurrentUserType()=="AD") {
				$this->load->model("database/Mbatch");//for dropdown menu
				$batch_data = $this->Mbatch->SelectAll('id,batch_id');
				$this->load->model("database/Mcourse");//for dropdown menu
				$course_data = $this->Mcourse->SelectAll('course_id,course_name');
				$pdata['course_data'] = $course_data;
				$pdata['batch_data'] = $batch_data;
			}
			
			if($this->session->GetCurrentUserType()=="IN") {
				$pdata['course_data'] = $batch_data;//for dropdown menu
				$pdata['batch_data'] = $batch_data;//for dropdown menu
			}
			
			$pdata['trainee_list'] = $trainee_data;
			$pdata['LoadViews'] = "trainee_view";
			$this->GetDefaultConfiguration($pdata);
			$this->LoadView($pdata);
		} else {
			$pdata = array();
			$pdata['errType'] = "error";
			$pdata['errMsg'] = "No Record Found!";
			$pdata['redirectUrl'] = site_url("main/view_trainee");
			$pdata['LoadViews'] = "only_message";
			$this->GetDefaultConfiguration($pdata);
			$this->LoadPanel($pdata);
		}
	}
	


/* 	public function trainee_sort() {
		if(IsPostBack){
			$this->load->model("database/Mtrainee");
			$property = trim($_POST['property']);
			$search_value = trim($_POST['search']);
			$this->Mtrainee->$property($search_value);  
			$trainee_data = $this->Mtrainee->SelectJoinAll();
			if(!empty($trainee_data) && count($trainee_data) > 0){
				$pdata = array();
				$pdata['title'] = "Trainee List";
				$pdata['sub_title'] = "";
				$pdata['property'] = $property;
				$pdata['search_value'] = $search_value;
				$this->load->model("database/Mbatch");//for dropdown menu
				$batch_data = $this->Mbatch->SelectAll('id,batch_id');
				$this->load->model("database/Mcourse");//for dropdown menu
				$course_data = $this->Mcourse->SelectAll('course_id,course_name');
				$pdata['course_data'] = $course_data;
				$pdata['batch_data'] = $batch_data;
				$pdata['trainee_list'] = $trainee_data;
				$pdata['LoadViews'] = "trainee_view";
				$this->GetDefaultConfiguration($pdata);
				$this->LoadView($pdata);		
			} else {
				$pdata = array();
				$pdata['errType'] = "error";
				$pdata['errMsg'] = "No Record Found!";
				$pdata['redirectUrl'] = site_url("main/view_trainee");
				$pdata['LoadViews'] = "only_message";
				$this->GetDefaultConfiguration($pdata);
				$this->LoadPanel($pdata);
			}
		}
	} */
	
	public function add_schedule() {
		$this->CheckSession(true);
		$this->load->model("database/Mschedule");
		if(IsPostBack){
			if($this->Mschedule->GetFromPostData()){
				if($this->Mschedule->Save()){
					$this->AddInfo("Successfully Added",true);
					redirect("main/add_schedule");
				}
			}
		}
		
		$rData=array();
		$rData['title'] = "Add Schedule";
		$rData['sub_title'] = "";
		$rData['seheduleObj']=$this->Mschedule;
		$this->GetDefaultConfiguration($rData);
		$rData['multipath']=false; //This field is needed for photo upload and it sets enctype="multipart/form-data" on form action
		$rData['LoadViews']="schedule_form";
		$rData['AutoMsgShow']=false;
		$this->LoadPanel($rData);
	}
	
	
	
	public function add_vendor() {
		$this->CheckSession(true);
		$this->load->model("database/Mvendor");
		if(IsPostBack){
			if($this->Mvendor->GetFromPostData()){
				if($this->Mvendor->Save()){
					$this->AddInfo("Successfully Added",true);
					redirect("main/add_vendor");
				}
			}
		}
		$rData=array();
		$rData['title'] = "Add Vendor";
		$rData['sub_title'] = "";
		$rData['vendorObj']=$this->Mvendor;
		$this->GetDefaultConfiguration($rData);
		$rData['multipath']=false; //This field is needed for photo upload and it sets enctype="multipart/form-data" on form action
		$rData['LoadViews']="vendor_form";
		$rData['AutoMsgShow']=false;
		$this->LoadPanel($rData);
	}
	
	public function add_invoice() {
		$this->CheckSession(true);
		$this->load->model("database/Minvoice");
		if(IsPostBack){
			if($this->Minvoice->GetFromPostData()){
				if($this->Minvoice->Save()){
					$this->AddInfo("Successfully Added",true);
					redirect("main/add_invoice");
				}
			}
		}
		$rData=array();
		$rData['title'] = "Add Invoice";
		$rData['sub_title'] = "";
		$rData['invoiceObj']=$this->Minvoice;
		$this->GetDefaultConfiguration($rData);
		$rData['multipath']=false; 
		$rData['LoadViews']="invoice_form";
		$rData['AutoMsgShow']=false;
		$this->LoadPanel($rData);
	}
	
	/* 
	[property] => vendor_id
	[dropdownValue] => 3
	
	[property] => batch_id
    [dropdownValue] => 19
    
    [property] => invoice_no
    [search] => dfgrg
    
    [property] => mr_no
    [search] => 2345
    
    [fromDate] => 2015-03-03
    [toDate] => 2015-03-10
	 */
	
	public function view_vendor_collection() {
		$this->CheckSession(true);
		$uriData = $this->GetUriArray();
		$pdata = array();
		$pdata['title'] = "Vendor Collection List";
		$pdata['sub_title'] = "";
		$this->load->model("database/Mentry_collection");
		$this->load->model("database/Mvendor");
		$vendor_data = $this->Mvendor->SelectAll();
		$this->load->model("database/Mbatch");
		$batch_data = $this->Mbatch->SelectAll('id,batch_id');
		$pdata['batch_data'] = $batch_data;//for dropdown menu
		
		
		
		if(IsPostBack){
			$property = $this->input->post("property", true);
			$dropdownValue = $this->input->post("dropdownValue", true);
			$searchValue = $this->input->post("search", true);
			$fromDate = $this->input->post("fromDate", true);
			$toDate = $this->input->post("toDate", true);
			
			/* echo "Property: " . $property . " Drop down value: " . $dropdownValue . " Input field: " . $searchValue .
			" From Date: " . $fromDate . " To Date: " . $toDate; */
			if(!empty($property) && ($property == "vendor_id" || $property == "batch_id") && !empty($dropdownValue)){
				$this->Mentry_collection->$property($dropdownValue);
				$pdata['search_value'] = $dropdownValue;
				$pdata['property'] = $property;
			}
			
			if(!empty($property) && ($property == "invoice_no" || $property == "mr_no") && !empty($searchValue)){
				$this->Mentry_collection->$property($searchValue);
				$pdata['search_value'] = $searchValue;
				$pdata['property'] = $property;
			}
			
			if(empty($property) && !empty($fromDate) && !empty($toDate)){
				$query = "SELECT `entry_collection`.*, `ven`.`vendor_name`, `bat`.`batch_id` AS batch_name 
						FROM (`entry_collection`) 
						LEFT JOIN `vendor` AS ven ON `ven`.`vendor_id`=`entry_collection`.`vendor_id` 
						LEFT JOIN `batch` AS bat ON `bat`.`id`=`entry_collection`.`batch_id` 
						WHERE `entry_collection`.`date` >= '$fromDate' AND  `entry_collection`.`date` <= '$toDate' ";
				
				$records = $this->db->query($query);
				$vendor_collection_data = $records->result();
				$pdata['delete_url'] = site_url("main/delete_vendor_collection");
				$pdata['search_value'] = "";
				$pdata['property'] = "";
				$pdata['fromDate'] = $fromDate;
				$pdata['toDate'] = $toDate;
				$pdata['vendor_collection_list'] = $vendor_collection_data;
				$pdata['vendor_data'] = $vendor_data;//for drop down menu
				$pdata['LoadViews'] = "vendor_collection_list";
				$this->GetDefaultConfiguration($pdata);
				$this->LoadView($pdata);return;
			}
			
		} else {
			$this->Mentry_collection->vendor_id($vendor_data[0]->vendor_id);
			$pdata['search_value'] = "";
			$pdata['property'] = "";
		}
		
		if($this->session->GetCurrentUserType()=="AD") {
			$vendor_collection_data = $this->Mentry_collection->SelectJoin();
			$pdata['delete_url'] = site_url("main/delete_vendor_collection");
			$pdata['vendor_collection_list'] = $vendor_collection_data;
			$pdata['vendor_data'] = $vendor_data;//for drop down menu
			$pdata['LoadViews'] = "vendor_collection_list";
			$this->GetDefaultConfiguration($pdata);
			$this->LoadView($pdata);
		}
	}
	
	public function view_internal_collection() {
		$this->CheckSession(true);
		$uriData = $this->GetUriArray();
		$pdata = array();
		$pdata['title'] = "Internal Collection List";
		$pdata['sub_title'] = "";
		$this->load->model("database/Mtrainee");
		$this->load->model("database/Mbatch");//for dropdown menu
		$batch_data = $this->Mbatch->SelectAll('id,batch_id');
		if($this->session->GetCurrentUserType()=="AD") {
			if(IsPostBack){
				$searchByBatch = trim($_POST['sortByBatch']);
				$pdata['search_value'] = $searchByBatch;
				$this->Mtrainee->batch_id($searchByBatch);
			} else {
				foreach($batch_data as $batch){
					$this->Mtrainee->batch_id($batch->id); break;
				}
			}
			
			$pdata['batch_data'] = $batch_data;
			$internal_data = $this->Mtrainee->SelectJoinAllForInternal();
			$pdata['delete_url'] = site_url("main/delete_internal_collection");
			$pdata['internal_data'] = $internal_data;
			$pdata['LoadViews'] = "internal_collection_list";
			$this->GetDefaultConfiguration($pdata);
			$this->LoadView($pdata);
		}
	}
	
	public function edit_internal_collection() {
		$this->CheckSession(true);
		$this->load->model("database/Mentry_internal");
		$pdata = array();
		$pdata['title'] = "Internal Collection Edit";
		$pdata['sub_title'] = "";
		$pdata['isEdit']=false;
		$uriData = $this->GetUriArray(); 
		if(IsPostBack){		
			$this->Mentry_internal=new Mentry_internal();
			if($this->Mentry_internal->GetFromPostData()){				
				$this->Mentry_internal->internal_id($uriData['id']);
				$this->Mentry_internal->trainee_id($this->Mentry_internal->trainee_id);
				$this->Mentry_internal->mr_no($this->Mentry_internal->mr_no);
				$this->Mentry_internal->date($this->Mentry_internal->date);
				$this->Mentry_internal->amount($this->Mentry_internal->amount);
				
				if($this->Mentry_internal->Update()){
					$this->AddInfo("Successfully Updated",true);
					redirect("main/view_internal_collection");
				}
			}
		}
		if(!empty($uriData['id'])){
			$pdata['isEdit']=true;
			$this->Mentry_internal=new Mentry_internal();
			$this->Mentry_internal->internal_id($uriData['id']);
		
			if($this->Mentry_internal->Select()){
				$pdata['entry_internalObj'] = $this->Mentry_internal;
			}else{
				$pdata['isEdit']=false;
			}
		}		
		$this->GetDefaultConfiguration($pdata);
		$pdata['multipath']=false;
		$pdata['current_batch_id'] = "";
		$pdata['LoadViews']="internal_form";
		$pdata['AutoMsgShow']=false;
		$this->LoadPanel($pdata);
	}
	
	public function delete_internal_collection() {
		$this->CheckSession(true);
		$pdata = array();
		$pdata['errType'] = "";
		$pdata['errMsg'] = "";
		$pdata['title'] = "Internal Collection";
		$pdata['sub_title'] = "";
		$uriData = $this->uri->uri_to_assoc();

		if (isset($uriData['table_pk']) && !empty($uriData['table_pk'])) {
			$internal_pid = $uriData['table_pk'];
			if(!empty($internal_pid)){
				$this->load->model("database/Mentry_internal");
				$this->Mentry_internal = new Mentry_internal();
				$this->Mentry_internal->internal_id($internal_pid);
				if ($this->Mentry_internal->Delete()) {
					$pdata['errType'] = "success";
					$pdata['errMsg'] = "Successfully Deleted";
				}else {
					$pdata['errType'] = "error";
					$pdata['errMsg'] = "Delete Failed";
				}
			} 
		}else {
			$pdata['errType'] = "error";
			$pdata['errMsg'] = "Invalid Vendor Id!";
		}
		
		$pdata['redirectUrl'] = site_url("main/view_internal_collection");
		$pdata['LoadViews'] = "only_message";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadPanel($pdata);
	}
	
	public function add_internal_collection() {
		$this->CheckSession(true);
		$uriData = $this->GetUriArray();
		$this->load->model("database/Mentry_internal");
		if(IsPostBack){
			if($this->Mentry_internal->GetFromPostData()){
				if($this->Mentry_internal->Save()){
					$this->AddInfo("Successfully Added",true);
					redirect("main/add_internal_collection");
				}
			}
		}
		$rData=array();
		$rData['title'] = "Add Internal Collection";
		
		if (isset($uriData['id']) && !empty($uriData['id'])) {
			$rData['current_batch_id'] = $uriData['id'];
		} else {
			$rData['current_batch_id'] = "";
		}
		
		$rData['sub_title'] = "";
		$rData['entry_internalObj']=$this->Mentry_internal;
		$this->GetDefaultConfiguration($rData);
		$rData['multipath']=false; 
		$rData['LoadViews']="internal_form";
		$rData['AutoMsgShow']=false;
		$this->LoadPanel($rData);
	}
	
	public function delete_vendor_collection(){
		$this->CheckSession(true);
		$pdata = array();
		$pdata['errType'] = "";
		$pdata['errMsg'] = "";
		$pdata['title'] = "Vendor Collection List";
		$pdata['sub_title'] = "";
		$uriData = $this->uri->uri_to_assoc();

		if (isset($uriData['table_pk']) && !empty($uriData['table_pk'])) {
			$vendor_collection_pid = $uriData['table_pk'];
			if(!empty($vendor_collection_pid)){
				$this->load->model("database/Mentry_collection");
				$this->Mentry_collection = new Mentry_collection();
				$this->Mentry_collection->pk_id($vendor_collection_pid);
				if ($this->Mentry_collection->Delete()) {
					$pdata['errType'] = "success";
					$pdata['errMsg'] = "Successfully Deleted";
				}else {
					$pdata['errType'] = "error";
					$pdata['errMsg'] = "Delete Failed";
				}
			} 
		}else {
			$pdata['errType'] = "error";
			$pdata['errMsg'] = "Invalid  Id!";
		}
		
		$pdata['redirectUrl'] = site_url("main/view_vendor_collection");
		$pdata['LoadViews'] = "only_message";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadPanel($pdata);
	}
	
	public function view_payment() {
		$this->CheckSession(true);
		$pdata = array();
		$pdata['title'] = "Payment List";
		$pdata['sub_title'] = "";
		$this->load->model("database/Minstructor_payment");
		$this->load->model("database/Minstructor");
		$ins_data = $this->Minstructor->SelectAll('instructor_id,instructor_name');
		$pdata['ins_data'] = $ins_data;
		
		if(IsPostBack){
			$searchByIns = trim($_POST['ins_id']);
			$this->Minstructor_payment->instructor_id($searchByIns);
			$pdata['search_value'] = $searchByIns;
		} else {
			$pdata['search_value'] = "";
		}
		if($this->session->GetCurrentUserType()=="AD") {
		$payment_data = $this->Minstructor_payment->SelectJoin();
		$pdata['delete_url'] = site_url("main/delete_ins_payment");
		$pdata['payment_data'] = $payment_data;
		$pdata['LoadViews'] = "ins_payment_list";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);
		}
	}
	
	public function delete_ins_payment() {
		echo 'It Works';
	}
	
	public function edit_ins_payment() {
		$this->CheckSession(true);
		$this->load->model("database/Minstructor_payment");
		$pdata = array();
		$pdata['title'] = "Payment Edit";
		$pdata['sub_title'] = "";
		$pdata['isEdit']=false;
		$uriData = $this->GetUriArray(); 
		if(IsPostBack){		
			$this->Minstructor_payment=new Minstructor_payment();
			if($this->Minstructor_payment->GetFromPostData()){				
				$this->Minstructor_payment->pk_id($uriData['id']);
				$this->Minstructor_payment->instructor_id($this->Minstructor_payment->instructor_id);
				if ($this->Minstructor_payment->IsPropertySet("date")){
					$formDate = $this->Minstructor_payment->date;
					if (strlen($formDate) == 7){
						$formDate = $formDate."-01";
						$this->Minstructor_payment->date($formDate);
					}
				}
				//$this->Minstructor_payment->date($this->Minstructor_payment->date);
				$this->Minstructor_payment->amount($this->Minstructor_payment->amount);
				
				if($this->Minstructor_payment->Update()){
					$this->AddInfo("Successfully Updated",true);
					redirect("main/view_payment");
				}
			}
		}
		if(!empty($uriData['id'])){
			$pdata['isEdit']=true;
			$this->Minstructor_payment=new Minstructor_payment();
			$this->Minstructor_payment->pk_id($uriData['id']);
		
			if($this->Minstructor_payment->Select()){
				$pdata['instructor_paymentObj'] = $this->Minstructor_payment;
			}else{
				$pdata['isEdit']=false;
			}
		}		
		$this->GetDefaultConfiguration($pdata);
		$pdata['multipath']=false;
		$pdata['LoadViews']="instructor_payment_form";
		$pdata['AutoMsgShow']=false;
		$this->LoadPanel($pdata);
	}
	
	public function add_payment() {
		$this->CheckSession(true);
		$this->load->model("database/Minstructor_payment");
		if(IsPostBack){
			if($this->Minstructor_payment->GetFromPostData()){
				if ($this->Minstructor_payment->IsPropertySet("date")){
					$formDate = $this->Minstructor_payment->date;
					if (strlen($formDate) == 7){
						$formDate = $formDate."-01";
						$this->Minstructor_payment->date($formDate);
					}
				}
				if($this->Minstructor_payment->Save()){
					$this->AddInfo("Successfully Added",true);
					redirect("main/view_payment");
				}
			}
		}
		$rData=array();
		$rData['title'] = "Add Instructor Payment";
		$rData['sub_title'] = "";
		$rData['instructor_paymentObj']=$this->Minstructor_payment;
		$this->GetDefaultConfiguration($rData);
		$rData['multipath']=false; 
		$rData['LoadViews']="instructor_payment_form";
		$rData['AutoMsgShow']=false;
		$this->LoadPanel($rData);
	}
	
	public function view_exam() {
		$this->CheckSession(true);
		$pdata = array();
		$pdata['title'] = "Examination List";
		$pdata['sub_title'] = "";
	
		if($this->session->GetCurrentUserType()=="AD") {
			$this->load->model("database/Mexam_type");
			$exam_data = $this->Mexam_type->SelectAll();
			$pdata['exam_data'] = $exam_data;
			$pdata['delete_url'] = site_url("main/delete_exam");
			$pdata['LoadViews'] = "exam_list";
			$this->GetDefaultConfiguration($pdata);
			$this->LoadPanel($pdata);
		}
	}
	
	public function delete_exam() {
		echo "It Works";
	}
	
	public function edit_exam() {
		$this->CheckSession(true);
		$this->load->model("database/Mexam_type");
		$pdata = array();
		$pdata['title'] = "Examination Edit";
		$pdata['sub_title'] = "";
		$pdata['isEdit']=false;
		$uriData = $this->GetUriArray(); 
		if(IsPostBack){		
			$this->Mexam_type=new Mexam_type();
			if($this->Mexam_type->GetFromPostData()){				
				$this->Mexam_type->exam_id($uriData['id']);
				$this->Mexam_type->exam_code($this->Mexam_type->exam_code);
				$this->Mexam_type->exam_name($this->Mexam_type->exam_name);
				if($this->Mexam_type->Update()){
					$this->AddInfo("Successfully Updated",true);
					redirect("main/view_exam");
				}
			}
		}
		if(!empty($uriData['id'])){
			$pdata['isEdit']=true;
			$this->Mexam_type=new Mexam_type();
			$this->Mexam_type->exam_id($uriData['id']);
		
			if($this->Mexam_type->Select()){
				$pdata['examObj'] = $this->Mexam_type;
			}else{
				$pdata['isEdit']=false;
			}
		}		
		$this->GetDefaultConfiguration($pdata);
		$pdata['multipath']=false;
		$pdata['LoadViews']="exam_form";
		$pdata['AutoMsgShow']=false;
		$this->LoadPanel($pdata);
	}
	
	public function add_participant() {
		$this->CheckSession(true);
		$this->load->model("database/Mparticipant");
		if(IsPostBack){
			if($this->Mparticipant->GetFromPostData()){
				if($this->Mparticipant->Save()){
					$this->AddInfo("Successfully Added",true);
					redirect("main/view_participant");
				}
			}
		}
		$rData=array();
		$rData['title'] = "Add Participant";
		$rData['sub_title'] = "";
		$rData['participantObj']=$this->Mparticipant;
		$this->GetDefaultConfiguration($rData);
		$rData['multipath']=false; 
		$rData['LoadViews']="participant_form";
		$rData['AutoMsgShow']=false;
		$this->LoadPanel($rData);
	}
	
	public function view_participant() {
		$this->CheckSession(true);
		$pdata = array();
		$pdata['title'] = "Participant List";
		$pdata['sub_title'] = "";
		$this->load->model("database/Mparticipant");
		
		if($this->session->GetCurrentUserType()=="AD") {
		$participant_data = $this->Mparticipant->SelectJoin();
		$pdata['delete_url'] = site_url("main/delete_participant");
		$pdata['participant_data'] = $participant_data;
		$pdata['LoadViews'] = "participant_list";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadPanel($pdata);
		}
	}
	
	public function delete_participant() {
		$this->CheckSession(true);
		$pdata = array();
		$pdata['errType'] = "";
		$pdata['errMsg'] = "";
		$pdata['title'] = "Participant";
		$pdata['sub_title'] = "";
		$uriData = $this->uri->uri_to_assoc();

		if (isset($uriData['table_pk']) && !empty($uriData['table_pk'])) {
			$participant_pid = $uriData['table_pk'];
			if(!empty($participant_pid)){
				$this->load->model("database/Mparticipant");
				$this->Mparticipant = new Mparticipant();
				$this->Mparticipant->par_id($participant_pid);
				if ($this->Mparticipant->Delete()) {
					$pdata['errType'] = "success";
					$pdata['errMsg'] = "Successfully Deleted";
				}else {
					$pdata['errType'] = "error";
					$pdata['errMsg'] = "Delete Failed";
				}
			} 
		}else {
			$pdata['errType'] = "error";
			$pdata['errMsg'] = "Invalid Id!";
		}
		
		$pdata['redirectUrl'] = site_url("main/view_participant");
		$pdata['LoadViews'] = "only_message";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadPanel($pdata);
	}
	
	public function edit_participant() {
		$this->CheckSession(true);
		$this->load->model("database/Mparticipant");
		$pdata = array();
		$pdata['title'] = "Participant Edit";
		$pdata['sub_title'] = "";
		$pdata['isEdit']=false;
		$uriData = $this->GetUriArray(); 
		if(IsPostBack){		
			$this->Mparticipant=new Mparticipant();
			if($this->Mparticipant->GetFromPostData()){				
				$this->Mparticipant->par_id($uriData['id']);
				$this->Mparticipant->par_name($this->Mparticipant->par_name);
				$this->Mparticipant->exam_name($this->Mparticipant->exam_name);
				$this->Mparticipant->institute($this->Mparticipant->institute);
				$this->Mparticipant->academic_bg($this->Mparticipant->academic_bg);
				$this->Mparticipant->occupation($this->Mparticipant->occupation);
				$this->Mparticipant->mobile_number($this->Mparticipant->mobile_number);
				$this->Mparticipant->email($this->Mparticipant->email);
			
				if($this->Mparticipant->Update()){
					$this->AddInfo("Successfully Updated",true);
					redirect("main/view_participant");
				}
			}
		}
		if(!empty($uriData['id'])){
			$pdata['isEdit']=true;
			$this->Mparticipant=new Mparticipant();
			$this->Mparticipant->par_id($uriData['id']);
		
			if($this->Mparticipant->Select()){
				$pdata['participantObj'] = $this->Mparticipant;
			}else{
				$pdata['isEdit']=false;
			}
		}		
		$this->GetDefaultConfiguration($pdata);
		$pdata['multipath']=false;
		$pdata['LoadViews']="participant_form";
		$pdata['AutoMsgShow']=false;
		$this->LoadPanel($pdata);
	}
	
	public function view_exam_collection() {
		$this->CheckSession(true);
		$pdata = array();
		$pdata['title'] = "Examination Collection";
		$pdata['sub_title'] = "";
		$this->load->model("database/Mentry_exam");
		
		if($this->session->GetCurrentUserType()=="AD") {
		$exam_data = $this->Mentry_exam->SelectJoin();
		$pdata['delete_url'] = site_url("main/delete_exam_collection");
		$pdata['exam_data'] = $exam_data;
		$pdata['LoadViews'] = "exam_collection_list";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadPanel($pdata);
		}
	}
	
	public function delete_exam_collection() {
		$this->CheckSession(true);
		$pdata = array();
		$pdata['errType'] = "";
		$pdata['errMsg'] = "";
		$pdata['title'] = "Examination Collection";
		$pdata['sub_title'] = "";
		$uriData = $this->uri->uri_to_assoc();

		if (isset($uriData['table_pk']) && !empty($uriData['table_pk'])) {
			$exam_collection_pid = $uriData['table_pk'];
			if(!empty($exam_collection_pid)){
				$this->load->model("database/Mentry_exam");
				$this->Mentry_exam = new Mentry_exam();
				$this->Mentry_exam->pk_id($exam_collection_pid);
				if ($this->Mentry_exam->Delete()) {
					$pdata['errType'] = "success";
					$pdata['errMsg'] = "Successfully Deleted";
				}else {
					$pdata['errType'] = "error";
					$pdata['errMsg'] = "Delete Failed";
				}
			} 
		}else {
			$pdata['errType'] = "error";
			$pdata['errMsg'] = "Invalid Id!";
		}
		
		$pdata['redirectUrl'] = site_url("main/view_exam_collection");
		$pdata['LoadViews'] = "only_message";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadPanel($pdata);
	}
	
	public function edit_exam_collection() {
		$this->CheckSession(true);
		$this->load->model("database/Mentry_exam");
		$pdata = array();
		$pdata['title'] = "Exam Collection Edit";
		$pdata['sub_title'] = "";
		$pdata['isEdit']=false;
		$uriData = $this->GetUriArray(); 
		if(IsPostBack){		
			$this->Mentry_exam=new Mentry_exam();
			if($this->Mentry_exam->GetFromPostData()){				
				$this->Mentry_exam->pk_id($uriData['id']);
				$this->Mentry_exam->perticipant_id($this->Mentry_exam->perticipant_id);
				$this->Mentry_exam->exam_code($this->Mentry_exam->exam_code);
				$this->Mentry_exam->exam_center($this->Mentry_exam->exam_center);
				$this->Mentry_exam->date($this->Mentry_exam->date);
				$this->Mentry_exam->mr_no($this->Mentry_exam->mr_no);
				$this->Mentry_exam->amount($this->Mentry_exam->amount);
			
				if($this->Mentry_exam->Update()){
					$this->AddInfo("Successfully Updated",true);
					redirect("main/view_exam_collection");
				}
			}
		}
		if(!empty($uriData['id'])){
			$pdata['isEdit']=true;
			$this->Mentry_exam=new Mentry_exam();
			$this->Mentry_exam->pk_id($uriData['id']);
		
			if($this->Mentry_exam->Select()){
				$pdata['exam_collectionObj'] = $this->Mentry_exam;
			}else{
				$pdata['isEdit']=false;
			}
		}		
		$this->GetDefaultConfiguration($pdata);
		$pdata['multipath']=false;
		$pdata['LoadViews']="exam_collection_form";
		$pdata['AutoMsgShow']=false;
		$this->LoadPanel($pdata);
	}
	
	public function add_exam_collection() {
		$this->CheckSession(true);
		$this->load->model("database/Mentry_exam");
		if(IsPostBack){
			if($this->Mentry_exam->GetFromPostData()){
				if($this->Mentry_exam->Save()){
					$this->AddInfo("Successfully Added",true);
					redirect("main/view_exam_collection");
				}
			}
		}
		$rData=array();
		$rData['title'] = "Add Exam Collection";
		$rData['sub_title'] = "";
		$rData['exam_collectionObj']=$this->Mentry_exam;
		$this->GetDefaultConfiguration($rData);
		$rData['multipath']=false; 
		$rData['LoadViews']="exam_collection_form";
		$rData['AutoMsgShow']=false;
		$this->LoadPanel($rData);
	}
	
	public function add_exam() {
		$this->CheckSession(true);
		$this->load->model("database/Mexam_type");
		if(IsPostBack){
			if($this->Mexam_type->GetFromPostData()){
				if($this->Mexam_type->Save()){
					$this->AddInfo("Successfully Added",true);
					redirect("main/view_exam");
				}
			}
		}
		$rData=array();
		$rData['title'] = "Add Examination";
		$rData['sub_title'] = "";
		$rData['examObj']=$this->Mexam_type;
		$this->GetDefaultConfiguration($rData);
		$rData['multipath']=false; 
		$rData['LoadViews']="exam_form";
		$rData['AutoMsgShow']=false;
		$this->LoadPanel($rData);
	}
	
	public function edit_vendor_collection() {
		$this->CheckSession(true);
		$this->load->model("database/Mentry_collection");
		$pdata = array();
		$pdata['title'] = "Vendor Collection Edit";
		$pdata['sub_title'] = "";
		$pdata['isEdit']=false;
		$uriData = $this->GetUriArray();
		if(IsPostBack){	
			$this->Mentry_collection=new Mentry_collection();
			if($this->Mentry_collection->GetFromPostData()){
				$this->Mentry_collection->pk_id($uriData['id']);
				$this->Mentry_collection->vendor_id($this->Mentry_collection->vendor_id);
				$this->Mentry_collection->batch_id($this->Mentry_collection->batch_id);
				$this->Mentry_collection->invoice_no($this->Mentry_collection->invoice_no);
				$this->Mentry_collection->mr_no($this->Mentry_collection->mr_no);
				$this->Mentry_collection->date($this->Mentry_collection->date);
				$this->Mentry_collection->amount($this->Mentry_collection->amount);
				
				if($this->Mentry_collection->Update()){
					$this->AddInfo("Successfully Updated",true);
					redirect("main/view_vendor_collection");
				}
			}
		}
		if(!empty($uriData['id'])){
			$pdata['isEdit']=true;
			$this->Mentry_collection=new Mentry_collection();
			$this->Mentry_collection->pk_id($uriData['id']);
		
			if($this->Mentry_collection->Select()){
				$pdata['entry_collectionObj'] = $this->Mentry_collection;
			}else{
				$pdata['isEdit']=false;
			}
		}		
		$this->GetDefaultConfiguration($pdata);
		$pdata['multipath']=false;
		$pdata['LoadViews']="entry_collection_form";
		$pdata['AutoMsgShow']=false;
		$this->LoadPanel($pdata);
	}
	
	public function add_vendor_collection() {
		$this->CheckSession(true);
		$this->load->model("database/Mentry_collection");
		if(IsPostBack){
			if($this->Mentry_collection->GetFromPostData()){
				if($this->Mentry_collection->Save()){
					$this->AddInfo("Successfully Added",true);
					redirect("main/add_vendor_collection");
				}
			}
		}
		$rData=array();
		$rData['title'] = "Add Vendor Collection";
		$rData['sub_title'] = "";
		$rData['entry_collectionObj']=$this->Mentry_collection;
		$this->GetDefaultConfiguration($rData);
		$rData['multipath']=false; 
		$rData['LoadViews']="entry_collection_form";
		$rData['AutoMsgShow']=false;
		$this->LoadPanel($rData);
	}
	
	public function edit_invoice() {
		$this->CheckSession(true);
		$this->load->model("database/Minvoice");
		$pdata = array();
		$pdata['title'] = "Invoice Edit";
		$pdata['sub_title'] = "";
		$pdata['isEdit']=false;
		$uriData = $this->GetUriArray(); 
		if(IsPostBack){		
			$this->Minvoice=new Minvoice();
			if($this->Minvoice->GetFromPostData()){				
				$this->Minvoice->invoice_id($uriData['id']);
				$this->Minvoice->vendor_id($this->Minvoice->vendor_id);
				$this->Minvoice->batch_id($this->Minvoice->batch_id);
				$this->Minvoice->invoice_no($this->Minvoice->invoice_no);
				$this->Minvoice->inv_date($this->Minvoice->inv_date);
				$this->Minvoice->amount($this->Minvoice->amount);
				
				if($this->Minvoice->Update()){
					$this->AddInfo("Successfully Updated",true);
					redirect("main/view_invoice");
				}
			}
		}
		if(!empty($uriData['id'])){
			$pdata['isEdit']=true;
			$this->Minvoice=new Minvoice();
			$this->Minvoice->invoice_id($uriData['id']);
		
			if($this->Minvoice->Select()){
				$pdata['invoiceObj'] = $this->Minvoice;
			}else{
				$pdata['isEdit']=false;
			}
		}		
		$this->GetDefaultConfiguration($pdata);
		$pdata['multipath']=false;
		$pdata['LoadViews']="invoice_form";
		$pdata['AutoMsgShow']=false;
		$this->LoadPanel($pdata);
	}
	
	public function delete_invoice() {
		$this->CheckSession(true);
		$pdata = array();
		$pdata['errType'] = "";
		$pdata['errMsg'] = "";
		$pdata['title'] = "Invoice List";
		$pdata['sub_title'] = "";
		$uriData = $this->uri->uri_to_assoc();

		if (isset($uriData['table_pk']) && !empty($uriData['table_pk'])) {
			$invoice_pid = $uriData['table_pk'];
			if(!empty($invoice_pid)){
				$this->load->model("database/Minvoice");
				$this->Minvoice = new Minvoice();
				$this->Minvoice->invoice_id($invoice_pid);
				if ($this->Minvoice->Delete()) {
					$pdata['errType'] = "success";
					$pdata['errMsg'] = "Successfully Deleted";
				}else {
					$pdata['errType'] = "error";
					$pdata['errMsg'] = "Delete Failed";
				}
			} 
		}else {
			$pdata['errType'] = "error";
			$pdata['errMsg'] = "Invalid Vendor Id!";
		}
		
		$pdata['redirectUrl'] = site_url("main/view_invoice");
		$pdata['LoadViews'] = "only_message";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadPanel($pdata);
	}
	
	public function view_invoice() {
		$this->CheckSession(true);
		$pdata = array();
		$pdata['title'] = "Invoice List";
		$pdata['sub_title'] = "";
		$pdata['search_value'] = "";
		$this->load->model("database/Minvoice");
		$this->load->model("database/Mvendor");
		$vendor_data = $this->Mvendor->SelectAll();
		$pdata['vendor_data'] = $vendor_data;//for drop down menu
		$this->load->model("database/Mbatch");
		$batch_data = $this->Mbatch->SelectAll('id,batch_id');
		$pdata['batch_data'] = $batch_data;//for dropdown menu
		
			if(IsPostBack){
			$property = $this->input->post("property", true);
			$dropdownValue = $this->input->post("dropdownValue", true);
			$searchValue = $this->input->post("search", true);
			$fromDate = $this->input->post("fromDate", true);
			$toDate = $this->input->post("toDate", true);
			
			/* echo "Property: " . $property . " Drop down value: " . $dropdownValue . " Input field: " . $searchValue .
			" From Date: " . $fromDate . " To Date: " . $toDate; */
				if(!empty($property) && ($property == "vendor_id" || $property == "batch_id") && !empty($dropdownValue)){
					$this->Minvoice->$property($dropdownValue);
					$pdata['search_value'] = $dropdownValue;
					$pdata['property'] = $property;
				}
				
				if(!empty($property) && $property == "invoice_no"  && !empty($searchValue)){
					$this->Minvoice->$property($searchValue);
					$pdata['search_value'] = $searchValue;
					$pdata['property'] = $property;
				}
				
				if(empty($property) && !empty($fromDate) && !empty($toDate)){
					$query = "SELECT `invoice`.*, `ven`.`vendor_name`, `bat`.`batch_id` AS batch_name 
							FROM (`invoice`) 
							LEFT JOIN `vendor` AS ven ON `ven`.`vendor_id`=`invoice`.`vendor_id` 
							LEFT JOIN `batch` AS bat ON `bat`.`id`=`invoice`.`batch_id` 
							WHERE `invoice`.`inv_date` >= '$fromDate' AND  `invoice`.`inv_date` <= '$toDate' ";
					
					$records = $this->db->query($query);
					$invoice_data = $records->result();
					$pdata['delete_url'] = site_url("main/delete_invoice");
					$pdata['search_value'] = "";
					$pdata['property'] = "";
					$pdata['fromDate'] = $fromDate;
					$pdata['toDate'] = $toDate;
					$pdata['invoice_list'] = $invoice_data;
					$pdata['LoadViews'] = "invoice_list";
					$this->GetDefaultConfiguration($pdata);
					$this->LoadView($pdata);return;
				}
			
			} else {
				$this->Minvoice->vendor_id($vendor_data[0]->vendor_id);
				$pdata['search_value'] = "";
				$pdata['property'] = "";
			}
		
		if($this->session->GetCurrentUserType()=="AD") {
		$invoice_data = $this->Minvoice->SelectJoin();
		$pdata['delete_url'] = site_url("main/delete_invoice");
		$pdata['invoice_list'] = $invoice_data;
		$pdata['LoadViews'] = "invoice_list";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);
		}
	}
	
	public function view_vendor() {
		$this->CheckSession(true);
		$pdata = array();
		$pdata['title'] = "Vendor List";
		$pdata['sub_title'] = "";
	
		if($this->session->GetCurrentUserType()=="AD") {
			$this->load->model("database/Mvendor");
			$vendor_data = $this->Mvendor->SelectAll();
			$pdata['vendor_list'] = $vendor_data;
			$pdata['delete_url'] = site_url("main/delete_vendor");
			$pdata['LoadViews'] = "vendor_list";
			$this->GetDefaultConfiguration($pdata);
			$this->LoadPanel($pdata);
		}
	}
	
	public function edit_vendor() {
		$this->CheckSession(true);
		$this->load->model("database/Mvendor");
		$pdata = array();
		$pdata['title'] = "Vendor Edit";
		$pdata['sub_title'] = "";
		$pdata['isEdit']=false;
		$uriData = $this->GetUriArray(); 
		if(IsPostBack){		
			$this->Mvendor=new Mvendor();
			if($this->Mvendor->GetFromPostData()){				
				$this->Mvendor->vendor_id($uriData['id']);
				$this->Mvendor->vendor_name($this->Mvendor->vendor_name);
				if($this->Mvendor->Update()){
					$this->AddInfo("Successfully Updated",true);
					redirect("main/view_vendor");
				}
			}
		}
		if(!empty($uriData['id'])){
			$pdata['isEdit']=true;
			$this->Mvendor=new Mvendor();
			$this->Mvendor->vendor_id($uriData['id']);
		
			if($this->Mvendor->Select()){
				$pdata['vendorObj'] = $this->Mvendor;
			}else{
				$pdata['isEdit']=false;
			}
		}		
		$this->GetDefaultConfiguration($pdata);
		$pdata['multipath']=false;
		$pdata['LoadViews']="vendor_form";
		$pdata['AutoMsgShow']=false;
		$this->LoadPanel($pdata);
	}
	
	public function delete_vendor () {
		$this->CheckSession(true);
		$pdata = array();
		$pdata['errType'] = "";
		$pdata['errMsg'] = "";
		$pdata['title'] = "Vendor List";
		$pdata['sub_title'] = "";
		$uriData = $this->uri->uri_to_assoc();

		if (isset($uriData['table_pk']) && !empty($uriData['table_pk'])) {
			$vendor_pid = $uriData['table_pk'];
			if(!empty($vendor_pid)){
				$this->load->model("database/Mvendor");
				$this->Mvendor = new Mvendor();
				$this->Mvendor->vendor_id($vendor_pid);
				if ($this->Mvendor->Delete()) {
					$pdata['errType'] = "success";
					$pdata['errMsg'] = "Successfully Deleted";
				}else {
					$pdata['errType'] = "error";
					$pdata['errMsg'] = "Delete Failed";
				}
			} 
		}else {
			$pdata['errType'] = "error";
			$pdata['errMsg'] = "Invalid Vendor Id!";
		}
		
		$pdata['redirectUrl'] = site_url("main/view_vendor");
		$pdata['LoadViews'] = "only_message";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadPanel($pdata);
	}
	
	public function get_topic() {
		$course_id = isset($_REQUEST["cid"]) ? $_REQUEST["cid"] : "";
		
		$this->load->model("database/Mtopics");
		$this->Mtopics->course_id($course_id);
		$topic_data = $this->Mtopics->SelectAll();
		
		if($topic_data==null) $topic_data = array();
		echo json_encode($topic_data);
		
		//echo $topic_data!=null ? json_encode($topic_data) : json_encode(array());
		exit;
	}
		
	
	public function add_instructor() {
		$this->CheckSession(true);
		$this->load->model("database/Minstructor");
	
		if(IsPostBack){
			if($this->Minstructor->GetFromPostData()){
				 if($this->Minstructor->Save()){
					$this->AddInfo("Successfully Added",true);
					 if($_FILES['file_upload']['error']==0){
						$id=$this->Minstructor->GetUpdateDB()->insert_id();
						//$dpath=BASEPATH."../img/instructor/".$id.substr($_FILES['file_upload']['name'], -4);
						//Whatever the image type (jpeg, jpg, gif, png), it always save as table pk id.jpg
						$dpath=BASEPATH."../img/instructor/".$id.'.jpg';
						if(file_exists($dpath)){
							unlink($dpath);
						}
						if(copy($_FILES['file_upload']['tmp_name'], $dpath)){
							$this->AddInfo("Image Successfully Uploaded",true);
							//redirect("main/add_instructor");
						}
					}
						
				} 
			}
		}
	
		$rData=array();
		$rData['title'] = "Add Instructor";
		$rData['sub_title'] = "";
		$rData['instructorObj']=$this->Minstructor;
		$this->GetDefaultConfiguration($rData);
		$rData['multipath']=true; //This field is needed for photo upload and it sets enctype="multipart/form-data" on form action
		$rData['LoadViews']="instructor_form";
		$rData['AutoMsgShow']=false;
		$this->LoadPanel($rData);
		//$this->load->view("instructor_form", $rData);  
	}
	
	public function view_trainee_details() {
		$this->CheckSession(true);
		$this->load->model("database/Mtrainee");
		$uriData = $this->GetUriArray();
		$pdata = array();
		//$pdata['title'] = urldecode($uriData['name']);
		$pdata['sub_title'] = "";
		if(!empty($uriData['id'])){
			$this->Mtrainee->id($uriData['id']); //id is the pk coloumn name  trainee_name
			$this->Mtrainee->SelectJoin();
			$pdata['title'] = $this->Mtrainee->trainee_name;
			$pdata['traineeObj'] = $this->Mtrainee;
			$this->GetDefaultConfiguration($pdata);
			$pdata['LoadViews']="trainee_details_view";
			$this->LoadPanel($pdata);
		}
		
	}
	

	//id,trainee_id,trainee_name,institute,academic_bg,occupation,course_id,batch_id,mobile_number,email,course_fee,certificate_code,nid
	public function edit_trainee() {
		$this->CheckSession(true);
		$this->load->model("database/Mtrainee");
		$pdata = array();
		$pdata['title'] = "Trainee Edit";
		$pdata['sub_title'] = "";
		$pdata['isEdit']=false;
		$uriData = $this->GetUriArray(); // Like $uriData = $this->uri->uri_to_assoc();
		if(IsPostBack){
			$this->Mtrainee=new Mtrainee();
			if($this->Mtrainee->GetFromPostData()){
				$this->Mtrainee->id($uriData['id']); //pk
				$this->Mtrainee->trainee_id($this->Mtrainee->trainee_id);
				$this->Mtrainee->institute($this->Mtrainee->institute);
				$this->Mtrainee->academic_bg($this->Mtrainee->academic_bg);
				$this->Mtrainee->occupation($this->Mtrainee->occupation);
				$this->Mtrainee->course_id($this->Mtrainee->course_id);
				$this->Mtrainee->batch_id($this->Mtrainee->batch_id);
				$this->Mtrainee->mobile_number($this->Mtrainee->mobile_number);
				$this->Mtrainee->email($this->Mtrainee->email);
				$this->Mtrainee->course_fee($this->Mtrainee->course_fee);
				$this->Mtrainee->certificate_code($this->Mtrainee->certificate_code);
				$this->Mtrainee->nid($this->Mtrainee->nid);
				if($this->Mtrainee->Update()){
					$this->AddInfo("Successfully Updated",true);
	
				}
				if($_FILES['file_upload']['error']==0){
					//$id=$this->Minstructor->GetUpdateDB()->insert_id();
					$dpath=BASEPATH."../img/trainee/" . $uriData['id'] . '.jpg';
					if(file_exists($dpath)){
						unlink($dpath);
					}
					if(copy($_FILES['file_upload']['tmp_name'], $dpath)){
						$this->AddInfo("Image Successfully Uploaded",true);
						//redirect("main/view_trainee_details/id/".$uriData['id'] .  "/name/" . $uriData['name'] );
					}
				}
				redirect("main/view_trainee_details/id/".$uriData['id'] );
			}
		}
		if(!empty($uriData['id'])){
	
			$pdata['isEdit']=true;
	
			$this->Mtrainee=new Mtrainee();
			$this->Mtrainee->id($uriData['id']); 
	
			if($this->Mtrainee->Select()){
				$pdata['traineeObj'] = $this->Mtrainee;
				$this->AddOldFields($this->Mtrainee, "trainee_id,trainee_name,institute,academic_bg,occupation,course_id,batch_id,mobile_number,email,course_fee,certificate_code,nid");
			}else{
				$pdata['isEdit']=false;
			}
		}
	
		$this->GetDefaultConfiguration($pdata);
		$pdata['multipath']=true;
		$pdata['LoadViews']="trainee_form";
		$pdata['AutoMsgShow']=false;
		$this->LoadPanel($pdata);
	}
	
	
	//instructor_id,instructor_name,father_name,mother_name,address,gender,mobile_number,email,last_degree_achieved
	public function edit_inst() {
		$this->CheckSession(true);
		$this->load->model("database/Minstructor");
		$pdata = array();
		$pdata['title'] = "Instructor Edit";
		$pdata['sub_title'] = "";
		$pdata['isEdit']=false;
		$uriData = $this->GetUriArray(); // Like $uriData = $this->uri->uri_to_assoc();
		if(IsPostBack){
			$this->Minstructor=new Minstructor();
			if($this->Minstructor->GetFromPostData()){
				$this->Minstructor->instructor_id($uriData['id']);
				$this->Minstructor->instructor_name($this->Minstructor->instructor_name);
				$this->Minstructor->father_name($this->Minstructor->father_name);
				$this->Minstructor->mother_name($this->Minstructor->mother_name);
				$this->Minstructor->address($this->Minstructor->address);
				$this->Minstructor->gender($this->Minstructor->gender);
				$this->Minstructor->mobile_number($this->Minstructor->mobile_number);
				$this->Minstructor->email($this->Minstructor->email);
				$this->Minstructor->password($this->Minstructor->password);
				$this->Minstructor->last_degree_achieved($this->Minstructor->last_degree_achieved);
				if($this->Minstructor->Update()){
					$this->AddInfo("Successfully Updated",true);
						
				}
				if($_FILES['file_upload']['error']==0){
					//$id=$this->Minstructor->GetUpdateDB()->insert_id();
					$dpath=BASEPATH."../img/instructor/" . $uriData['id'] . '.jpg';
					if(file_exists($dpath)){
						unlink($dpath);
					}
					if(copy($_FILES['file_upload']['tmp_name'], $dpath)){
						$this->AddInfo("Image Successfully Uploaded",true);
						redirect("main/edit_inst/id/".$uriData['id']);
					}
				}
			}
		}
		if(!empty($uriData['id'])){
			
			$pdata['isEdit']=true;
		
			$this->Minstructor=new Minstructor();
			$this->Minstructor->instructor_id($uriData['id']); //instructor_id is the pk column name
		
			if($this->Minstructor->Select()){
				$pdata['instructorObj'] = $this->Minstructor;				
				$this->AddOldFields($this->Minstructor, "instructor_name,father_name,mother_name,address,gender,mobile_number,email,password,last_degree_achieved");
			}else{
				$pdata['isEdit']=false;
			}
		}
		
		$this->GetDefaultConfiguration($pdata);
		$pdata['multipath']=true;
		$pdata['LoadViews']="instructor_form";
		$pdata['AutoMsgShow']=false;
		$this->LoadPanel($pdata);
	}

	
	public function edit_batch() {
		$this->CheckSession(true);
		$this->load->model("database/Mbatch");
		$pdata = array();
		$pdata['title'] = "Batch Edit";
		$pdata['sub_title'] = "";
		$pdata['isEdit']=false;
		$uriData = $this->GetUriArray(); // Like $uriData = $this->uri->uri_to_assoc();
		if(IsPostBack){
			$this->Mbatch=new Mbatch();
			if($this->Mbatch->GetFromPostData()){
				$this->Mbatch->id($uriData['id']);
				$this->Mbatch->batch_id($this->Mbatch->batch_id);
				$this->Mbatch->start_date($this->Mbatch->start_date);
				$this->Mbatch->end_date($this->Mbatch->end_date);
				$this->Mbatch->no_of_trainee($this->Mbatch->no_of_trainee);
				$this->Mbatch->course_id($this->Mbatch->course_id);
				$this->Mbatch->instructor_id($this->Mbatch->instructor_id);
				if($this->Mbatch->Update()){
					$this->AddInfo("Successfully Updated",true);
					//redirect("main/edit_batch/id/".$uriData['id']);
					redirect("main/view_batch");
				}
			}
		}
		if(!empty($uriData['id'])){
			$pdata['isEdit']=true;
		
			$this->Mbatch=new Mbatch();
			$this->Mbatch->id($uriData['id']);
		
			if($this->Mbatch->Select()){
				$pdata['batchObj'] = $this->Mbatch;
			}else{
				$pdata['isEdit']=false;
			}
		}
		$this->GetDefaultConfiguration($pdata);
		$pdata['LoadViews']="batch_form";
		$pdata['AutoMsgShow']=false;
		$this->LoadPanel($pdata);
	}
	
	public function edit_course() {
		$this->CheckSession(true);
		$this->load->model("database/Mcourse");
		$pdata = array();
		$pdata['title'] = "Course Edit";
		$pdata['sub_title'] = "";
		$pdata['isEdit']=false;
		$uriData = $this->GetUriArray(); // Like $uriData = $this->uri->uri_to_assoc();	
		if(IsPostBack){		
			$this->Mcourse=new Mcourse();
			if($this->Mcourse->GetFromPostData()){				
				$this->Mcourse->course_id($uriData['id']);
				$this->Mcourse->course_name($this->Mcourse->course_name);
				$this->Mcourse->course_fee($this->Mcourse->course_fee);
				//$this->Mcourse->SetWhereUpdate("course_id", $uriData['id']);
				if($this->Mcourse->Update()){
					$this->AddInfo("Successfully Updated",true);
					redirect("main/edit_course/id/".$uriData['id']);
				}
			}
		}
		if(!empty($uriData['id'])){
			$pdata['isEdit']=true;
				
			$this->Mcourse=new Mcourse();
			$this->Mcourse->course_id($uriData['id']);
		
			if($this->Mcourse->Select()){
				$pdata['courseObj'] = $this->Mcourse;
			}else{
				$pdata['isEdit']=false;
			}
		}		
		$this->GetDefaultConfiguration($pdata);
		$pdata['multipath']=true;
		$pdata['LoadViews']="course_form";
		$pdata['AutoMsgShow']=false;
		$this->LoadPanel($pdata);
	}
	

	
	
	public function delete_batch(){
		$this->CheckSession(true);
		$pdata = array();
		$pdata['errType'] = "";
		$pdata['errMsg'] = "";
		$pdata['title'] = "Batch List";
		$pdata['sub_title'] = "";
		$uriData = $this->uri->uri_to_assoc();
		//print_r($uriData);

		if (isset($uriData['table_pk']) && !empty($uriData['table_pk'])) {
			$batch_pid = $uriData['table_pk'];
			if(!empty($batch_pid)){
				$this->load->model("database/Mbatch");
				$this->Mbatch = new Mbatch();
				//Primary key is required by GS model to delete the row.
				$this->Mbatch->id($batch_pid); //Dont be confused!! This is the rule of GS model. It is actually not setting
				//the value of Mbatch property. The argument ["id($batch_pid)"] pass to GSModel.php to function __call($func, $args)
				if ($this->Mbatch->Delete()) {
					$pdata['errType'] = "success";
					$pdata['errMsg'] = "Successfully Deleted";
				}else {
					$pdata['errType'] = "error";
					$pdata['errMsg'] = "Delete Failed";
				}
			} 
		}else {
			$pdata['errType'] = "error";
			$pdata['errMsg'] = "Invalid Batch Id!";
		}
		
		$pdata['redirectUrl'] = site_url("main/index");
		$pdata['LoadViews'] = "only_message";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadPanel($pdata);
	}
	
	
	
	/*public function GetDefaultConfiguration(&$rData, $DisbleButton = false){		
		parent::GetDefaultConfiguration($rData,$DisbleButton);		
	}*/
	
	

	
	public function add_instCertificate() {
		$this->CheckSession(true);
		$this->load->model("database/Minstructor_certification");
		
		if(IsPostBack){
			if($this->Minstructor_certification->GetFromPostData()){
				if($this->Minstructor_certification->Save()){
					die("Successfully Added");
				}
			}
		}
		
		$rData=array();
		$rData['instructor_certificationObj']=$this->Minstructor_certification;
		
		$this->load->view("instructor_certification_form", $rData);
	}
	
	private  function LoadPanel($rData){
		$this->load->view("userBody",$rData);
	}
	//common_view.php
	
	private function LoadView($rData) {
		$this->load->view("common_view",$rData);
	}
	
	public function LoginPanel($rData) {
		$this->load->view("login",$rData);
	}
	
	public function lock_screen_panel($rData) {
		$this->load->view("lock_screen",$rData);
	}

}
?>