<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage extends MY_Controller {

	function __construct() {
		parent::__construct ();
	}
	
	
	
	
	public function index() {
		$this->load->library('table');
		$batch_list = array();
		$this->load->model('Batch');
		$batches = $this->Batch->get();
		foreach ($batches as $batch) {
			$batch_list[] = array(
					$batch->batch_id,
					$batch->start_date,
					$batch->end_date,
					$batch->no_of_trainee,
					$batch->course_id,
					$batch->instructor_id,
			);
		}
		
	
		$this->load->view('batch_list', array('batch_list' => $batch_list));
	
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
    public function add_course() {
    	$vdata = array(); 
        $this->load->model('Course');
        $this->Course = new Course();

        $this->load->library('form_validation');
        $this->form_validation->set_rules(array(
        array(
        	'field' => 'course_name',
        	'label' => 'Course Name',
        	'rules' => 'required',),
       ));
        
      $this->form_validation->set_error_delimiters('<div class="alert alert-error">', '</div>');  
      
      if (!$this->form_validation->run()) {
      	//$this->load->view('course_form');
      	
      	$vdata ['mainPage'] = "course_form";
      	//$this->getDefaultConfig( $vdata );
      	$this->load->view ( "common_view", $vdata );
      	
      } else {
      	    $this->load->model('Course');
            $course = new Course();
            $course->course_name = $this->input->post('course_name');
            $course->save();
            
            $vdata ['course'] = $course;
            $vdata ['mainPage'] = "course_form_success";            
            $this->load->view ( "common_view", $vdata );
      }

    }
    
    public function add() {
    	$this->load->model('Publication');
    	$this->Publication = new Publication();
    	$publications = $this->Publication->get();
    	$publication_form_options = array();
    	foreach ($publications as $id => $publications) {
    		$publication_form_options[$id] = $publications->publication_name;
    	}
    	$this->load->library('form_validation');
    	$this->form_validation->set_rules(array(
    			array(
    					'field' => 'publication_id',
    					'label' => 'Publication',
    					'rules' => 'required',
    			),
    	));
    
    	$this->form_validation->set_error_delimiters('<div class="alert alert-error">', '</div>');
    
    	if (!$this->form_validation->run()) {
    		$this->load->view('magazine_form', array(
    				'publication_form_options' => $publication_form_options,
    		));
    	} else {
    		$this->load->model('Issue');
    		$issue = new Issue();
    		$issue->publication_id = $this->input->post('publication_id');
    		$issue->issue_number = $this->input->post('issue_number');
    		$issue->issue_date_publication = $this->input->post('issue_date_publication');
    		$issue->save();
    		$this->load->view('magazine_form_success', array(
    				'issue' => $issue,
    		));
    	}
    
    	$this->load->view('bootstrap/footer');
    
    }   
    
    public function add_batch() {
    
    	$vdata = array();
    	$this->load->model('Instructor');
    	$this->Instructor = new Instructor();
    	$instructors = $this->Instructor->get();
    	
    	$batch_form_options = array();
    	foreach ($instructors as $id => $instructors) {
    		$batch_form_options[$id] = $instructors->instructor_name;
    	}
    	
    	$this->load->model('Course');
    	$this->Course = new Course();
    	$courses = $this->Course->get();
    	$course_options = array();

    	foreach ($courses as $id => $courses) {
    		$course_options[$id] = $courses->course_name;
    	}

    	$this->load->model('Batch');
    	$this->Batch = new Batch();
    
    	$this->load->library('form_validation');

    	$this->form_validation->set_rules(array(
    			array(
    					'field' => 'batch_id',
    					'label' => 'Batch ID',
    					'rules' => 'required',
    			),
    			array(
    					'field' => 'start_date',
    					'label' => 'Start Date',
    					'rules' => 'required|callback_date_validation',
    			),
    			array(
    					'field' => 'end_date',
    					'label' => 'Batch End Date',
    					'rules' => 'required|callback_date_validation',
    			),
    			array(
    					'field' => 'no_of_trainee',
    					'label' => 'Number of Trainee',
    					'rules' => 'required|is_numeric',
    			),
    	));
    
    	$this->form_validation->set_error_delimiters('<div class="alert alert-error">', '</div>');
    
    	if (!$this->form_validation->run()) {
    		//$this->load->view('batch_form');
    		$this->load->view('batch_form', 
    				array('batch_form_options' => $batch_form_options, 'course_options' => $course_options));
    		//$vdata ['mainPage'] = "batch_form";
    		//$this->load->view ( "common_view", $vdata, $batch_form_options );
    		
    	} else {
    		$this->load->model('Batch');
    		$batch = new Batch();
    		$batch->batch_id = $this->input->post('batch_id');
    		$batch->start_date = $this->input->post('start_date');
    		$batch->end_date = $this->input->post('end_date');
    		$batch->no_of_trainee = $this->input->post('no_of_trainee');
    		$batch->course_id = $this->input->post('course_id');
    		$batch->instructor_id = $this->input->post('instructor_id');
    		
    		$batch->save();
    		
    		$this->load->view('batch_form_success', array('batch' => $batch));
    	}
    
    }
    
    
    
    public function add_instructor() {
    
    	$vdata = array();
    	$this->load->model('Instructor');
    	$this->Instructor = new Instructor();
    
    	$this->load->library('form_validation');
    	/*
    	 CREATE TABLE IF NOT EXISTS instructor (
    	 		instructor_id int(11) NOT NULL AUTO_INCREMENT,
    	 		instructor_name varchar(100) NOT NULL,
    	 		father_name varchar(100) NOT NULL,
    	 		mother_name varchar(100) NOT NULL,
    	 		address text,
    	 		gender varchar(8) NOT NULL,
    	 		mobile_number varchar(15) NOT NULL,
    	 		email varchar(100) NOT NULL,
    	 		last_degree_achieved varchar(150) NOT NULL,
    	 		PRIMARY KEY (`instructor_id`)
    	 ); */
    	$this->form_validation->set_rules(array(
    			array(
    					'field' => 'instructor_name',
    					'label' => 'Instructor Name',
    					'rules' => 'required',),
    			array(
    					'field' => 'father_name',
    					'label' => 'Father Name',
    					'rules' => 'required',
    			),
    			array(
    					'field' => 'mother_name',
    					'label' => 'Mother Name',
    					'rules' => 'required',
    			),
    			array(
    					'field' => 'address',
    					'label' => 'Residance Address',
    					'rules' => 'required',
    			),
    			array(
    					'field' => 'gender',
    					'label' => 'Gender',
    					'rules' => 'required',
    			),
    			array(
    					'field' => 'mobile_number',
    					'label' => 'Mobile Number',
    					'rules' => 'required',
    			),
    			array(
    					'field' => 'email',
    					'label' => 'e-mail address',
    					'rules' => 'required',
    			),
    			array(
    					'field' => 'last_degree_achieved',
    					'label' => 'Last Degree Achieved',
    					'rules' => 'required',
    			),
    	));
    
    	$this->form_validation->set_error_delimiters('<div class="alert alert-error">', '</div>');
    
    	if (!$this->form_validation->run()) {
    		//$this->load->view('instructor_form');
    		$vdata ['mainPage'] = "instructor_form";
    		$this->load->view ( "common_view", $vdata );
    	} else {
    		$this->load->model('Instructor');
    		$instructor = new Instructor();
    		$instructor->instructor_name = $this->input->post('instructor_name');
    		$instructor->father_name = $this->input->post('father_name');
    		$instructor->mother_name = $this->input->post('mother_name');
    		$instructor->address = $this->input->post('address');
    		$instructor->gender = $this->input->post('gender');
    		$instructor->mobile_number = $this->input->post('mobile_number');
    		$instructor->email = $this->input->post('email');
    		$instructor->last_degree_achieved = $this->input->post('last_degree_achieved');
    		
    		$instructor->save();
    		
    		$vdata ['instructor'] = $instructor;
    		$vdata ['mainPage'] = "instructor_form_success";
    		$this->load->view ( "common_view", $vdata );
    		
    		//$this->load->view('instructor_form_success', array('instructor' => $instructor,));
    	}
    
    }
    
    
    
    
    /**
     * Date validation callback.
     * @param string $input
     * @return boolean
     */
    public function date_validation($input) {
        $test_date = explode('-', $input);
        if (!@checkdate($test_date[1], $test_date[2], $test_date[0])) {
            $this->form_validation->set_message('date_validation', 'The %s field must be in YYYY-MM-DD format.');
            return FALSE;
        }
        return TRUE;
    }
    
}
























