<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Task extends GSController {
	
	public function index() {
		$this->load->model("database/Madmin");
		
		if($this->CheckSession()) {
			redirect("task/dashboard");die;
		}
		
		$message="";
		
		if(IsPostBack){
			$email = trim($_POST['email']);
			$password = trim($_POST['password']);
			if ($this->Madmin->authenticate($email, $password)) {
				$uType = $this->session->GetCurrentUserType();
				if($uType == "AD"){
					redirect("task/dashboard");
				} else {
					redirect("task/vprofile");
				}
				
			} else {
				$message = "User ID/password combination incorrect.";
			}
		}
		
		$this->load->model("database/Madmin");
		$rData=array();
		$rData['loginObj']=$this->Madmin;
		$rData['title'] = "VT Corporate Cup PM Application";
		$rData['field'] = "User ID";
		$rData['msg'] = $message;
		$this->GetDefaultConfiguration($rData);
		$this->LoginPanel($rData);
		//redirect("task/dashboard");
	}
	
	
	
	
	
	
	
	
	
	public function forgot_password() {
		$this->load->model("database/Madmin");
		$ad = new Madmin();
	
		if($this->CheckSession()) {
			//redirect("task/dashboard");die;
		}
	
		$message="";
	
		if(IsPostBack){
		    $email = $this->input->post("email", true);
	    	$this->load->library("reCaptcha",array('config' => array()));
	    	$recap = new reCaptcha('6LdWrxsTAAAAALPx21yYxCHR4xbvUxm4HqQFz-YV');
	    	if($recap->CheckHumanFromPost()){	
	    		$ad->email($email);
	    		if($ad->Select()){
	    			$this->SendForgotPasswordLink($email, $ad->admin_pid);
	    			$this->AddInfo("A reset link has been emailed successfully");
	    			$isEmailSent=true;
	    		}else{
	    			$this->AddError("Invalid Email ID");
	    		}	
	    	}else {
	    		if($recap->IsErrorByErrorCode(reCaptcha::INVALID_INPUT_SECRET)){
	    			$this->AddError("You are a robot.");
	    		}elseif($recap->IsErrorByErrorCode(reCaptcha::INVALID_INPUT_RESPONSE)){
	    			$this->AddError("The secret parameter is invalid or malformed. .");
	    		}elseif($recap->IsErrorByErrorCode(reCaptcha::MISSING_INPUT_RESPONSE)){
	    			$this->AddError("Robot validation failed");
	    		}elseif($recap->IsErrorByErrorCode(reCaptcha::MISSING_INPUT_SECRET)){
	    			$this->AddError("The secret parameter is missing.");
	    		}else{
	    			$this->AddError("Robot validation failed.");
	    		}
	    	}
    }
	
		$rData=array();
		$rData['loginObj']=$this->Madmin;
		$rData['title'] = "VT Corporate Cup PM Application";
		$rData['field'] = "User ID";
		$rData['msg'] = $message;
		$this->GetDefaultConfiguration($rData);
		$this->load->view("forgot_password",$rData);
		//$this->LoginPanel($rData);
		//redirect("task/dashboard");
	}
	
	public function confirmation(){
		$this->load->library("GSEncryption");
		$message = "";
		$pdata = array();
		$isExpired = false;
		$this->load->model("database/Madmin");
		$ad = new Madmin();
		//http://localhost/gt/main/confirmation?u=aca7d7bdf6b883e3f62231c1af481445f8176247d18ff45ef8cf22c1a8868526e7e76c0fdd98cdbd53a7da89f863ba06a721ad13e0f1acadfed0152230f9c4f8
		$uriData = $this->GetUriArray();
		$param = GSEncryption::GSGlobalDecrypt($uriData['u']);
		$param = json_decode($param);
		 
		if(IsPostBack){
			$np = $this->input->post("password", true);
			$cp = $this->input->post("cp", true);
			if(!empty($np) && !empty($cp)){
				if($np == $cp){
					$ad->admin_pid($param->user_id);
					$ad->password($np);
					if($ad->Update()){
						//GPrint("Password reset successfull!!");
						$this->AddInfo("Password reset successfull!",true);
						redirect();
					}
				}else{
					$this->AddError("The password and its confirm are not the same");
				}
			}else {
				$this->AddError("New password and confirm password are required.");
			}
		}
		 
		if(!empty($param->time) && $param->time > time()){
			$isExpired = false;
		} else {
			$isExpired = true;
		}
		 
		$pdata['isExpired'] = $isExpired;
		$pdata['msg'] = $message;
		$pdata['title'] = "VT Corporate Cup PM Application";
		$pdata['LoadViews'] = "confirmation";
		$this->GetDefaultConfiguration($pdata);
		$this->load->view("confirmation",$pdata);
	}
	
	function SendForgotPasswordLink($email, $user_id){
		$this->load->library("GSEncryption");
		$this->load->model("gsystem/GSEmail");
		if(!empty($email)){
			//send email
			ob_start();
			$obj=new stdClass();
			$obj->time=strtotime("+15 MINUTES");
			$obj->email_id=$email;
			$obj->user_id = $user_id;
			$str=json_encode($obj);
			$linkparam = GSEncryption::GSGlobalEncrypt($str);
			?>
						<h1>Your password reset request has been received.</h1>
						<p>To confirm your request ,please click the link bellow:<br/>							
							<a href="<?php echo base_url("task/confirmation/u/".$linkparam);?>"><?php echo base_url("task/confirmation/u/".$linkparam);?></a>
						</p>
						<?php 
						$emailtext = ob_get_clean();
						//GPrint($emailtext);die;
						$config['protocol'] = 'sendmail';
						$config['charset'] = 'utf-8';
						$config['wordwrap'] = TRUE;
						$config['mailtype'] = 'html';
					
						$this->email->initialize($config);
						$this->email->from('noreply@vcccsar.org', 'Corporate Cup');
						$this->email->to($email);
						$this->email->subject('VT Corporate Cup PM App');
						$this->email->message($emailtext);
						$mailStatus = $this->email->send();
						if ($mailStatus) {
							return true;
						} else {
							return false;
						}						
					}
		}

	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	function __construct() {
		parent::__construct ();
		//$this->CheckSession(true);
	}
	
	
	public function admin() {	
		redirect("");	
		$this->load->model("database/Madmin");
		
		if($this->CheckSession()) {
			redirect("task/dashboard");die;
		}
		
		$message="";
		
		if(IsPostBack){
			$email = trim($_POST['email']);
			$password = trim($_POST['password']);
			if ($this->Madmin->authenticate($email, $password)) {
				//$message = "SUCCESS";
				redirect("task/dashboard");
			} else {
				$message = "User ID/password combination incorrect.";
			}
		}
		
		$this->load->model("database/Madmin");
		$rData=array();
		$rData['loginObj']=$this->Madmin;
		$rData['title'] = "Admin Login";
		$rData['field'] = "User ID";
		$rData['msg'] = $message;
		$this->GetDefaultConfiguration($rData);
		$this->LoginPanel($rData);		
	}
	
	public function vlogin() {
		redirect("");
		$this->load->model("database/Mvolunteer");
	
		if($this->CheckSession()) {
			redirect("task/vprofile");die;
		}
		//GPrint("Volunteer Successfully Login.");
		//GPrint($this->session->GetVtrData());
		//GPrint("User Type:".$this->session->GetCurrentUserType());
	
		$message="";
	
		if(IsPostBack){
			$email = trim($_POST['email']);
			$password = trim($_POST['password']);
			if ($this->Mvolunteer->authenticate($email, $password)) {
				//$message = "SUCCESS";
				redirect("task/vprofile");
			} else {
				$message = "User ID/password combination incorrect.";
			}
		}
	
		$this->load->model("database/Mvolunteer");
		$rData=array();
		$rData['loginObj']=$this->Mvolunteer;
		$rData['title'] = "Volunteer Login";
		$rData['field'] = "User ID";
		$rData['msg'] = $message;
		$this->GetDefaultConfiguration($rData);
		$this->LoginPanel($rData);
	}
	
	public function vprofile() {
		//$vtr_data = $this->session->GetVtrData();GPrint($vtr_data);
		$this->CheckSession(true);
		$uriData = $this->GetUriArray();
		if(!empty($uriData)){
			$act = $uriData['act'];
		}else{
			$act = 'A';
		}
		if($this->session->GetCurrentUserType()=="AD") die;
		$pdata = array();
		$userData = $this->session->GetVtrData();
		$this->load->model("database/Madmin");
		$this->Madmin->admin_pid($userData->admin_pid);
		if($this->Madmin->Select()){
			$pdata['vtrObj'] = $this->Madmin;
		}
		
		$pdata['title'] = "Corporate Cup | Profile";
		$pdata['sub_title'] = "User Profile";
		$pdata['act'] = $act;
		$pdata['LoadViews'] = "vprofile";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);		
	}
	
	public function aprofile() {
		$this->CheckSession(true);
		//$cc = $this->session->GetAdminData ()->email;
		$uriData = $this->GetUriArray();
		if(!empty($uriData)){
			$act = $uriData['act'];
		}else{
			$act = 'A';
		}
		
		if($this->session->GetCurrentUserType()=="VT") die;
		$pdata = array();
		$userData = $this->session->GetAdminData();
		$this->load->model("database/Madmin");
		$this->Madmin->admin_pid($userData->admin_pid);
		if($this->Madmin->Select()){
			$pdata['adObj'] = $this->Madmin;
		}
	
		$pdata['title'] = "Corporate Cup | Profile";
		$pdata['sub_title'] = "User Profile";
		$pdata['act'] = $act;
		$pdata['LoadViews'] = "aprofile";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);
	}
	
	
	public function CheckSession($autoRedirect=false){
		$utype = $this->session->GetCurrentUserType();
		if($utype=="AD"){
			return true;
		} elseif($utype=="VT") {
			return true;
		}
		else {
			if($autoRedirect) {
					redirect("task/admin");
				}
		}
	}
	
	public function LoginPanel($rData) {
		$this->load->view("login",$rData);
	}
	
	public function test(){
		$a = -3.5;
		$b = 2;
		$c = $a + $b;
		echo $c;
	}
	
	public function logout() {
		$utype = $this->session->GetCurrentUserType();
		$this->session->UnsetAllUserData();
		if($utype == 'AD'){
			redirect("");
		}
		if($utype == 'VT'){
			redirect("");
		}
		
	}
	
	
	public function dashboard(){
		/*GPrint($this->session->GetAdminData ());die;
		(
		[admin_pid] => 1
		[email] => test@gmail.com
		[fname] => Thahir
		[lname] => Basha
		[title] => Engg
		[role] => A
		[LoggedIn] => 1*/
		
		//$userData = $this->session->GetAdminData();GPrint($userData);
		
		
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		$pdata = array();
		$sub_status = array();
		
		$this->load->model("database/Madmin");
		$this->Madmin->status('A');
		$this->Madmin->role('A');
		$activeAdmins = $this->Madmin->CountAll();
		
		$this->Madmin = new Madmin();
		$this->Madmin->status('A');
		$this->Madmin->role('S');
		$activeSu = $this->Madmin->CountAll();
		
		$pdata['activeAdmins'] = $activeAdmins + $activeSu;
		
		$this->Madmin = new Madmin();
		$this->Madmin->status('A');
		$this->Madmin->role('V');
		$activeVtr = $this->Madmin->CountAll();
		$pdata['activeVtr'] = $activeVtr;
		
		$query1 = "SELECT COUNT(subtask_id) AS num_sub, status FROM subtask GROUP BY `status`";
		$records1 = $this->db->query($query1);
		$sub_status = $records1->result();
		$sub_Arr = "";
		
		foreach ($sub_status as $sub){
			$sub_Arr[$sub->status] = $sub->num_sub;
		}
		$pdata['sub_Arr'] = $sub_Arr;
		
		$this->load->model("database/Mtask");
		$this->Mtask->status('P');
		$pending_tasks = $this->Mtask->CountAll();
		$pdata['pending_tasks'] = $pending_tasks;
		
		//$this->load->model("database/Msubtask");
		//$subtask_data = $this->Msubtask->SelectJoinLimit();
		//$pdata['subtask_data'] = $subtask_data;
		
		$this->load->model("database/Mtask");
		$this->Mtask = new Mtask();
		$this->Mtask->status('status != "L" AND task.status != "H"',false);
		$task_data = $this->Mtask->SelectJoin2("","task_id","desc",10);
		$pdata['task_data'] = $task_data;
		
		$pdata['title'] = "Corporate Cup | Dashboard";
		$pdata['sub_title'] = "Dashboard";
		$pdata['LoadViews'] = "dashboard";
		$this->LoadView($pdata);
	}
	
	public function taskList(){
		$pdata = array();
		$pdata['title'] = "User Tasks";
		$pdata['sub_title'] = "";
		$pdata['LoadViews'] = "task";
		$this->LoadView($pdata);
	}
	
	public function admin_users(){
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		
		$uriData = $this->GetUriArray();
		
		$admin_id = $this->session->GetAdminData ()->admin_pid;
		$role = $this->input->post("role", true);
		$pdata = array();
		$pdata['role'] = "";
		$pdata['title'] = "Corporate Cup | Users";
		$pdata['sub_title'] = "Users";
		$this->load->model("database/Madmin");
		
		if(!IsPostBack && empty($uriData['role'])) {
			$this->Madmin->role('A');
		}
		
		if(!IsPostBack && !empty($uriData['role'])) {
			$pdata['role'] = $uriData['role'];
			$this->Madmin->role($uriData['role']);
		}
		
		if(IsPostBack){
			$pdata['role'] = $role;
			$this->Madmin->role($role);
		}
		
		$admin_data = $this->Madmin->SelectAll();
		
		$pdata['delete_url'] = site_url("main/delete_batch");
		$pdata['admin_data'] = $admin_data;
		$pdata['LoadViews'] = "admin_list";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);
		
		
		//$sql = "SELECT * FROM (`admin`) WHERE admin_pid != $admin_id AND role != 'S'";
		//$records = $this->db->query($sql);
		//$pdata['admin_data'] = $records->result();
		//GPrint($this->session->GetAdminData ()->admin_pid);
		//GPrint($this->session->GetAdminData ()->role);
	}
	
	public function add_admin() {
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		$this->load->model("database/Madmin");
	
		if(IsPostBack){
			$email = $this->input->post("email", true);
			$fname = $this->input->post("fname", true);
			$lname = $this->input->post("lname", true);
			$role = $this->input->post("role", true);
			$pass = $this->input->post("password", true);
			if($this->session->GetAdminData ()->role == 'A' && $role != 'V') die;
			$this->Madmin->email($email);
			if(!$this->Madmin->Select() && filter_var($email, FILTER_VALIDATE_EMAIL)){
				$isSuccess = $this->sendMailForUserCreation($email,$fname,$lname,$pass);
				if($this->Madmin->GetFromPostData()){
					if($this->Madmin->Save()){
						$this->AddInfo("Successfully Added",true);
						if($_FILES['file_upload']['error']==0){
							$id=$this->Madmin->GetUpdateDB()->insert_id();
							//$dpath=BASEPATH."../img/instructor/".$id.substr($_FILES['file_upload']['name'], -4);
							//Whatever the image type (jpeg, jpg, gif, png), it always save as table pk id.jpg
							$dpath=BASEPATH."../img/admin/".$id.'.jpg';
							if(file_exists($dpath)){
								unlink($dpath);
							}
							if(copy($_FILES['file_upload']['tmp_name'], $dpath)){
								$this->AddInfo("Image Successfully Uploaded",true);
								redirect("task/admin_users/role/$role");
							}
						}
						redirect("task/admin_users/role/$role");
					}
				}
			} else {
		          $this->AddError("Invalid or duplicate entry of email address !!",true);
		      }
		}
	
		$rData=array();
		$rData['title'] = "Corporate Cup | Add User";
		$rData['sub_title'] = "Add User";
		$rData['adminObj']=$this->Madmin;
		$this->GetDefaultConfiguration($rData);
		$rData['multipath']=true; //This field is needed for photo upload and it sets enctype="multipart/form-data" on form action
		$rData['LoadViews']="admin_form";
		$rData['AutoMsgShow']=false;
		$this->LoadPanel($rData);
	}

	public function admin_details() {
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		$this->load->model("database/Madmin");
		$uriData = $this->GetUriArray();
		$pdata = array();
		$pdata['sub_title'] = "";
		$pdata['title'] = "";
		if(!empty($uriData['id'])){
			$this->Madmin->admin_pid($uriData['id']);
			$this->Madmin->Select();
			$pdata['title'] = "Corporate Cup";
			$pdata['sub_title'] = $this->Madmin->fname . " " . $this->Madmin->lname;
			$pdata['adminObj'] = $this->Madmin;
			$this->GetDefaultConfiguration($pdata);
			$pdata['LoadViews']="admin_details";
			$this->LoadPanel($pdata);
		}
	}
	
	public function edit_admin(){
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		//if($this->session->GetAdminData ()->role != 'S') die;
		$role = $this->session->GetAdminData ()->role;
		$this->load->model("database/Madmin");
		$pdata = array();
		$pdata['title'] = "User Edit";
		$pdata['sub_title'] = "";
		$pdata['isEdit']=false;
		$uriData = $this->GetUriArray();
		$admin_id = $uriData['id'];
		if($this->session->GetAdminData ()->admin_pid == $admin_id) die;
		
		if(!empty($uriData['id'])){
			$pdata['isEdit']=true;
			$this->Madmin=new Madmin();
			$this->Madmin->admin_pid($uriData['id']);
		
			if($this->Madmin->Select()){
				$pdata['adminObj'] = $this->Madmin;
				if($role == 'A' && $this->Madmin->role != 'V') die;
				if($role == 'S' && $this->Madmin->role == 'S') die;
			}else{
				$pdata['isEdit']=false;
				$this->AddError("Invalid ID !!",true);
				redirect("task/admin_users");
			}
		}
	
		if(IsPostBack){
		    $email = $this->input->post("email", true);
		    
		    $sql = "SELECT * FROM (`admin`) WHERE `email` = '$email' AND admin_pid != $admin_id";
		    $records = $this->db->query($sql);
		    
		    if (!$records->num_rows >0 && filter_var($email, FILTER_VALIDATE_EMAIL)){
    			$this->Madmin=new Madmin();
    			if($this->Madmin->GetFromPostData()){
    				$this->Madmin->admin_pid($uriData['id']);
    				$this->Madmin->fname($this->Madmin->fname);
    				$this->Madmin->lname($this->Madmin->lname);
    				$this->Madmin->email($this->Madmin->email);
    				$this->Madmin->title($this->Madmin->title);
    				$this->Madmin->time_zone($this->Madmin->time_zone);
    				$this->Madmin->short_bio($this->Madmin->short_bio);
    				if($this->Madmin->Update()){
    					$this->AddInfo("Successfully Updated",true);
    					//redirect("main/view_inst");
    				}
    				if($_FILES['file_upload']['error']==0){
    					//$id=$this->Minstructor->GetUpdateDB()->insert_id();
    					$dpath=BASEPATH."../img/admin/" . $uriData['id'] . '.jpg';
    					if(file_exists($dpath)){
    						unlink($dpath);
    					}
    					if(copy($_FILES['file_upload']['tmp_name'], $dpath)){
    						$this->AddInfo("Image Successfully Uploaded",true);
    						redirect("task/admin_details/id/".$uriData['id']);
    					}
    					redirect("task/admin_details/id/".$uriData['id']);
    				}
    				redirect("task/admin_details/id/".$uriData['id']);
    			}
		  } else {
		      $this->AddError("Invalid or duplicate entry of email address !!",true);
		  }
	}
	

		
		$this->GetDefaultConfiguration($pdata);
		$pdata['multipath']=true;
		$pdata['LoadViews']="admin_form";
		$pdata['AutoMsgShow']=false;
		$this->LoadPanel($pdata);
	}
	
	public function reset_admin_pass() {
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		$role = $this->session->GetAdminData ()->role;
		
		$pdata = array();
		$pdata['title'] = "Reset Password";
		$pdata['sub_title'] = "";
		$pdata['isEdit']=false;
		$this->load->model("database/Madmin");
		$uriData = $this->GetUriArray();
		$admin_id = $uriData['id'];
		if($this->session->GetAdminData ()->admin_pid == $admin_id) die;
		$pdata['admin_id'] = $admin_id;
		$this->Madmin->admin_pid($admin_id);
		if($this->Madmin->Select()){
			if($role == 'A' && $this->Madmin->role != 'V') die;
			if($role == 'S' && $this->Madmin->role == 'S') die;
			$fname = $this->Madmin->fname;
			$lname = $this->Madmin->lname;
			$pdata['sub_title'] = "Reset Password for ". $fname. " " . $lname;
		} else {
			$this->AddError("Invalid information !!",true);
			redirect("task/admin_users");
		}
		 
		if(IsPostBack){
			$new_pass = $this->input->post("new_password", true);
			$r_pass = $this->input->post("retype_password", true);
			
			if(!empty($new_pass) && !empty($r_pass)){
				$this->Madmin->admin_pid($admin_id);
				if($this->Madmin->Select() && $new_pass == $r_pass){
					$this->Madmin=new Madmin();
					$this->Madmin->admin_pid($admin_id);
					$this->Madmin->password($new_pass);
					if($this->Madmin->Update()){
						$this->AddInfo("Password Successfully Updated",true);
						redirect("task/admin_details/id/$admin_id");
					}
				} else {
					$this->AddError("Password reset failed!");
				}
			}else{
				$this->AddError("Password fields are empty!");
			}
		}
		
		$pdata['isEdit']=true;
		$this->GetDefaultConfiguration($pdata);
		$pdata['LoadViews']="reset_password_form_AD";
		$pdata['AutoMsgShow']=false;
		$this->LoadPanel($pdata);
	}
	
	public function add_volunteer() {
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		$this->load->model("database/Mvolunteer");
	
		if(IsPostBack){
			$email = $this->input->post("email", true);
			$this->Mvolunteer->email($email);
			if(!$this->Mvolunteer->Select() && filter_var($email, FILTER_VALIDATE_EMAIL)){
				if($this->Mvolunteer->GetFromPostData()){
					if($this->Mvolunteer->Save()){
						$this->AddInfo("Successfully Added",true);
						if($_FILES['file_upload']['error']==0){
							$id=$this->Mvolunteer->GetUpdateDB()->insert_id();
							$dpath=BASEPATH."../img/volunteer/".$id.'.jpg';
							if(file_exists($dpath)){
								unlink($dpath);
							}
							if(copy($_FILES['file_upload']['tmp_name'], $dpath)){
								$this->AddInfo("Image Successfully Uploaded",true);
								redirect("task/volunteer_list");
							}
						}
						redirect("task/volunteer_list");
					}
				}
			} else {
				$this->AddError("Invalid or duplicate entry of email address !!",true);
			}
		}
	
		$rData=array();
		$rData['title'] = "Corporate Cup | Add Volunteer";
		$rData['sub_title'] = "Add Volunteer";
		$rData['vtrObj']=$this->Mvolunteer;
		$this->GetDefaultConfiguration($rData);
		$rData['multipath']=true; 
		$rData['LoadViews']="vtr_form";
		$rData['AutoMsgShow']=false;
		$this->LoadPanel($rData);
	}
	
	public function volunteer_list(){
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		$pdata = array();
		$pdata['title'] = "Corporate Cup | Volunteers";
		$pdata['sub_title'] = "Volunteers";
		$this->load->model("database/Mvolunteer");
	
		$vtr_data = $this->Mvolunteer->SelectAll();
		$pdata['delete_url'] = site_url("main/delete_batch");
		$pdata['vtr_data'] = $vtr_data;
		$pdata['LoadViews'] = "volunteer_list";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadPanel($pdata);
	}
	
	public function volunteer_details() {
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		$this->load->model("database/Mvolunteer");
		$uriData = $this->GetUriArray();
		$pdata = array();
		$pdata['sub_title'] = "";
		if(!empty($uriData['id'])){
			$this->Mvolunteer->v_pid($uriData['id']);
			$this->Mvolunteer->Select();
			$pdata['title'] = "Corporate Cup";
			$pdata['sub_title'] = $this->Mvolunteer->fname . " " . $this->Mvolunteer->lname;
			$pdata['vtrObj'] = $this->Mvolunteer;
			$this->GetDefaultConfiguration($pdata);
			$pdata['LoadViews']="vtr_details";
			$this->LoadPanel($pdata);
		}
	}
	
	public function edit_volunteer(){
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		$this->load->model("database/Mvolunteer");
		$pdata = array();
		$pdata['title'] = "Volunteer Edit";
		$pdata['sub_title'] = "";
		$pdata['isEdit']=false;
		$uriData = $this->GetUriArray();
		$vtr_id = $uriData['id'];
	
		if(IsPostBack){
			$email = $this->input->post("email", true);
			$sql = "SELECT * FROM (`volunteer`) WHERE `email` = '$email' AND v_pid != $vtr_id";
			$records = $this->db->query($sql);
	
			if (!$records->num_rows >0 && filter_var($email, FILTER_VALIDATE_EMAIL)){
				$this->Mvolunteer=new Mvolunteer();
				if($this->Mvolunteer->GetFromPostData()){
					$this->Mvolunteer->v_pid($uriData['id']);
					$this->Mvolunteer->fname($this->Mvolunteer->fname);
					$this->Mvolunteer->lname($this->Mvolunteer->lname);
					$this->Mvolunteer->email($this->Mvolunteer->email);
					$this->Mvolunteer->title($this->Mvolunteer->title);
					$this->Mvolunteer->time_zone($this->Mvolunteer->time_zone);
					$this->Mvolunteer->short_bio($this->Mvolunteer->short_bio);
					if($this->Mvolunteer->Update()){
						$this->AddInfo("Successfully Updated",true);
					}
					if($_FILES['file_upload']['error']==0){
						$dpath=BASEPATH."../img/volunteer/" . $uriData['id'] . '.jpg';
						if(file_exists($dpath)){
							unlink($dpath);
						}
						if(copy($_FILES['file_upload']['tmp_name'], $dpath)){
							$this->AddInfo("Image Successfully Uploaded",true);
							redirect("task/volunteer_details/id/".$uriData['id']);
						}
						redirect("task/volunteer_details/id/".$uriData['id']);
					}
					redirect("task/volunteer_details/id/".$uriData['id']);
				}
			} else {
				$this->AddError("Invalid or duplicate entry of email address !!",true);
			}
		}
	
		if(!empty($uriData['id'])){
			$pdata['isEdit']=true;
			$this->Mvolunteer=new Mvolunteer();
			$this->Mvolunteer->v_pid($uriData['id']);
	
			if($this->Mvolunteer->Select()){
				$pdata['vtrObj'] = $this->Mvolunteer;
			}else{
				$pdata['isEdit']=false;
			}
		}
	
		$this->GetDefaultConfiguration($pdata);
		$pdata['multipath']=true;
		$pdata['LoadViews']="vtr_form";
		$pdata['AutoMsgShow']=false;
		$this->LoadPanel($pdata);
	}
	
	public function edit_vprofile(){
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="AD") die;
		$vtr_data = $this->session->GetVtrData();
		$vtr_id = $vtr_data->admin_pid;
		$email = $this->input->post("email", true);
		$short_bio = $this->input->post("short_bio", true);
		$this->load->model("database/Madmin");
		
		$isEmail = filter_var($email, FILTER_VALIDATE_EMAIL);
		if(!$isEmail){
			redirect("task/vprofile/act/E");die;
		} 
		
		$sql = "SELECT * FROM (`admin`) WHERE `email` = '$email' AND admin_pid != $vtr_id";
		$records = $this->db->query($sql);
		
		if(!$records->num_rows >0){
			$this->Madmin=new Madmin();
			$this->Madmin->admin_pid($vtr_id);
			$this->Madmin->email($email);
			$this->Madmin->short_bio($short_bio);
			if($this->Madmin->Update()){
				$this->AddInfo("Successfully Updated",true);
			} else {
				$this->AddInfo("No change has found to update !!",true);
			}
			if($_FILES['file_upload']['error']==0){
				$dpath=BASEPATH."../img/admin/" . $vtr_id . '.jpg';
				if(file_exists($dpath)){
					unlink($dpath);
				}
				if(copy($_FILES['file_upload']['tmp_name'], $dpath)){
					$this->AddInfo("Image Successfully Uploaded",true);
				}
			}
			redirect("task/vprofile/act/E");
		} else {
			$this->AddError("Duplicate entry of email address !!",true);
			redirect("task/vprofile/act/E");
		}
	}
	
	public function edit_aprofile(){
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		$ad_data = $this->session->GetAdminData();
		$ad_id = $ad_data->admin_pid;
		$email = $this->input->post("email", true);
		$short_bio = $this->input->post("short_bio", true);
		$this->load->model("database/Madmin");
	
		$isEmail = filter_var($email, FILTER_VALIDATE_EMAIL);
		if(!$isEmail){
			$this->AddError("Invalid email address !!",true);
			redirect("task/aprofile/act/E");die;
		}
	
		$sql = "SELECT * FROM (`admin`) WHERE `email` = '$email' AND admin_pid != $ad_id";
		$records = $this->db->query($sql);
	
		if(!$records->num_rows >0){
			$this->Madmin=new Madmin();
			$this->Madmin->admin_pid($ad_id);
			$this->Madmin->email($email);
			$this->Madmin->short_bio($short_bio);
			if($this->Madmin->Update()){
				$this->AddInfo("Successfully Updated",true);
			} else {
				$this->AddInfo("No change has found to update !!",true);
			}
			if($_FILES['file_upload']['error']==0){
				$dpath=BASEPATH."../img/admin/" . $ad_id . '.jpg';
				if(file_exists($dpath)){
					unlink($dpath);
				}
				if(copy($_FILES['file_upload']['tmp_name'], $dpath)){
					$this->AddInfo("Image Successfully Uploaded",true);
				}
			}
			redirect("task/aprofile/act/E");
		} else {
			$this->AddError("Duplicate entry of email address !!",true);
			redirect("task/aprofile/act/E");
		}
	}
	
	public function vtask() {
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="AD") die;
		$vtr_data = $this->session->GetVtrData();
		$vtr_id = $vtr_data->admin_pid;
		$uriData = $this->GetUriArray();
		$pdata = array();
		$pdata['title'] = "Task List";
		$pdata['sub_title'] = "Task List";
		
		$this->load->model("database/Msubtask");
		$this->Msubtask->done_vtr($vtr_id);
		$subtask_data2 = $this->Msubtask->SelectJoinForVtr();
		$pdata['subtask_data2'] = $subtask_data2;
		
		
		if(!IsPostBack && empty($uriData['id'])) {
		}
		
		if(!IsPostBack && !empty($uriData['id'])) {
			$pdata['search_value'] = $uriData['id'];
			$this->Msubtask->task_id($uriData['id']);
		}
		
		if(IsPostBack){
			$searchByTask = trim($_POST['task_id']);
			$pdata['search_value'] = $searchByTask;
			if($searchByTask !== 'all'){
				$this->Msubtask->task_id($searchByTask);
			}
		}
		
		$subtask_data = $this->Msubtask->SelectJoinForVtr();
		$pdata['delete_url'] = site_url("main/delete_batch");
		$pdata['subtask_data'] = $subtask_data;
		$pdata['LoadViews'] = "vtask_list";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);		
	}
	
	public function change_password_VT() {
		if($this->session->GetCurrentUserType()!=="VT") die;
		$this->CheckSession(true);
		$this->load->model("database/Madmin");
		$vtr_data = $this->session->GetVtrData();
		$vtr_id = $vtr_data->admin_pid;
		 
		$old_pass = $this->input->post("old_password", true);
		$new_pass = $this->input->post("new_password", true);
		$r_pass = $this->input->post("retype_password", true);

		if(!empty($old_pass)&&!empty($new_pass)&&!empty($r_pass)){
			$this->Madmin->admin_pid($vtr_id);
			$this->Madmin->password(md5($old_pass));
			if($this->Madmin->Select()){
				if($new_pass == $r_pass){
					$this->Madmin=new Madmin();
					$this->Madmin->admin_pid($vtr_id);
					$this->Madmin->password($new_pass);
					if($this->Madmin->Update()){
						$this->AddInfo("Password Successfully Updated",true);
						redirect("task/vprofile");
					}
				} else {
					$this->AddError("New password and retype password not match",true);
					redirect("task/vprofile/act/C");
				}
			}else {
					$this->AddError("Old Password not match",true);
					redirect("task/vprofile/act/C");
				}
		} else {
			$this->AddError("Password should not be empty.",true);
			redirect("task/vprofile/act/C");
		}	

	}
	
	public function change_password_AD() {
		if($this->session->GetCurrentUserType() == "VT") die;
		$this->CheckSession(true);
		$this->load->model("database/Madmin");
		$ad_data = $this->session->GetAdminData();
		$ad_id = $ad_data->admin_pid;
			
		$old_pass = $this->input->post("old_password", true);
		$new_pass = $this->input->post("new_password", true);
		$r_pass = $this->input->post("retype_password", true);
	
		$this->Madmin->admin_pid($ad_id);
		$this->Madmin->password(md5($old_pass));
		if(!empty($old_pass)&&!empty($new_pass)&&!empty($r_pass)){
			if($this->Madmin->Select()){
				if($new_pass == $r_pass){
					$this->Madmin=new Madmin();
					$this->Madmin->admin_pid($ad_id);
					$this->Madmin->password($new_pass);
					if($this->Madmin->Update()){
						$this->AddInfo("Password Successfully Updated",true);
						redirect("task/aprofile");
					}
				} else {
					$this->AddError("New password and retype password not match",true);
					redirect("task/aprofile/act/C");
				}
			}else {
				$this->AddError("Old password not match",true);
				redirect("task/aprofile/act/C");
			}
		}else {
				$this->AddError("Password should not be empty.",true);
				redirect("task/aprofile/act/C");
			}

	}
	
	public function tasks(){
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		$pdata = array();
		$tot_arr = array();
		$done_arr = array();
		$pdata['title'] = "Task List";
		$pdata['sub_title'] = "Task List";
		$this->load->model("database/Mtask");
		$this->Mtask->status('P');
		$task_data = $this->Mtask->SelectJoin();
		
		$this->load->model("database/Msubtask");
		
		$query1 = "SELECT COUNT(subtask_id) as tot_sub, task_id FROM subtask GROUP BY task_id";
		$query2 = "SELECT COUNT(subtask_id) as done_sub, task_id FROM subtask WHERE `status`='D' GROUP BY task_id";
		
		$records1 = $this->db->query($query1);
		$total_sub = $records1->result();
		
		$records2 = $this->db->query($query2);
		$done_sub = $records2->result();
		
		foreach ($done_sub as $done){
			$done_arr[$done->task_id] = $done->done_sub;
		}
		
		foreach ($total_sub as $total){
			$obj = new stdClass();
			$obj->total = $total->tot_sub;
			$obj->done = array_key_exists($total->task_id, $done_arr)?$done_arr[$total->task_id]:0;
			$tot_arr[$total->task_id] = $obj;
		}
	
		//$pdata['delete_url'] = site_url("main/delete_batch");
		$pdata['action_url'] = site_url("task/archiveData");
		$pdata['task_data'] = $task_data;
		$pdata['status_data'] = $tot_arr;
		$pdata['LoadViews'] = "task_list";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadPanel($pdata);
	}
	
	public function todos() {
		$this->CheckSession(true);
		//mysql_connect('localhost', 'vcccsar_taskmgr', 'taskmgr');
		$con = mysqli_connect("localhost","root","","vcccsar_taskmgr");
		$pdata = array();
		$uriData = $this->GetUriArray();
		$propertyOption = array('priority','assigned','creator','creation_date','due_date','tasktitle','progress');
		$priority_search_option = array('L','M','H','N');
		$property = '';
		$search = '';
		$pdata['search'] = $search;
		$pdata['search2'] = "";
		$search2 = '';
		$redirect_url = "";
		$this->load->model("database/Madmin");
		$this->Madmin->role('role != "V"',false);
		$admin_data = $this->Madmin->SelectAll('admin_pid,fname,lname');
		
		$this->Madmin = new Madmin();
		$this->Madmin->role('V');
		$vtr_data = $this->Madmin->SelectAll('admin_pid,fname,lname');
		
		$orderBy = 'task_id';
		$order = 'desc';
		
		$this->load->model("database/Mtask");
		$uType = $this->session->GetCurrentUserType();
		$this->Mtask->status('status != "L" AND task.status != "H"',false);
		//$this->Mtask->title('title LIKE  "%this%"',false);
		
		if(!IsPostBack && !empty($uriData)) {
			foreach ($uriData as $key=>$value){
				$property = $key;
				$search = $value;
				break;
			}
			//GPrint($search);
			$pdata['search'] = $search;
			$pdata['search2'] = urldecode($search);
			if($property == 'tasktitle'){
				$search = urldecode($search);
				//$search = mysql_real_escape_string($search);
				$search = mysqli_real_escape_string($con, $search);
			}
			if(!empty($property) && !empty($search)){
				if(in_array($property, $propertyOption)){
					if($property == 'priority'){
						if(in_array($search, $priority_search_option)){
							$this->Mtask->priority($search);
							$redirect_data = array('task','todos', $property, $search);
							$redirect_url = site_url($redirect_data);
						} else {
							redirect('task/todos');
						}
					}elseif($property == 'assigned'){
						$this->Mtask->vtr_id($search);
						$redirect_data = array('task','todos', $property, $search);
						$redirect_url = site_url($redirect_data);
					}elseif($property == 'creator'){
						$this->Mtask->admin_id($search);
						$redirect_data = array('task','todos', $property, $search);
						$redirect_url = site_url($redirect_data);
					}elseif($property == 'tasktitle'){
						$this->Mtask->title("title LIKE  '%$search%'",false);
						$search = urlencode($search);
						$redirect_data = array('task','todos', $property, $search);
						$redirect_url = site_url($redirect_data);
					}elseif($property == 'creation_date'){
						$orderBy = 'creation_date';
						$search == 'D'?$order = 'desc':$order = 'asc';
						$redirect_data = array('task','todos', $property, $search);
						$redirect_url = site_url($redirect_data);
					}elseif($property == 'due_date'){
						$orderBy = 'due_date';
						$search == 'D'?$order = 'desc':$order = 'asc';
						$redirect_data = array('task','todos', $property, $search);
						$redirect_url = site_url($redirect_data);
					}elseif($property == 'progress'){
						//Not required any WHERE condition. It is done in view page with foreach continue statement
					}
				}else{
					redirect('task/todos');
				}
			}else{
				redirect('task/todos');
			}
			
		}
		//die;
		if(IsPostBack){
			$property = $this->input->post("property", true);
			$search = $this->input->post("search", true);
			if($property == 'tasktitle'){
				$pdata['search2'] = $search;
				$pdata['search'] = urlencode($search);
			} else {
				$pdata['search'] = $search;
			}
			
			
			if($property == 'tasktitle'){
				//$search = mysql_real_escape_string($search);
				$search = mysqli_real_escape_string($con, $search);
			}
			if(!empty($property) && !empty($search)){
				$redirect_data = array('task','todos', $property, $search);
				$redirect_url = site_url($redirect_data);
				if($property == 'priority'){
					$this->Mtask->priority($search);
				}elseif($property == 'assigned'){
					$this->Mtask->vtr_id($search);
				}elseif($property == 'creator'){
					$this->Mtask->admin_id($search);
				}elseif($property == 'creation_date'){
					$orderBy = 'creation_date';
					$search == 'D'?$order = 'desc':$order = 'asc';
				}elseif($property == 'due_date'){
					$orderBy = 'due_date';
					$search == 'D'?$order = 'desc':$order = 'asc';
				}elseif($property == 'tasktitle'){
					$this->Mtask->title("title LIKE  '%$search%'",false);
				}elseif($property == 'progress'){
					////Not required any WHERE condition. It is done in view page with foreach continue statement
				}
				
			}
		}		
		//SelectJoin2($QueryString = "", $orderBy = 'task_id', $order = 'desc', $limit = 0, $limitStart = 0)
		$task_data = $this->Mtask->SelectJoin2("", $orderBy, $order);
		
		$this->load->model("database/Msubtask");
		
		$this->Msubtask->status('status != "L" AND subtask.status != "H"',false);
		if($uType == 'VT'){
			$user_id = $this->session->GetVtrData()->admin_pid;
			if(!empty($user_id)){
				$this->Msubtask->done_vtr($user_id);
			}else{
				redirect("task/vprofile");
			}
		}		
		$subtask_data = $this->Msubtask->SelectJoin2();
		
		//GPrint($task_data);
		
		$tot_arr = array();
		$done_arr = array();
		$subtaskArr = array();
		$attArr = array();
		$comArr = array();
		
		
		$query1 = "SELECT COUNT(subtask_id) as tot_sub, task_id FROM subtask GROUP BY task_id";
		$query2 = "SELECT COUNT(subtask_id) as done_sub, task_id FROM subtask WHERE `status`='D' GROUP BY task_id";
		$query3 = "SELECT COUNT(id) as tot_att, task_id FROM attachment WHERE `status`='A' GROUP BY task_id";
		$query4 = "SELECT COUNT(c_id) as tot_com, task_id FROM task_comments WHERE `status`='A' GROUP BY task_id";
		
		$records1 = $this->db->query($query1);
		$total_sub = $records1->result();
		
		$records2 = $this->db->query($query2);
		$done_sub = $records2->result();
		
		$records3 = $this->db->query($query3);
		$att_count = $records3->result();
		
		$records4 = $this->db->query($query4);
		$com_count = $records4->result();
		
		foreach ($done_sub as $done){
			$done_arr[$done->task_id] = $done->done_sub;
		}
		
		foreach ($total_sub as $total){
			$obj = new stdClass();
			$obj->total = $total->tot_sub;
			$obj->done = array_key_exists($total->task_id, $done_arr)?$done_arr[$total->task_id]:0;
			$tot_arr[$total->task_id] = $obj;
		}
		
		foreach ($att_count as $att){
			$attArr[$att->task_id] = $att->tot_att;
		}
		
		foreach ($com_count as $com){
			$comArr[$com->task_id] = $com->tot_com;
		}
		
		foreach ($subtask_data as $subObj){
			$obj2 = new stdClass();
			$obj2->subtask_id = $subObj->subtask_id;
			$obj2->task_id = $subObj->task_id;
			$obj2->subtitle = $subObj->subtitle;
			$obj2->done_vtr = $subObj->done_vtr;
			$obj2->status = $subObj->status;
			$obj2->completion_date = $subObj->completion_date;
			$obj2->vtr_fname = $subObj->vtr_fname;
			$obj2->vtr_lname = $subObj->vtr_lname;
			if(isset($subtaskArr[$subObj->task_id][$subObj->subtask_id])) {
				$subtaskArr[$subObj->task_id][$subObj->subtask_id] += $obj2;
			} else {
				$subtaskArr[$subObj->task_id][$subObj->subtask_id] = $obj2;
			}
		}
		$pdata['redirect_url'] = $redirect_url;
		$pdata['property'] = $property;
		$pdata['admin_data'] = $admin_data;
		$pdata['vtr_data'] = $vtr_data;
		$pdata['task_data'] = $task_data;
		$pdata['status_data'] = $tot_arr;
		$pdata['subtask_data'] = $subtaskArr;
		$pdata['attArr'] = $attArr;
		$pdata['comArr'] = $comArr;
		$pdata['title'] = "Task List";
		$backLink = base_url()."task/todos";
		$pdata['sub_title'] = "<a href='$backLink'><i class='fa fa-refresh text-info'></i> </a> Task List";
		
		$pdata['action_url'] = site_url("main/add_todos");
		$pdata['LoadViews'] = "todos";
		$this->Mtask = new Mtask();
		$pdata['taskObj']=$this->Mtask;
		//$this->Msubtask = new Msubtask();
		$pdata['subObj']=$this->Msubtask;
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);
	}
	
	public function calendar(){
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		$uriData = $this->GetUriArray();
		$this->load->model("database/Mtask");
		
		//$currentDate = date("Y-m-d");
		if(empty($uriData['date'])){
			$currentDate = date("Y-m-d");
		}else{
			$currentDate = $uriData['date'];
		}
		$pdata = array();
		$pdata['title'] = "Calender";
		$pdata['action_url'] = site_url("task/calendar");
		$pdata['sub_title'] = "";
		$pdata['currentDate'] = $currentDate;
		$pdata['taskObj']=$this->Mtask;
		$pdata['LoadViews'] = "calendar";
		$this->LoadView($pdata);
	}
	
	public function calendar_vtr(){
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="AD") die;
		$uriData = $this->GetUriArray();
		$this->load->model("database/Mtask");
	
		//$currentDate = date("Y-m-d");
		if(empty($uriData['date'])){
			$currentDate = date("Y-m-d");
		}else{
			$currentDate = $uriData['date'];
		}
		$pdata = array();
		$pdata['title'] = "Calender";
		$pdata['action_url'] = site_url("task/calendar");
		$pdata['sub_title'] = "";
		$pdata['currentDate'] = $currentDate;
		$pdata['taskObj']=$this->Mtask;
		$pdata['LoadViews'] = "calendar_vtr";
		$this->LoadView($pdata);
	}
	
	public function todos_vtr() {
		//for testing purpose
		$this->CheckSession(true);
		$this->load->model("database/Mtask");
		$uType = $this->session->GetCurrentUserType();

		$this->Mtask->status('status != "L"',false);
		$task_data = $this->Mtask->SelectJoin2();
	
		$this->load->model("database/Msubtask");
		if($uType == 'VT'){
			$user_id = $this->session->GetVtrData()->admin_pid;
			if(!empty($user_id)){
				$this->Msubtask->done_vtr($user_id);
			}else{
				redirect("task/vprofile");
			}
		}
		$this->Msubtask->status('status != "L"',false);
		$subtask_data = $this->Msubtask->SelectJoin2();
	
		//GPrint($task_data);
		$pdata = array();
		$tot_arr = array();
		$done_arr = array();
		$subtaskArr = array();
		$attArr = array();
		$comArr = array();
	
	
		$query1 = "SELECT COUNT(subtask_id) as tot_sub, task_id FROM subtask GROUP BY task_id";
		$query2 = "SELECT COUNT(subtask_id) as done_sub, task_id FROM subtask WHERE `status`='D' GROUP BY task_id";
		$query3 = "SELECT COUNT(id) as tot_att, task_id FROM attachment WHERE `status`='A' GROUP BY task_id";
		$query4 = "SELECT COUNT(c_id) as tot_com, task_id FROM task_comments WHERE `status`='A' GROUP BY task_id";
	
		$records1 = $this->db->query($query1);
		$total_sub = $records1->result();
	
		$records2 = $this->db->query($query2);
		$done_sub = $records2->result();
	
		$records3 = $this->db->query($query3);
		$att_count = $records3->result();
	
		$records4 = $this->db->query($query4);
		$com_count = $records4->result();
	
		foreach ($done_sub as $done){
			$done_arr[$done->task_id] = $done->done_sub;
		}
	
		foreach ($total_sub as $total){
			$obj = new stdClass();
			$obj->total = $total->tot_sub;
			$obj->done = array_key_exists($total->task_id, $done_arr)?$done_arr[$total->task_id]:0;
			$tot_arr[$total->task_id] = $obj;
		}
	
		foreach ($att_count as $att){
			$attArr[$att->task_id] = $att->tot_att;
		}
	
		foreach ($com_count as $com){
			$comArr[$com->task_id] = $com->tot_com;
		}
	
		/*
			[subtask_id] => 8
		[task_id] => 1
		[subtitle] => efredgt
		[done_vtr] => 6
		[status] => P
		[completion_date] => 2016-01-22 00:00:00
		[vtr_fname] => Sanju
		[vtr_lname] => Alam*/
	
		foreach ($subtask_data as $subObj){
			$obj2 = new stdClass();
			$obj2->subtask_id = $subObj->subtask_id;
			$obj2->task_id = $subObj->task_id;
			$obj2->subtitle = $subObj->subtitle;
			$obj2->done_vtr = $subObj->done_vtr;
			$obj2->status = $subObj->status;
			$obj2->completion_date = $subObj->completion_date;
			$obj2->vtr_fname = $subObj->vtr_fname;
			$obj2->vtr_lname = $subObj->vtr_lname;
			if(isset($subtaskArr[$subObj->task_id][$subObj->subtask_id])) {
				$subtaskArr[$subObj->task_id][$subObj->subtask_id] += $obj2;
			} else {
				$subtaskArr[$subObj->task_id][$subObj->subtask_id] = $obj2;
			}
		}
	
		/*[task_id] => 6
			[title] => excel
		[description] =>
		[due_date] => 2016-01-18
		[completion_date] =>
		[admin_id] => 1
		[vtr_id] => 3
		[creation_date] => 2016-01-28 02:11:36
		[priority] => M
		[status] => P
		[ad_fname] => Milon
		[ad_lname] => Islam
		[vtr_fname] => Arifin2
		[vtr_lname] => Jubaed*/
	
		$pdata['task_data'] = $task_data;
		$pdata['status_data'] = $tot_arr;
		$pdata['subtask_data'] = $subtaskArr;
		$pdata['attArr'] = $attArr;
		$pdata['comArr'] = $comArr;
	
	
	
		$pdata['task_data'] = $task_data;
		$pdata['title'] = "Task List";
		$pdata['sub_title'] = "Task List";
		$pdata['action_url'] = site_url("main/add_todos");
		$pdata['LoadViews'] = "todos";
		$pdata['taskObj']=$this->Mtask;
		//$this->Msubtask = new Msubtask();
		$pdata['subObj']=$this->Msubtask;
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);
	}
	
	
	public function todos_details(){
		$this->CheckSession(true);
		$uType = $this->session->GetCurrentUserType();
		$pdata = array();
		$task_data = array();
		$subtask_data = array();
		$comments_data = array();
		$attachment_data = array();
		$direct = false;
		
		$uriData = $this->GetUriArray();
		$task_id = $uriData['id'];
		
		$this->load->model("database/Mtask");
		$this->load->model("database/Msubtask");
		$this->load->model("database/Mtask_comments");
		$this->load->model("database/Mattachment");
		
		
		
		if (isset($task_id) && !empty($task_id)) {
			$this->Mtask->task_id($task_id);
			$task_data = $this->Mtask->SelectJoin2();
			
			$this->Msubtask->task_id($task_id);
			if($uType == 'VT'){
				$user_id = $this->session->GetVtrData()->admin_pid;
				if(!empty($user_id)){
					$this->Msubtask->done_vtr($user_id);
				}else{
					//redirect("task/vprofile");
				}
				if($task_data[0]->vtr_id != $user_id){
					$direct = true;
				}
				
			}
			$subtask_data = $this->Msubtask->SelectJoin2();
			
			if($uType == 'VT'){
				if(count($subtask_data)<1 && $direct){
					redirect("task/vprofile");
				}
			}
			
			$this->Mtask_comments->task_id($task_id);
			$comments_data = $this->Mtask_comments->SelectJoin();
			
			$this->Mattachment->task_id($task_id);
			$attachment_data = $this->Mattachment->SelectAll();
			
		}
		$backLink = base_url()."task/todos";
		$pdata['task_data'] = $task_data;
		$pdata['subtask_data'] = $subtask_data;
		$pdata['comments_data'] = $comments_data;
		$pdata['attachment_data'] = $attachment_data;
		
		$pdata['title'] = "Task Details";
		$pdata['sub_title'] = "<a href='$backLink'><i class='fa fa-arrow-circle-left'></i> </a> Task Details";
		$pdata['LoadViews'] = "todos_details";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);
	}
	
	public function todos_details_archive(){
		$this->CheckSession(true);
		$uType = $this->session->GetCurrentUserType();
		$pdata = array();
		$task_data = array();
		$subtask_data = array();
		$comments_data = array();
		$attachment_data = array();
		$direct = false;
	
		$uriData = $this->GetUriArray();
		$task_id = $uriData['id'];
	
		$this->load->model("database/Mtask");
		$this->load->model("database/Msubtask");
		$this->load->model("database/Mtask_comments");
		$this->load->model("database/Mattachment");
	
	
	
		if (isset($task_id) && !empty($task_id)) {
			$this->Mtask->task_id($task_id);
			$task_data = $this->Mtask->SelectJoin2();
				
			$this->Msubtask->task_id($task_id);
			if($uType == 'VT'){
				$user_id = $this->session->GetVtrData()->admin_pid;
				if(!empty($user_id)){
					$this->Msubtask->done_vtr($user_id);
				}else{
					//redirect("task/vprofile");
				}
				if($task_data[0]->vtr_id != $user_id){
					$direct = true;
				}
	
			}
			$subtask_data = $this->Msubtask->SelectJoin2();
				
			if($uType == 'VT'){
				if(count($subtask_data)<1 && $direct){
					redirect("task/vprofile");
				}
			}
				
			$this->Mtask_comments->task_id($task_id);
			$comments_data = $this->Mtask_comments->SelectJoin();
				
			$this->Mattachment->task_id($task_id);
			$attachment_data = $this->Mattachment->SelectAll();
				
		}
		$backLink = base_url()."task/archive_subtasks";
		$pdata['task_data'] = $task_data;
		$pdata['subtask_data'] = $subtask_data;
		$pdata['comments_data'] = $comments_data;
		$pdata['attachment_data'] = $attachment_data;
	
		$pdata['title'] = "Task Details";
		$pdata['sub_title'] = "<a href='$backLink'><i class='fa fa-arrow-circle-left'></i> </a> Task Details";
		$pdata['LoadViews'] = "todos_details_archive";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);
	}
	

	
	public function add_comments(){
		$this->CheckSession(true);
		$this->load->model("database/Mtask_comments");
		$uType = $this->session->GetCurrentUserType();
		$user_id = "";
		$task_id = $this->input->post("task_id", true);
		$description = $this->input->post("description", true);
		if(empty($description)){
			redirect("task/todos_details/id/$task_id");
		}
		
		if($uType == 'AD'){
			$user_id = $this->session->GetAdminData()->admin_pid;
		}
		if($uType == 'VT'){
			$user_id = $this->session->GetVtrData()->admin_pid;
		}
		if(IsPostBack && !empty($user_id) && !empty($task_id)){
			if($this->Mtask_comments->GetFromPostData()){
				$this->Mtask_comments->user_id($user_id);
				if($this->Mtask_comments->Save()){
					//$this->AddInfo("Successfully Added",true);
					redirect("task/todos_details/id/$task_id");
				}
			}
		} else {
			redirect("task/todos");
		}
		
	}
	
	public function changeTaskStatus(){
		if($this->session->GetCurrentUserType()=="VT") die;
		$uriData = $this->GetUriArray();
		$property = "";
		$search = "";
		foreach ($uriData as $key=>$value){
			$property = $key;
			$search = $value;
		}
		$currentDateTime = date("Y-m-d H:i:s");
		$task_id = $uriData['id'];
		$this->load->model("database/Mtask");
		if (isset($task_id) && !empty($task_id)) {
			$this->Mtask->task_id($task_id);
			if($this->Mtask->Select()){
				$status = $this->Mtask->status;
				if($status == 'L'){
					redirect("task/todos/$property/$search");
				} else {
					$status = $status=='P'?'D':'P';
					$this->Mtask=new Mtask();
					$this->Mtask->task_id($task_id);
					$this->Mtask->status($status);
					$this->Mtask->completion_date($currentDateTime);
					if($this->Mtask->Update()){
						if($status == 'D'){
							$query = "UPDATE subtask SET status = 'D', completion_date = now()
										WHERE task_id = $task_id AND status = 'P'";
							$result = $this->db->query($query);
						}
						redirect("task/todos/$property/$search");
					}
					redirect("task/todos/$property/$search");
				}
			} else {
				redirect("task/todos/$property/$search");
			}
		}else{
			redirect("task/todos/$property/$search");
		}
	}
	
	public function changeSubtaskStatus(){
		//if($this->session->GetCurrentUserType()=="VT") die;
		$uriData = $this->GetUriArray();
		$property = "";
		$search = "";
		foreach ($uriData as $key=>$value){
			$property = $key;
			$search = $value;
		}
		$subtask_id = $uriData['subid'];
		$task_id = $uriData['taskid'];
		$currentDateTime = date("Y-m-d H:i:s");
		$this->load->model("database/Msubtask");
		if (isset($subtask_id) && !empty($subtask_id) && isset($task_id) && !empty($task_id)) {
			$this->Msubtask->subtask_id($subtask_id);
			if($this->Msubtask->Select()){
				$status = $this->Msubtask->status;
				$selected_task_id = $this->Msubtask->task_id;
				if($task_id != $selected_task_id){
					redirect("task/todos/$property/$search");die;
				}
				if($status == 'L'){
					redirect("task/todos/$property/$search");die;
				} else {
					$status = $status=='P'?'D':'P';
					$this->Msubtask=new Msubtask();
					$this->Msubtask->subtask_id($subtask_id);
					$this->Msubtask->status($status);
					$this->Msubtask->completion_date($currentDateTime);
					if($this->Msubtask->Update()){
						if($status == 'P'){
							$query = "UPDATE task SET status = 'P' 
							WHERE task_id = $task_id LIMIT 1";
							$result = $this->db->query($query);
						}
						redirect("task/todos/$property/$search");
					}
					redirect("task/todos/$property/$search");
				}
			} else {
				redirect("task/todos/$property/$search");
			}
		}else{
			redirect("task/todos/$property/$search");
		}
	}
	
	public function download(){
		$this->CheckSession(true);
		$uriData = $this->GetUriArray();
		$id = $uriData['id'];
		$this->load->model("database/Mattachment");
		if(!empty($id)){
			$this->Mattachment->id($id);
			if($this->Mattachment->Select()){
				$original_name = $this->Mattachment->original_file_name;
				$file_name = $this->Mattachment->file_name;
				$headers = get_headers(base_url()."attachment/".$file_name);
				$response_code = substr($headers[0], 9, 3);
				if( $response_code == "200"){
					$this->load->helper('download');
					$data = file_get_contents("./attachment/".$file_name);
					force_download($original_name, $data);
				}
			}
		}
	}
	

	
	public function archiveData() {
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
			
		$pdata = array();
		$pdata['errType'] = "";
		$pdata['errMsg'] = "";
		$pdata['title'] = "Pending Requests";
		$pdata['sub_title'] = "";
		$uriData = $this->GetUriArray();
	
		if (isset($uriData['table_pk']) && !empty($uriData['table_pk'])) {
			$task_pid = $uriData['table_pk'];
	
			$query = "UPDATE task SET status = 'D'
			WHERE task_id = $task_pid AND status = 'P' LIMIT 1";
				
			$result = $this->db->query($query);
	
			if($this->db->affected_rows() > 0) {
				$pdata['errType'] = "success";
				$pdata['errMsg'] = "Task has been successfuly archived.";
			} else {
				$pdata['errType'] = "error";
				$pdata['errMsg'] = "Failed to archive!!";
			}
	
		} else {
			$pdata['errType'] = "error";
			$pdata['errMsg'] = "Invalid  Id!";
		}
	
		$pdata['redirectUrl'] = site_url("task/archive_tasks");
		$pdata['LoadViews'] = "only_message";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadPanel($pdata);
	}
	

	
	public function add_todos(){
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		$cc = $this->session->GetAdminData ()->email;
		
		$this->load->model("database/Mtask");
		$serverLimit = true;
		$task_id = $this->input->post("table_pk", true);
		$isEdit = $this->input->post("isEdit", true);
		$title = $this->input->post("title", true);
		$vtr_id = $this->input->post("vtr_id", true);
		$property = $this->input->post("property", true);
		$search = $this->input->post("search", true);
		
		//Add task
		if($task_id == 'N' && $isEdit == 'N'){
			if(IsPostBack && !empty($title)){
				if(!empty($vtr_id)){
					$this->load->model("database/Madmin");
					$this->Madmin->admin_pid($vtr_id);
					if($this->Madmin->Select()){
						$vemail = $this->Madmin->email;
						$vtr_name = $this->Madmin->lname;
							$isSuccess = $this->sendMailForTask($vemail,$title,$vtr_name,$cc);
							if($isSuccess){
								$this->AddInfo("Email successfully sent.",true);
							} else {
								//$this->AddError("Failed to send email!!",true);
							}
					} else {
						//$this->AddError("Failed to send email!!",true);
					}					
				}
				if($this->Mtask->GetFromPostData()){
					if($this->Mtask->Save()){
						$task_id=$this->Mtask->GetUpdateDB()->insert_id();
						$this->AddInfo("Task Successfully Added",true);
						//redirect("task/todos");
					}
				}
				$serverLimit = false;
			}
			
			$count = isset($_FILES['upload']) ? count($_FILES['upload']['name']) : 0;
			
			if($count > 0){
				$all_files = array();
				$file = array();
				 
				for($i=0; $i<$count; $i++){
					foreach($_FILES['upload'] as $key => $ary) {
						$file[$key] = $ary[$i];
					}
					$all_files[$i] = $file;
				}
				$pdata['all_files'] = $all_files;
				 
				$extArray = array("jpg","jpeg","png","gif","txt","pdf","doc","docx","csv","xlsx","xls");
				$size = 0;
				foreach ($all_files as $fileObject){
					$size = $size + $fileObject['size'];
				}
				if(isset($task_id) && $size < 8388500){//8388608
					foreach ($all_files as $fileObject){
						$original_file_name = $fileObject["name"];
						$ext = pathinfo($original_file_name, PATHINFO_EXTENSION);
						$lowerExtn = strtolower($ext);
				
						if(in_array( $lowerExtn, $extArray)) {
							$sqlForMax = "SELECT id FROM attachment ORDER BY id DESC LIMIT 1";
							$records = $this->db->query($sqlForMax);
							$maxId = $records->result();
							if(empty($maxId)){
								$maxId = 1;
							} else {
								$maxId = $maxId[0]->id +1;
							}
							$file_name = $maxId.".$ext";
							$sql = "INSERT INTO attachment (task_id,file_name,original_file_name) VALUES('$task_id', '$file_name','$original_file_name')";
							$records2 = $this->db->query($sql);	
							$isInsert = $this->db->affected_rows();
							$newMax = $this->db->insert_id();
							$file_name = $newMax.".$ext";
							$sql2 = "UPDATE attachment SET file_name = '$file_name' WHERE id =$newMax";
							$records3 = $this->db->query($sql2);
							$dpath=BASEPATH."../attachment/".$file_name;
							
							if($isInsert > 0){
								if(copy($fileObject["tmp_name"], $dpath)){
									$this->AddInfo("Successfully Uploaded [$original_file_name]",true);
								} else {
									$this->AddError("Error in uploading file [$original_file_name]",true);
								}
							}
						}else{
							$this->AddError("File type not supported [$original_file_name]",true);
						}
					}//end foreach
				} else {
					$this->AddError("File size exceeds limit 8MB",true);
				}
			}
			if ($serverLimit){
				//$this->AddError("File size exceeds server limit",true);
			}	
		} else {
			//**************************EDIT TASK*****************
			if(IsPostBack && !empty($title)){
				
				$this->Mtask=new Mtask();
				$this->Mtask->task_id($task_id);
				if($this->Mtask->Select()){
					$preVtr = $this->Mtask->vtr_id;
				}else{
					$preVtr = "";
				}
				
				if($preVtr != $vtr_id){
					if(!empty($vtr_id)){
						$this->load->model("database/Madmin");
						$this->Madmin->admin_pid($vtr_id);
						if($this->Madmin->Select()){
							$vemail = $this->Madmin->email;
							$vtr_name = $this->Madmin->lname;
							$isSuccess = $this->sendMailForTask($vemail,$title,$vtr_name,$cc);
							if($isSuccess){
								$this->AddInfo("Email successfully sent.",true);
							} else {
								//$this->AddError("Failed to send email!!",true);
							}
						} else {
							//$this->AddError("Failed to send email!!",true);
						}
					}
				}
				
				$this->Mtask=new Mtask();
				if($this->Mtask->GetFromPostData()){
					$this->Mtask->task_id($task_id);
					$this->Mtask->title($this->Mtask->title);
					$this->Mtask->description($this->Mtask->description);
					$this->Mtask->due_date($this->Mtask->due_date);
					$this->Mtask->vtr_id($this->Mtask->vtr_id);
					if($this->Mtask->Update()){
						$this->AddInfo("Successfully Updated",true);
						//redirect("task/todos");
					}
				}
				$serverLimit = false;
			}
			$count = isset($_FILES['upload']) ? count($_FILES['upload']['name']) : 0;
				
			if($count > 0){
				$all_files = array();
				$file = array();
					
				for($i=0; $i<$count; $i++){
					foreach($_FILES['upload'] as $key => $ary) {
						$file[$key] = $ary[$i];
					}
					$all_files[$i] = $file;
				}
				$pdata['all_files'] = $all_files;
					
				$extArray = array("jpg","jpeg","png","gif","txt","pdf","doc","docx","csv","xlsx","xls");
				$size = 0;
				foreach ($all_files as $fileObject){
					$size = $size + $fileObject['size'];
				}
				if(isset($task_id) && $size < 8388500){//8388608
					foreach ($all_files as $fileObject){
						$original_file_name = $fileObject["name"];
						$ext = pathinfo($original_file_name, PATHINFO_EXTENSION);
						$lowerExtn = strtolower($ext);
			
						if(in_array( $lowerExtn, $extArray)) {
							$sqlForMax = "SELECT id FROM attachment ORDER BY id DESC LIMIT 1";
							$records = $this->db->query($sqlForMax);
							$maxId = $records->result();
							if(empty($maxId)){
								$maxId = 1;
							} else {
								$maxId = $maxId[0]->id +1;
							}
							$file_name = $maxId.".$ext";
							$sql = "INSERT INTO attachment (task_id,file_name,original_file_name) VALUES('$task_id', '$file_name','$original_file_name')";
							$records2 = $this->db->query($sql);
							$isInsert = $this->db->affected_rows();
							$newMax = $this->db->insert_id();
							$file_name = $newMax.".$ext";
							$sql2 = "UPDATE attachment SET file_name = '$file_name' WHERE id =$newMax";
							$records3 = $this->db->query($sql2);
							$dpath=BASEPATH."../attachment/".$file_name;
								
							if($isInsert > 0){
								if(copy($fileObject["tmp_name"], $dpath)){
									$this->AddInfo("Successfully Uploaded [$original_file_name]",true);
								} else {
									$this->AddError("Error in uploading file [$original_file_name]",true);
								}
							}
						}else{
							$this->AddError("File type not supported [$original_file_name]",true);
						}
					}//end foreach
				} else {
					$this->AddError("File size exceeds limit 8MB",true);
				}
			}
			if ($serverLimit){
				//$this->AddError("File size exceeds server limit",true);
			}			
		}
		
		if($task_id == 'N' && $isEdit == 'N'){
			redirect("task/todos");
		}else{
			redirect("task/todos/$property/$search");
		}
	}
	
	public function add_todos_from_calendar(){
		$this->CheckSession(true);
		$cc = $this->session->GetAdminData ()->email;
		if($this->session->GetCurrentUserType()=="VT") die;
		$this->load->model("database/Mtask");
		$serverLimit = true;
		$title = $this->input->post("title", true);
		$vtr_id = $this->input->post("vtr_id", true);
		$due_date = $this->input->post("due_date", true);
	
		if(IsPostBack && !empty($title)){
			if(!empty($vtr_id)){
				$this->load->model("database/Madmin");
				$this->Madmin->admin_pid($vtr_id);
				if($this->Madmin->Select()){
					$vemail = $this->Madmin->email;
					$vtr_name = $this->Madmin->lname;
					$isSuccess = $this->sendMailForTask($vemail,$title,$vtr_name,$cc);
					if($isSuccess){
						//$this->AddInfo("Email successfully sent.",true);
					} else {
						//$this->AddError("Failed to send email!!",true);
					}
				} else {
					//$this->AddError("Failed to send email!!",true);
				}
			}
			if($this->Mtask->GetFromPostData()){
				if($this->Mtask->Save()){
					$task_id=$this->Mtask->GetUpdateDB()->insert_id();
					//$this->AddInfo("Task Successfully Added",true);
					//redirect("task/todos");
				}
			}
			$serverLimit = false;
		}
				
		$count = isset($_FILES['upload']) ? count($_FILES['upload']['name']) : 0;
			
		if($count > 0){
			$all_files = array();
			$file = array();
				
			for($i=0; $i<$count; $i++){
				foreach($_FILES['upload'] as $key => $ary) {
					$file[$key] = $ary[$i];
				}
				$all_files[$i] = $file;
			}
			$pdata['all_files'] = $all_files;
				
			$extArray = array("jpg","jpeg","png","gif","txt","pdf","doc","docx","csv","xlsx","xls");
			$size = 0;
			foreach ($all_files as $fileObject){
				$size = $size + $fileObject['size'];
			}
			if(isset($task_id) && $size < 8388500){//8388608
				foreach ($all_files as $fileObject){
					$original_file_name = $fileObject["name"];
					$ext = pathinfo($original_file_name, PATHINFO_EXTENSION);
					$lowerExtn = strtolower($ext);

					if(in_array( $lowerExtn, $extArray)) {
						$sqlForMax = "SELECT id FROM attachment ORDER BY id DESC LIMIT 1";
						$records = $this->db->query($sqlForMax);
						$maxId = $records->result();
						if(empty($maxId)){
							$maxId = 1;
						} else {
							$maxId = $maxId[0]->id +1;
						}
						$file_name = $maxId.".$ext";
						$sql = "INSERT INTO attachment (task_id,file_name,original_file_name) VALUES('$task_id', '$file_name','$original_file_name')";
						$records2 = $this->db->query($sql);
						$isInsert = $this->db->affected_rows();
						$newMax = $this->db->insert_id();
						$file_name = $newMax.".$ext";
						$sql2 = "UPDATE attachment SET file_name = '$file_name' WHERE id =$newMax";
						$records3 = $this->db->query($sql2);
						$dpath=BASEPATH."../attachment/".$file_name;
							
						if($isInsert > 0){
							if(copy($fileObject["tmp_name"], $dpath)){
								//$this->AddInfo("Successfully Uploaded [$original_file_name]",true);
							} else {
								//$this->AddError("Error in uploading file [$original_file_name]",true);
							}
						}
					}else{
						//$this->AddError("File type not supported [$original_file_name]",true);
					}
				}//end foreach
			} else {
				//$this->AddError("File size exceeds limit 8MB",true);
			}
		}
		if ($serverLimit){
			//$this->AddError("File size exceeds server limit",true);
		}
		redirect("task/calendar/date/$due_date");
	}
	
	public function getTaskData() {
		$this->CheckSession(true);
		$tid = $_REQUEST["tid"];
	
		$query = "SELECT * FROM task WHERE task_id = $tid";
			
		$records = $this->db->query($query);
		echo json_encode($records->result());
	}
	
	public function getTaskDataForCalendar() {
		$this->CheckSession(true);
		$tid = $_REQUEST["tid"];
		
		$this->load->model("database/Mtask");
		$this->Mtask->task_id($tid);
		$task_data = $this->Mtask->SelectJoin2();
		echo json_encode($task_data);
	}
	/*
	[{"title":"All Day Event","start":"2016-01-01"},{"title":"Long Event","start":"2016-01-07","end":"2016-01-10"
	},{"id":"999","title":"Repeating Event","start":"2016-01-09T16:00:00-05:00"},{"id":"999","title":"Repeating
 Event","start":"2016-01-16T16:00:00-05:00"},{"title":"Conference","start":"2016-01-11","end":"2016-01-13"
	},{"title":"Meeting","start":"2016-01-12T10:30:00-05:00","end":"2016-01-12T12:30:00-05:00"},{"title"
	:"Lunch","start":"2016-01-12T12:00:00-05:00"},{"title":"Meeting","start":"2016-01-12T14:30:00-05:00"
	},{"title":"Happy Hour","start":"2016-01-12T17:30:00-05:00"},{"title":"Dinner","start":"2016-01-12T20
:00:00+00:00"},{"title":"Birthday Party","start":"2016-01-13T07:00:00-05:00"},{"url":"http:\/\/google
.com\/","title":"Click for Google","start":"2016-01-28"}]
	*/
	public function getCalendarEvents() {
		//[{"title":"All Day Event","start":"2016-01-01"},]
		//[start] => 2016-01-31
		//[end] => 2016-03-13
		$start = $_REQUEST["start"];
		$end = $_REQUEST["end"];
		$uType = $this->session->GetCurrentUserType();
		
		if($uType == 'VT'){
			$loggedVtr = $this->session->GetVtrData()->admin_pid;
			$query = "SELECT task_id as id, title, due_date as start FROM task WHERE (due_date BETWEEN '$start' AND '$end') AND vtr_id = $loggedVtr AND status != 'L' AND status != 'H'";
		}else{
			$query = "SELECT task_id as id, title, due_date as start FROM task WHERE (due_date BETWEEN '$start' AND '$end') AND status != 'L' AND status != 'H'";
		}
		
		
		
		$records = $this->db->query($query);
		echo json_encode($records->result());
	}
	
	public function update_due_date(){
		//[tid] => 9
		//[due] => 2016-02-09
		$this->CheckSession(true);
		$tid = $_REQUEST["tid"];
		$due = $_REQUEST["due"];
		$query = "UPDATE task set due_date = '$due' WHERE task_id = $tid LIMIT 1";
		$records = $this->db->query($query);
		//echo json_encode($records->result());
	}
	
	public function archive_task_data() {
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		
		$tid = $_REQUEST["tid"];
		
		if(!empty($tid)){
			$query1 = "UPDATE subtask SET status = 'L' WHERE task_id = $tid AND status = 'D'";
			$query2 = "UPDATE task_comments SET status = 'L' WHERE task_id = $tid AND status = 'A'";
			$query3 = "UPDATE attachment SET status = 'L' WHERE task_id = $tid AND status = 'A'";
			$query4 = "UPDATE task SET status = 'L' WHERE task_id = $tid LIMIT 1";
			$records1 = $this->db->query($query1);
			$records2 = $this->db->query($query2);
			$records3 = $this->db->query($query3);
			$records4 = $this->db->query($query4);
			echo json_encode("s");
		}
	}
	
	public function delete_subtask_data() {
		$this->CheckSession(true);
		$uType = $this->session->GetCurrentUserType();
		$sid = $_REQUEST["sid"];
	
		if(!empty($sid)){
			if($uType == 'VT'){
				$loggedVtr = $this->session->GetVtrData()->admin_pid;
				$this->load->model("database/Msubtask");
				$this->Msubtask->subtask_id($sid);
				if($this->Msubtask->Select()){
					$subVtr = $this->Msubtask->done_vtr;
				}else{
					$subVtr = "";
				}
				if($loggedVtr == $subVtr){
					$query1 = "DELETE FROM subtask WHERE subtask_id = $sid LIMIT 1";
					$records1 = $this->db->query($query1);
				}
			}
			
			if($uType == 'AD'){
				$query1 = "DELETE FROM subtask WHERE subtask_id = $sid LIMIT 1";
				$records1 = $this->db->query($query1);				
			}

			echo json_encode("s");
		}
	}
	
	public function unlock_task() {
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		$selectedRows = $this->input->post("selected", true);
		$Unarchive = $this->input->post("Unarchive", true);
		$Delete = $this->input->post("Delete", true);
		//$uriData = $this->GetUriArray();
		//$tid = $uriData['tid'];
		
		
		
		if(!empty($selectedRows) && !empty($Unarchive)){
			foreach ($selectedRows as $key=>$tid){
				$query1 = "UPDATE subtask SET status = 'D' WHERE task_id = $tid AND status = 'L'";
				$query2 = "UPDATE task_comments SET status = 'A' WHERE task_id = $tid AND status = 'L'";
				$query3 = "UPDATE attachment SET status = 'A' WHERE task_id = $tid AND status = 'L'";
				$query4 = "UPDATE task SET status = 'P' WHERE task_id = $tid LIMIT 1";
				$records1 = $this->db->query($query1);
				$records2 = $this->db->query($query2);
				$records3 = $this->db->query($query3);
				$records4 = $this->db->query($query4);
			}
		}
		
		if(!empty($selectedRows) && !empty($Delete)){
			foreach ($selectedRows as $key=>$tid){
				$query1 = "UPDATE subtask SET status = 'H' WHERE task_id = $tid";
				$query2 = "UPDATE task_comments SET status = 'H' WHERE task_id = $tid AND status = 'L'";
				$query3 = "UPDATE attachment SET status = 'H' WHERE task_id = $tid AND status = 'L'";
				$query4 = "UPDATE task SET status = 'H' WHERE task_id = $tid LIMIT 1";
				$records1 = $this->db->query($query1);
				$records2 = $this->db->query($query2);
				$records3 = $this->db->query($query3);
				$records4 = $this->db->query($query4);
			}
		}
		
		if(false && !empty($selectedRows) && !empty($Delete)){
			foreach ($selectedRows as $key=>$tid){
				$query1 = "DELETE FROM subtask WHERE task_id = $tid";
				$query2 = "DELETE FROM task_comments WHERE task_id = $tid AND status = 'L'";
				
				$query5 = "SELECT file_name FROM attachment WHERE task_id=$tid";
				$records5 = $this->db->query($query5);
				$files = $records5->result();
				
				$query3 = "DELETE FROM attachment WHERE task_id = $tid AND status = 'L'";
				$query4 = "DELETE FROM task WHERE task_id = $tid LIMIT 1";
				$records1 = $this->db->query($query1);
				$records2 = $this->db->query($query2);
				$records3 = $this->db->query($query3);
				$isAttDel = $this->db->affected_rows();
				$records4 = $this->db->query($query4); 
				
				if($isAttDel){
					if(!empty($files)){
						foreach ($files as $file){
							$dpath=BASEPATH."../attachment/".$file->file_name;
							//H:/web_application/htdocs/PMapp/system/../attachment/40.xlsx
							if(file_exists($dpath)){
								if(unlink($dpath)){
									//GPrint("File Delete success.");
								}else{
									//GPrint("Unsuccess");
								}
							}else{
								//GPrint("File not exists");
							}
						}
					}else{
						//GPrint("Query not found");
					}
				}else{
					//GPrint("Attachment not deleted from table.");
				}
			}
		}
		redirect("task/archive_subtasks");
	}
	
	public function delete_file() {
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		$uriData = $this->GetUriArray();
		$id = $uriData['table_pk'];
		$this->load->model("database/Mattachment");
		if(!empty($id)){
			$this->Mattachment->id($id);
			if($this->Mattachment->Select()){
				$original_name = $this->Mattachment->original_file_name;
				$file_name = $this->Mattachment->file_name;
				$task_id = $this->Mattachment->task_id;
				if($this->Mattachment->Delete()){
					$dpath=BASEPATH."../attachment/".$file_name;
					if(file_exists($dpath)){
						unlink($dpath);
					}
				}
			}
		}
		redirect("task/todos_details/id/$task_id");
	}
	
	public function getSubtaskData() {
		$this->CheckSession(true);
		$subtask_id = $_REQUEST["subtask_id"];
	
		$query = "SELECT * FROM subtask WHERE subtask_id = $subtask_id";
			
		$records = $this->db->query($query);
		echo json_encode($records->result());
	}
	
	public function archive_tasks(){
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		$pdata = array();
		$tot_arr = array();
		$done_arr = array();
		$pdata['title'] = "Task List";
		$pdata['sub_title'] = "Task List";
		$this->load->model("database/Mtask");
		$this->Mtask->status('D');
		$task_data = $this->Mtask->SelectJoin();
	
		$this->load->model("database/Msubtask");
	
		$query1 = "SELECT COUNT(subtask_id) as tot_sub, task_id FROM subtask GROUP BY task_id";
		$query2 = "SELECT COUNT(subtask_id) as done_sub, task_id FROM subtask WHERE `status`='D' GROUP BY task_id";
	
		$records1 = $this->db->query($query1);
		$total_sub = $records1->result();
	
		$records2 = $this->db->query($query2);
		$done_sub = $records2->result();
	
		foreach ($done_sub as $done){
			$done_arr[$done->task_id] = $done->done_sub;
		}
	
		foreach ($total_sub as $total){
			$obj = new stdClass();
			$obj->total = $total->tot_sub;
			$obj->done = array_key_exists($total->task_id, $done_arr)?$done_arr[$total->task_id]:0;
			$tot_arr[$total->task_id] = $obj;
		}
	
		//$pdata['delete_url'] = site_url("main/delete_batch");
		$pdata['action_url'] = site_url("task/archiveData");
		$pdata['task_data'] = $task_data;
		$pdata['status_data'] = $tot_arr;
		$pdata['LoadViews'] = "task_list_archive";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadPanel($pdata);
	}
	
	public function add_task() {
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		$this->load->model("database/Mtask");
		
		if(IsPostBack){
			if($this->Mtask->GetFromPostData()){
				if($this->Mtask->Save()){
					$this->AddInfo("Successfully Added",true);
					redirect("task/tasks");
				}
			}
		}
		
		$rData=array();
		$rData['title'] = "Corporate Cup | Add Task";
		$rData['sub_title'] = "Add Task";
		$rData['taskObj']=$this->Mtask;
		$this->GetDefaultConfiguration($rData);
		$rData['LoadViews']="task_form";
		$rData['AutoMsgShow']=false;
		$this->LoadPanel($rData);
	}
	
	public function edit_task() {
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		$this->load->model("database/Mtask");
		$pdata = array();
		$pdata['title'] = "Corporate Cup | Edit Task";
		$pdata['sub_title'] = "Edit Task";
		$pdata['isEdit']=false;
		$uriData = $this->GetUriArray(); 
		
		$this->Mtask->task_id($uriData['id']);
		$this->Mtask->Select();
		$status =  $this->Mtask->status;
		if($status == 'D'){
			$this->AddError("Permission denied!!",true);
			redirect("task/tasks");
		}
		
		if(IsPostBack){
			$this->Mtask=new Mtask();
			if($this->Mtask->GetFromPostData()){
				$this->Mtask->task_id($uriData['id']);
				$this->Mtask->title($this->Mtask->title);
				$this->Mtask->due_date($this->Mtask->due_date);
				$this->Mtask->vtr_id($this->Mtask->vtr_id);
				if($this->Mtask->Update()){
					$this->AddInfo("Successfully Updated",true);
					redirect("task/tasks");
				}
			}
		}
		if(!empty($uriData['id'])){
			$pdata['isEdit']=true;
		
			$this->Mtask=new Mtask();
			$this->Mtask->task_id($uriData['id']);
		
			if($this->Mtask->Select()){
				$pdata['taskObj'] = $this->Mtask;
			}else{
				$pdata['isEdit']=false;
				$this->AddError("Invalid Task ID !!",true);
				redirect("task/tasks");
			}
		}
		$this->GetDefaultConfiguration($pdata);
		$pdata['LoadViews']="task_form";
		$pdata['AutoMsgShow']=false;
		$this->LoadPanel($pdata);		
	}
	
	public function subtasks() {
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		$uriData = $this->GetUriArray();
		$pdata = array();
		$pdata['title'] = "Subtask List";
		$pdata['sub_title'] = "Subtask List";
		$this->load->model("database/Msubtask");
		
		$this->load->model("database/Mtask");//for dropdown menu
		$this->Mtask->status('status != "D"',false);
		$task_data = $this->Mtask->SelectAll('task_id,title','task_id','desc');
		$pdata['task_data'] = $task_data;
		
		
		if(!IsPostBack && empty($uriData['id'])) {
			$pdata['search_value'] = $task_data[0]->task_id;
			$this->Msubtask->task_id($task_data[0]->task_id);
			//$isAddSubtask = $task_data[0]->status;			
		}
		if(!IsPostBack && !empty($uriData['id'])) {
			$pdata['search_value'] = $uriData['id'];
			$this->Msubtask->task_id($uriData['id']);
		}		
		
		if(IsPostBack){
			$searchByTask = trim($_POST['task_id']);
			$pdata['search_value'] = $searchByTask;
			$this->Msubtask->task_id($searchByTask);
		}	
		$subtask_data = $this->Msubtask->SelectJoin();
		$pdata['delete_url'] = site_url("main/delete_batch");
		$pdata['subtask_data'] = $subtask_data;
		$pdata['LoadViews'] = "subtask_list";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);		
	}
	
	public function archive_subtasks() {
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		$uriData = $this->GetUriArray();
		$pdata = array();
		$pdata['title'] = "Archive Task List";
		$pdata['sub_title'] = "Archive Task List";
		$this->load->model("database/Msubtask");
	
		$this->load->model("database/Mtask");//for dropdown menu
		$this->Mtask->status('L');
		//$task_data = $this->Mtask->SelectAll('task_id,title','task_id','desc');
		$task_data = $this->Mtask->SelectJoin2("","task_id","desc");
		$pdata['task_data'] = $task_data;
	
		if(count($task_data)>0){
		
			if(!IsPostBack && empty($uriData['id'])) {
				$pdata['search_value'] = $task_data[0]->task_id;
				$this->Msubtask->task_id($task_data[0]->task_id);
				//$isAddSubtask = $task_data[0]->status;
			}
			if(!IsPostBack && !empty($uriData['id'])) {
				$pdata['search_value'] = $uriData['id'];
				$this->Msubtask->task_id($uriData['id']);
			}
		
			if(IsPostBack){
				$searchByTask = trim($_POST['task_id']);
				$pdata['search_value'] = $searchByTask;
				$this->Msubtask->task_id($searchByTask);
			}
			$subtask_data = $this->Msubtask->SelectJoin();
			$pdata['subtask_data'] = $subtask_data;
		}	
		
		$pdata['delete_url'] = site_url("main/delete_batch");
		$pdata['LoadViews'] = "archive_subtask_list";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);
	}
	
	public function pending_request() {
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		$uriData = $this->GetUriArray();
		$pdata = array();
		$pdata['title'] = "Pending Request";
		$pdata['sub_title'] = "Pending Request";
		$this->load->model("database/Msubtask");
		$this->Msubtask->status('R');
		$subtask_data = $this->Msubtask->SelectJoin();
		if(count($subtask_data) < 1){
			$this->AddError("No records are found to display!!",false);
		}
		$pdata['delete_url'] = site_url("main/delete_batch");
		$pdata['subtask_data'] = $subtask_data;
		$pdata['action_url'] = site_url("task/approveBy"); //Approve by Admin and Account
		$pdata['cancel_url'] = site_url("task/cancelBy"); //Cancel by Admin and Account
		$pdata['LoadViews'] = "pending_request";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadView($pdata);
	}
	
	public function approveBy() {
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		 
		$pdata = array();
		$pdata['errType'] = "";
		$pdata['errMsg'] = "";
		$pdata['title'] = "Pending Requests";
		$pdata['sub_title'] = "";
		$uriData = $this->GetUriArray();
		
		if (isset($uriData['table_pk']) && !empty($uriData['table_pk'])) {
			$subtask_pid = $uriData['table_pk'];
		
			$query = "UPDATE subtask SET status = 'D'
				WHERE subtask_id = $subtask_pid AND status = 'R' LIMIT 1";
		
			$result = $this->db->query($query);
			
			if($this->db->affected_rows() > 0) {
				$pdata['errType'] = "success";
				$pdata['errMsg'] = "Request has been approved";
			} else {
				$pdata['errType'] = "error";
				$pdata['errMsg'] = "Approval Failed!!";
			}
		
		} else {
			$pdata['errType'] = "error";
			$pdata['errMsg'] = "Invalid  Id!";
		}
		
		$pdata['redirectUrl'] = site_url("task/pending_request");
		$pdata['LoadViews'] = "only_message";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadPanel($pdata);
	}
	

	
	public function cancelBy() {
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		 
		$pdata = array();
		$pdata['errType'] = "";
		$pdata['errMsg'] = "";
		$pdata['title'] = "Pending Requests";
		$pdata['sub_title'] = "";
		$uriData = $this->GetUriArray();
		
		if (isset($uriData['table_pk']) && !empty($uriData['table_pk'])) {
			$subtask_pid = $uriData['table_pk'];
			$query = "UPDATE subtask SET status = 'P'
				WHERE subtask_id = $subtask_pid AND status = 'R' LIMIT 1";
			
			$result = $this->db->query($query);
		
			if($this->db->affected_rows() > 0) {
				$pdata['errType'] = "success";
				$pdata['errMsg'] = "Request has been Canceled";
			} else {
				$pdata['errType'] = "error";
				$pdata['errMsg'] = "Cancelation Failed";
			}
		
		} else {
			$pdata['errType'] = "error";
			$pdata['errMsg'] = "Invalid  Id!";
		}
		
		$pdata['redirectUrl'] = site_url("task/pending_request");
		$pdata['LoadViews'] = "only_message";
		$this->GetDefaultConfiguration($pdata);
		$this->LoadPanel($pdata);
	}
	
	public function add_subtask(){
		$this->CheckSession(true);
		if($this->session->GetCurrentUserType()=="VT") die;
		$task_id = $this->input->post("task_id", true);
		$subtitle = $this->input->post("subtitle", true);
		
		$this->load->model("database/Mtask");
		$this->Mtask->task_id($task_id);
		
		if($this->Mtask->Select() && $this->Mtask->status != 'D'){
			$vtr_id = $this->Mtask->vtr_id;
			if(empty($vtr_id)){
				$this->AddInfo("Please assign volunteer for this subtasks.",true);
			}else{
				$this->load->model("database/Mvolunteer");
				$this->Mvolunteer->v_pid($vtr_id);
				if($this->Mvolunteer->Select()){
					$vemail = $this->Mvolunteer->email;
					$vtr_name = $this->Mvolunteer->lname;
					if(!empty($subtitle)){
						$isSuccess = $this->sendMail($vemail,$subtitle,$vtr_name);
						if($isSuccess){
							$this->AddInfo("Email successfully sent.",true);
						} else {
							$this->AddError("Failed to send email!!",true);
						}
					}
				} else {
					$this->AddError("Failed to send email!!",true);
				}
			}
				if(!empty($subtitle)){
					$sql = "INSERT INTO subtask (task_id,subtitle,done_vtr) VALUES('$task_id', '$subtitle','$vtr_id')";
					$records = $this->db->query($sql); 
					$this->AddInfo("Successfully Saved",true);
					redirect("task/subtasks/id/$task_id");
				} else {
					$this->AddError("Empty subtitle field",true);
					redirect("task/subtasks/id/$task_id");
				}				

		} else {
			$this->AddError("Invalid Task item has selected",true);
			redirect("task/subtasks");
		}
	}
	
	public function add_subtask2(){
		$this->CheckSession(true);
		$uType = $this->session->GetCurrentUserType();
		$subtitle = $this->input->post("subtitle", true);
		$vtr_id = $this->input->post("done_vtr", true);
		if($uType == 'VT'){
			$vtr_id = $this->session->GetVtrData()->admin_pid;
		}
		if($uType == 'AD'){
			$cc = $this->session->GetAdminData ()->email;
		}else {
			$cc = "";
		}
		$isEdit = $this->input->post("isEdit", true);
		$sub_id = $this->input->post("sub_id", true);
		$task_id = $this->input->post("task_id", true);
		$property = $this->input->post("property", true);
		$search = $this->input->post("search", true);
		
		$this->load->model("database/Mtask");
		
		if($isEdit == 'N' && $sub_id == 'N'){
			$this->Mtask->task_id($task_id);
			if($this->Mtask->Select() && $this->Mtask->status != 'L'){
				//$vtr_id = $this->Mtask->vtr_id;
				if(empty($vtr_id)){
					//$this->AddInfo("Please assign volunteer for this subtasks.",true);
				}else{
					$this->load->model("database/Madmin");
					$this->Madmin->admin_pid($vtr_id);
					if($this->Madmin->Select()){
						$vemail = $this->Madmin->email;
						$vtr_name = $this->Madmin->lname;
						if(!empty($subtitle) && $uType == 'AD'){
							$isSuccess = $this->sendMail($vemail,$subtitle,$vtr_name,$cc);
							if($isSuccess){
								$this->AddInfo("Email successfully sent.",true);
							} else {
								//$this->AddError("Failed to send email!!",true);
							}
						}
					} else {
						//$this->AddError("Failed to send email!!",true);
					}
				}
				if(!empty($subtitle)){
					$this->load->model("database/Msubtask");
					$this->Msubtask->task_id($task_id);
					$this->Msubtask->subtitle($subtitle);
					$this->Msubtask->done_vtr($vtr_id);
					if($this->Msubtask->Save()){
						$query = "UPDATE task SET status = 'P'
									WHERE task_id = $task_id LIMIT 1";
						$result = $this->db->query($query);
						//$this->AddInfo("Successfully Saved",true);
						redirect("task/todos/$property/$search");
					} else {
						//$this->AddError("Ubable to save data",true);
						redirect("task/todos/$property/$search");
				}
					
					//$sql = "INSERT INTO subtask (task_id,subtitle,done_vtr) VALUES('$task_id', '$subtitle','$vtr_id')";
					//$records = $this->db->query($sql);
					
				} else {
					//$this->AddError("Empty subtitle field",true);
					redirect("task/todos/$property/$search");
				}
		
			} else {
				//$this->AddError("Invalid Task item has selected",true);
				redirect("task/todos/$property/$search");
			}//end add subtask
		} else {
			//Edit Task
			$this->load->model("database/Msubtask");
			$this->Mtask->task_id($task_id);
			if($this->Mtask->Select() && $this->Mtask->status != 'L'){
				//$vtr_id = $this->Mtask->vtr_id;
				if(empty($vtr_id)){
					//$this->AddInfo("Please assign volunteer for this subtasks.",true);
				}else{
					$this->Msubtask->subtask_id($sub_id);
					$this->Msubtask->task_id($task_id);
					if($this->Msubtask->Select()){
						$preVtr = $this->Msubtask->done_vtr;
					}else{
						$preVtr = "";
					}
					
					if($vtr_id != $preVtr){
						$this->load->model("database/Madmin");
						$this->Madmin->admin_pid($vtr_id);
						if($this->Madmin->Select()){
							$vemail = $this->Madmin->email;
							$vtr_name = $this->Madmin->lname;
							if(!empty($subtitle) && $uType == 'AD'){
								$isSuccess = $this->sendMail($vemail,$subtitle,$vtr_name,$cc);
								if($isSuccess){
									$this->AddInfo("Email successfully sent.",true);
								} else {
									//$this->AddError("Failed to send email!!",true);
								}
							}
						} else {
							//$this->AddError("Failed to send email!!",true);
						}
					}
				}
				if(!empty($subtitle)){
					//$this->Msubtask->task_id($task_id);//Subtask task_id always fixed after adding
					$this->Msubtask = new Msubtask();
					$this->Msubtask->subtask_id($sub_id);
					$this->Msubtask->subtitle($subtitle);
					if($uType == 'AD'){
						$this->Msubtask->done_vtr($vtr_id);
					}
					
					if($this->Msubtask->Update()){
						redirect("task/todos/$property/$search");
					} else {
						//$this->AddError("Ubable to save data",true);
						redirect("task/todos/$property/$search");
					}
				} else {
					//$this->AddError("Empty subtitle field",true);
					redirect("task/todos/$property/$search");
				}
			
			} else {
				//$this->AddError("Invalid Task item has selected",true);
				redirect("task/todos/$property/$search");
			}			
		}
	}
	
	public function sendMail($to='',$subtask_title='',$vtr_name='', $cc='') {
		$this->load->library('email');
	
		$config['protocol'] = 'sendmail';
		$config['charset'] = 'utf-8';
		$config['wordwrap'] = TRUE;
		$config['mailtype'] = 'html';
	
		$this->email->initialize($config);
	
		$this->email->from('corporate_cup@vcccsar.org', 'Corporate Cup');
		//$this->email->from('noreply@appsynapsis.com', 'Appsynapsis');
		$this->email->to($to);
		$this->email->cc($cc);
	
		$this->email->subject('A new task');
		$this->email->message("
								<p>Dear Mr./Ms $vtr_name</p>
								<div>
									A new sub-task is assigned to you.<br>
									<b>Sutask Title: </b>$subtask_title<br>
								</div>
							");
		$mailStatus = $this->email->send();
		if ($mailStatus) {
			return true;
		} else {
			return false;
		}
	}
	
	public function sendMailForTask($to='',$subtask_title='',$vtr_name='', $cc='') {
		$this->load->library('email');
	
		$config['protocol'] = 'sendmail';
		$config['charset'] = 'utf-8';
		$config['wordwrap'] = TRUE;
		$config['mailtype'] = 'html';
	
		$this->email->initialize($config);
	
		$this->email->from('noreply@vcccsar.org', 'Corporate Cup');
		//$this->email->from('noreply@appsynapsis.com', 'Appsynapsis');
		$this->email->to($to);
		$this->email->cc($cc);
	
		$this->email->subject('A new task');
		$this->email->message("
				<p>Dear Mr./Ms $vtr_name</p>
				<div>
				A new task is assigned to you.<br>
				<b>Task Title: </b>$subtask_title<br>
				</div>
				");
				$mailStatus = $this->email->send();
				if ($mailStatus) {
				return true;
		} else {
		return false;
		}
	}
	
	public function sendMailForUserCreation($to='', $fname='', $lname='', $pass='') {
		$this->load->library('email');
	
		$config['protocol'] = 'sendmail';
		$config['charset'] = 'utf-8';
		$config['wordwrap'] = TRUE;
		$config['mailtype'] = 'html';
	
		$this->email->initialize($config);
		
		$fullName = $fname. " " .$lname;
	
		$this->email->from('noreply@vcccsar.org', 'Corporate Cup');
		//$this->email->from('noreply@appsynapsis.com', 'Appsynapsis');
		$this->email->to($to);
	
		$this->email->subject('VT Corporate Cup PM App User Created');
		$this->email->message("
				<p>Dear Mr./Ms $fullName</p>
				<div>
				An account has been created for you to use. Please click the following link to update your password and log in to the application.<br>
				<br>
				http://vcccsar.org/PMapp/
				<br>
				<p>Password: $pass</p>
				<br><br>
				Thank you,<br>
				Corporate Cup Staff 
				</div>
				");
				$mailStatus = $this->email->send();
				if ($mailStatus) {
				return true;
				} else {
				return false;
				}
	}

	public function email2(){
		$this->load->library('email');
		
		$config = array();
		$config['protocol'] = 'smtp';
		$config['smtp_host'] = 'vps7836.inmotionhosting.com';
		$config['smtp_user'] = 'corporate_cup@vcccsar.org';
		$config['smtp_pass'] = 'corporate_cup123!!';
		$config['smtp_port'] = 465;
		$config['charset'] = 'utf-8';
		$config['wordwrap'] = TRUE;
		$config['mailtype'] = 'html';
		$this->email->initialize($config);
		
		$this->email->set_newline("\r\n");
		
		
		$this->email->from('corporate_cup@vcccsar.org', 'Corporate Cup');
		$this->email->to('walid.islam77@gmail.com');
		
		$this->email->subject('Dashboard updated');
		$this->email->message('<h1>Your task has been done. Please check the dashboard.</h1>');
		$MailStatus = $this->email->send();
		
		echo "status:".$MailStatus;
	}
	
	public function sendMail22() {
		$this->load->library('email');
		$this->email->from('corporate_cup@vcccsar.org', 'PMApp');
		$this->email->to('walid.islam77@gmail.com'); 
		//$this->email->cc('name@gmail.com'); 
		//$this->email->bcc('them@their-example.com'); 
		$this->email->subject('Final result');
		$this->email->message('A Task has been assigned to you. Please login into admin panel.');	
		$this->email->send();
		echo "Email WWW SS gggsdfkgjfdgkl has been sent";
	}
	
	public function sendMail2() {
		$this->load->library('email');
		
		$config['protocol'] = 'sendmail';
		$config['charset'] = 'utf-8';
		$config['wordwrap'] = TRUE;
		$config['mailtype'] = 'html';
		
		$this->email->initialize($config);
		
		$this->email->from('walid_tee@yahoo.com', 'Walid');
		$this->email->to('walid.islam77@gmail.com');
		
		$this->email->subject('Regarding tasks');
		$this->email->message('Please forgive me');
		$KsbMailStatus = $this->email->send();
		GPrint($KsbMailStatus);
		GPrint("email sent from sendMail2");
	}
	
	public function sendMail3() {
		$to = "walid.islam77@gmail.com";
		$subject = "Regading admin panel" ;
		$body = "<div> hi hi hello .. </div>";
		
		$headers = 'From: PMAPP corporate_cup@vcccsar.org' . "\r\n" ;
		$headers .='Reply-To: '. $to . "\r\n" ;
		$headers .='X-Mailer: PHP/' . phpversion();
		$headers .= "MIME-Version: 1.0\r\n";
		$headers .= "Content-type: text/html; charset=iso-8859-1\r\n";
		if(mail($to, $subject, $body,$headers)) {
			echo('<br>'."Email Sent ;D ".'</br>');
		}
		else
		{
			echo("<p>Email Message delivery failed...</p>");
		}
	}
	
	public function sendMail4() {
		$this->load->library('email');
		$config = array(
				'mailtype' => 'html',
				'protocol' => 'smtp',
				'smtp_user' => 'corporate_cup@vcccsar.org',
				'smtp_pass' => 'corporate_cup123!!',
				'smtp_port' => '465',
				'smtp_host' => 'vps7836.inmotionhosting.com',
				'mail_path' => 'ssl://smtp.gmail.com'
		);
		$this->email->initialize($config);
		$this->email->set_newline("\r\n");
		$this->email->from("corporate_cup@vcccsar.org","Corporate");
		$message = "Dear Admin,<br /><br />";
		$this->email->subject('Notification');
		$this->email->message($message);
		$this->email->send();
	}
	
	
	public function edit_subtask() {
		//Admin and Volunteer both can update
		$this->CheckSession(true);
		$this->load->model("database/Msubtask");
		$pdata = array();
		$pdata['title'] = "Corporate Cup | Edit Subtask";
		$pdata['sub_title'] = "Edit Subtask";
		$pdata['isEdit']=false;
		$update = false;
		$uriData = $this->GetUriArray();
		$task_id = $uriData['task_id'];
		$uType = $this->session->GetCurrentUserType();
		$this->Msubtask->subtask_id($uriData['id']);
		$this->Msubtask->Select();
		$status =  $this->Msubtask->status;
		$vtr_id = $this->Msubtask->done_vtr;
		if($status == 'R' || $status == 'D'){
			$this->AddError("Permission denied!!",true);
			if($uType == 'AD'){
				redirect("task/subtasks/id/$task_id");
			}
			if($uType == 'VT'){
				redirect("task/vtask/id/$task_id");
			}
		}
		
		if($uType == 'VT'){
			$loggedVtr = $this->session->GetVtrData()->admin_pid;
			if($vtr_id != $loggedVtr){
				$this->AddError("Permission denied!!",true);
				redirect("task/vtask/id/$task_id");
			}
		}
		
		if(IsPostBack){
			if($uType == 'AD'){
				$newVtr = $this->input->post("done_vtr", true);
				$subtitle = $this->input->post("subtitle", true);
				if($vtr_id != $newVtr){
					$this->load->model("database/Mvolunteer");
					$this->Mvolunteer->v_pid($newVtr);
					if($this->Mvolunteer->Select() && !empty($subtitle)){
						$vemail = $this->Mvolunteer->email;
						$vtr_name = $this->Mvolunteer->lname;
						if(!empty($vemail)){
							$isSuccess = $this->sendMail($vemail,$subtitle,$vtr_name);
							if($isSuccess){
								$this->AddInfo("Email successfully sent.",true);
							} else {
								$this->AddError("Failed to send email!!",true);
							}
						}
					}else{
						//statement: if subtitle is empty and not found particular volunteer
					}
				} else {
					//statement: update only subtask title but not change volunteer
				}
			}
			$this->Msubtask=new Msubtask();
			if($this->Msubtask->GetFromPostData()){
				$this->Msubtask->subtask_id($uriData['id']);
				$this->Msubtask->subtitle($this->Msubtask->subtitle);
				$this->Msubtask->done_vtr($this->Msubtask->done_vtr);
				$this->Msubtask->status($this->Msubtask->status);
				
				if($this->Msubtask->Update()){
					$this->AddInfo("Successfully Updated",true);
					if($uType == 'AD'){
						redirect("task/subtasks/id/$task_id");
					}
					
					if($uType == 'VT'){
						redirect("task/vtask/id/$task_id");
					}
					
				}
			}
		}
		if(!empty($uriData['id'])){
			$pdata['isEdit']=true;
		
			$this->Msubtask=new Msubtask();
			$this->Msubtask->subtask_id($uriData['id']);
		
			if($this->Msubtask->Select()){
				$pdata['subtaskObj'] = $this->Msubtask;
			}else{
				$pdata['isEdit']=false;
			}
		}
		$this->GetDefaultConfiguration($pdata);
		$pdata['LoadViews']="subtask_form";
		$pdata['AutoMsgShow']=false;
		$this->LoadPanel($pdata);		
	}
	
	
	private function LoadView($rData) {
		$this->load->view("common_view",$rData);
	}
	
	private  function LoadPanel($rData){
		$this->load->view("userBody",$rData);
	}
	


}
?>