<?php
#
# Code by aldo of http://mschat.net/ for www.snowcms.com
#
if (! function_exists ( 'json_encode' )) {
	function json_encode($value) {
		# Number..? Thats fine... its just that
		if (is_numeric ( $value ))
			return $value;
		
		# A string..?
		elseif (is_string ( $value ))
			# Just incased in "
			return '"' . __json_sanitize ( $value ) . '"';
		
		# An array..? this could be a biggy
		elseif (is_array ( $value )) {
			# So we need to see if this is like a "flat" array,
			# as in, if the array is like: array('something','else')
			# it is "flat", or you could say, a keyless array
			if (__json_flat_array ( $value )) {
				# Cool, cool, its flat... so now prepare it...
				$values = array ();
				# Get the values...
				foreach ( $value as $val )
					# Recursion, sorta
					$values [] = json_encode ( $val );
				
		# Implode and return...
				return '[' . implode ( $values, ',' ) . ']';
			} else {
				# Now now, this is different, and this array has keys and values
				# So lets loop
				$values = array ();
				foreach ( $value as $key => $val ) {
					# This is a bit different, but should be easy...
					$values [] = '"' . __json_sanitize ( $key ) . '":' . json_encode ( $val );
				}
				# Implode and return
				return '{' . implode ( $values, ',' ) . '}';
			}
		} elseif (is_object ( $value )) {
			# Now now, this is different, and this array has keys and values
			# So lets loop
			$values = array ();
			foreach ( $value as $key => $val ) {
				# This is a bit different, but should be easy...
				$values [] = '"' . __json_sanitize ( $key ) . '":' . json_encode ( $val );
			}
			# Implode and return
			return '{' . implode ( $values, ',' ) . '}';
		
		# Sorry, don't support Objects
		// return false;
		}
	}
	function __json_flat_array($array) {
		# Start out with its flat
		$is_flat = true;
		foreach ( $array as $key => $value )
			if (! is_int ( $key ))
				$is_flat = false;
		return $is_flat;
	}
	function __json_sanitize($value) {
		# Sanitize and /
		$value = strtr ( $value, array ('\\' => '\\\\', '/' => '/' ) );
		# Now line breaks and what not...
		$value = strtr ( $value, array (" " => ' ', " " => ' ', " " => ' ' ) );
		# Now escape ONLY "
		$value = addcslashes ( $value, '"' );
		return $value;
	}
}

if (! function_exists ( 'ShowTrackCss' )) {
	function ShowTrackCss($tracks) {
		$outputCSS = '';
		$outputCSS .= '<style type="text/css">';
		$outputCSS .= '<!--';
		if (! empty ( $tracks ) && count ( $tracks ) > 0) {
			foreach ( $tracks as $track ) {
				if ($track->group_code != 'TRK') {
					continue;
				}
				$outputCSS .= 'tr.' . $track->description . ' td,tr.' . $track->description . ' td a{';
				if (! empty ( $track->color_code )) {
					$outputCSS .= 'color:' . $track->color_code . ";";
				}
				$outputCSS .= '}';
			}
		}
		$outputCSS .= ' -->';
		$outputCSS .= ' </style>';
		echo $outputCSS;
	}
}

if (! function_exists ( 'IsEmail' )) {
	function IsEmail($str) {
		if (preg_match ( "/^[a-zA-Z0-9_.-]+@[a-zA-Z0-9-]+.[a-zA-Z0-9-.]+$/", "$str" )) {
			return true;
		} else {
			return false;
		}
	}
}

if (! function_exists ( 'SubToCodeArr' )) {
	function SubToCodeArr() {
		$sub_arr = array('BN'=>'101,102','ENG'=>'107,108','ICT'=>'275','ECN'=>'109,110','SSL'=>'117,118','LGC'=>'121,122','PSY'=>'123,124','GEO'=>'125,126','PHY'=>'174,175',
		                   'CHE'=>'176,177','BIO'=>'178,179','ACT'=>'253,254','HM'=>'265,266', 
		                   'IHC'=>'267,268','CGG'=>'269,270','BOM'=>'277,278','PMM'=>'286,287','LGC'=>'121,122');
		return $sub_arr;
	}
}

if (! function_exists ( 'CodeToSubArr' )) {
	function CodeToSubArr() {
		$sub_arr = array('101'=>'Bangla','102'=>'Bangla','107'=>'English','108'=>'English','275'=>'Information & Communication Technology',
		
		'Economics'=>'109,110','Sociology'=>'117,118','Logic'=>'121,122','Psychology'=>'123,124','Geography'=>'125,126','Physics'=>'174,175',
		                   'Chemistry'=>'176,177','Biology'=>'178,179','Accounting'=>'253,254','Higher Math'=>'265,266', 
		                   'Islamic History & Culture'=>'267,268','Civic & Good Governance'=>'269,270','Business Organisation & Management'=>'277,278','Production Management & Marketing'=>'286,287');
		return $sub_arr;
	}
}

if (! function_exists ( 'PairSub' )) {
	function PairSub() {
		$sub_arr = array('101'=>'101,102','102'=>'101,102',
		                 '107'=>'107,108','108'=>'107,108',
		                 '275'=>'275',
		                 '109'=>'109,110','110'=>'109,110',
		                 '117'=>'117,118','118'=>'117,118',
		                 '121'=>'121,122','122'=>'121,122',
		                 '123'=>'123,124','124'=>'123,124',
		                 '125'=>'125,126','126'=>'125,126',
		                 '174'=>'174,175','175'=>'174,175',
		                 '176'=>'176,177','177'=>'176,177',
		                 '178'=>'178,179','179'=>'178,179',
		                 '253'=>'253,254','254'=>'253,254',
		                 '265'=>'265,266','266'=>'265,266',
		                 '267'=>'267,268','268'=>'267,268',
		                 '269'=>'269,270','270'=>'269,270',
		                 '277'=>'277,278','278'=>'277,278',
		                 '286'=>'286,287','287'=>'286,287',
		                 '121'=>'121,122','122'=>'121,122');
		return $sub_arr;
	}
}

if (! function_exists ( 'SubToCodeArr_short' )) {
	function SubToCodeArr_short() {
		$sub_arr_short = array('BN'=>'101','ENG'=>'107','ICT'=>'275','ECN'=>'109','SSL'=>'117','LGC'=>'121','PSY'=>'123','GEO'=>'125','PHY'=>'174',
		                   'CHE'=>'176','BIO'=>'178','ACT'=>'253','HM'=>'265', 
		                   'IHC'=>'267','CGG'=>'269','BOM'=>'277','PMM'=>'286','LGC'=>'121');
		return $sub_arr_short;
	}
}

if (! function_exists ( 'ScienceSub' )) {
	function ScienceSub() {
		$ScienceSubArr = array(101,102,107,108,275,174,175,176,177,178,179,265,266,123,124,125,126);
		return $ScienceSubArr;
	}
}

if (! function_exists ( 'ArtsSub' )) {
	function ArtsSub() {
		$ArtsSubArr = array(101,102,107,108,275,269,270,123,124,267,268,109,110,125,126,117,118,121,122);
		return $ArtsSubArr;
	}
}

if (! function_exists ( 'CommerceSub' )) {
	function CommerceSub() {
		$CommerceSubArr = array(101,102,107,108,275,277,278,253,254,286,287,109,110,123,124,125,126);
		return $CommerceSubArr;
	}
}




if (! function_exists ( 'GetMySqlDate' )) {
	function GetMySqlDate($phpDate=null) {
		$phpDate=$phpDate?$phpDate:time();
		return date("Y-m-d H:i:s");
	}
}

if (! function_exists ( 'MyEcho' )) {
	function MyEcho($text){
		echo "<br/>".$text;
	}
}
if (! function_exists ( 'GEcho' )) {
	function GEcho($str) {
		if (! empty ( $$str )) {
			return $$str;
		}
		return "";
	}
}
if (! function_exists ( 'DisableCache' )) {
	function DisableCache() {
		try {
			header ( "Expires: Tue, 03 Jul 2001 06:00:00 GMT" );
			header ( "Last-Modified: " . gmdate ( "D, d M Y H:i:s" ) . " GMT" );
			header ( "Cache-Control: no-store, no-cache, must-revalidate, max-age=0" );
			header ( "Cache-Control: post-check=0, pre-check=0", false );
			header ( "Pragma: no-cache" );
		} catch ( Exception $ex ) {
		
		}
	}
}
if (! function_exists ( 'SelectedAttr' )) {
	function SelectedAttr($value, $comValue) {
		try {
			if ($value == $comValue) {
				return " selected=\"selected\" ";
			}
		} catch ( Exception $ex ) {
		
		}
	}
}
if (! function_exists ( 'endsWith' )) {
	function endsWith($haystack, $needle) {
		$length = strlen ( $needle );
		$start = $length * - 1; //negative
		return (substr ( $haystack, $start ) === $needle);
	}

}
if (! function_exists ( 'GetAccessCode' )) {
	function GetAccessCode($str) {
		
		$AccessCodeNumberFormat = "/(\d{3})(\d{3})/";
		$output = null;
		preg_match ( $AccessCodeNumberFormat, $str, $output );
		
		$rData = array ($output [1], $output [2] );
		return $rData;
	}
}
if (! function_exists ( 'CCStarFormat' )) {
	
	function CCStarFormat($string) {
		return substr ( $string, 0, 2 ) . "*******" . substr ( $string, - 4 );
	}
}
if (! function_exists ( 'tplUrl' )) {
	function tplUrl() {
		$url = base_url () . "Templates/" . TemplateId . "/";
		return $url;
	}
}
if (! function_exists ( 'CleanPhoneNumber' )) {
	function CleanPhoneNumber($number) {
		$number = str_replace ( "-", "", $number );
		$number = str_replace ( "+", "", $number );
		$number = str_replace ( "(", "", $number );
		$number = str_replace ( ")", "", $number );
		$number = str_replace ( " ", "", $number );
		$number = preg_replace ( "[^011]", "", $number );
		$number = preg_replace ( "[^00]", "", $number );
		$number = preg_replace ( "[^0]", "", $number );
		$number = preg_replace ( "[^\\+]", "", $number );
		return $number;
	
	}
}
if (! function_exists ( 'DIDFormat' )) {
	function DIDFormat($DID, $format = "", $countryCodeLen = 0, $isFillUpWithX = false) {
		
		$DID = "" . $DID;
		$format = str_replace ( "?", "", $format );
		$fLen = strlen ( $format );
		$dLen = strlen ( $DID );
		$result = "";
		$j = 0;
		$r = 0;
		for($k = 0; $k < $countryCodeLen; $k ++) {
			if (isset ( $DID [$j] )) {
				$result .= $DID [$j ++];
				$r ++;
			}
		}
		$result .= " ";
		$r ++;
		$result .= $format;
		//echo $result."<br/>";
		for($i = $r; $i < $fLen + $r; $i ++) {
			if ($result [$i] == "0" || $result [$i] == "(" || $result [$i] == ")" || $result [$i] == " " || $result [$i] == "-") {
				if (! $isFillUpWithX && ($j) == $dLen) {
					$i ++;
					break;
				}
				continue;
			
			} elseif ($result [$i] == "9" || (( int ) $result [$i]) == "1") {
				if (! $isFillUpWithX && ($j) == $dLen) {
					break;
				} elseif ($isFillUpWithX && ($j) == $dLen) {
					$result [$i] = "X";
				}
				if ($j != $dLen)
					if (isset ( $DID [$j] ))
						$result [$i] = $DID [$j ++];
			} else {
				continue;
			}
		}
		$result = ! $isFillUpWithX ? substr ( $result, 0, $i ) : $result;
		if ($countryCodeLen > 0)
			$result = "+" . $result;
		return $result;
	
	}
}
if (! function_exists ( 'GetLanguage' )) {
	function GetLanguage($lan) {
		if ($lan == "hin") {
			$lan = "Hindi";
		} elseif ($lan == "ban") {
			$lan = "Bengali";
		} elseif ($lan == "spa") {
			$lan = "Spanish";
		} else {
			$lan = "English";
		}
		return $lan;
	}
}
if (! function_exists ( 'GPrint' )) {
	function GPrint($obj) {
		$a = print_r ( $obj, true );
		$a = "<pre>" . $a;
		//$a = preg_replace ( "/\n/", "<br/>", $a );
		$a = preg_replace ( "/Array/", "<font style='font-weight:bold;' color='Red'>Array</font>", $a );
		
		$a = preg_replace ( "/(SELECT|select|[Ff]rom|FROM|WHERE|[Ww]here)/", "<font style='font-weight:bold;' color='#47D0E8'>$1</font>", $a );
		
		$a = preg_replace ( "/([Oo]bject)/", "<font style='font-weight:bold;' color='Green'>$1</font>", $a );
		$a = preg_replace ( "/(\[.*?\])/", "<font style='font-weight:bold;' color='#917CE0'>$1</font>", $a );
		$a = preg_replace ( "/([\[\]])/", "<font color='#5CC2C4'>$1</font>", $a );
		
		$a = preg_replace ( "/=>/", "<font color='#34925E'>=></font>", $a );
		/*$a = preg_replace ( "/    /", "&nbsp;&nbsp;&nbsp;&nbsp;", $a );
		//*/
		$a .= "</pre>";
		echo $a;
	
	}
}
if (! function_exists ( 'SecToMin' )) {
	function SecToMin($sec, $padHours = true) {
		$sec = ( int ) $sec;
		// start with a blank string
		$hms = "";
		
		// do the hours first: there are 3600 seconds in an hour, so if we divide
		// the total number of seconds by 3600 and throw away the remainder, we're
		// left with the number of hours in those seconds
		$hours = intval ( intval ( $sec ) / 3600 );
		
		// add hours to $hms (with a leading 0 if asked for)
		$hms .= ($padHours) ? str_pad ( $hours, 2, "0", STR_PAD_LEFT ) . ":" : $hours . ":";
		
		// dividing the total seconds by 60 will give us the number of minutes
		// in total, but we're interested in *minutes past the hour* and to get
		// this, we have to divide by 60 again and then use the remainder
		$minutes = intval ( ($sec / 60) % 60 );
		
		// add minutes to $hms (with a leading 0 if needed)
		$hms .= str_pad ( $minutes, 2, "0", STR_PAD_LEFT ) . ":";
		
		// seconds past the minute are found by dividing the total number of seconds
		// by 60 and using the remainder
		$seconds = intval ( $sec % 60 );
		
		// add seconds to $hms (with a leading 0 if needed)
		$hms .= str_pad ( $seconds, 2, "0", STR_PAD_LEFT );
		
		// done!
		return $hms;
	
	}
}
if (! function_exists ( 'GetAccessRate' )) {
	function GetAccessRate($obj, &$toll_free_used) {
		
		$log_bill_ex_usf = $obj->bill;
		$log_bill_ex_usf = round ( $log_bill_ex_usf, 4 );
		$log_bill_ex_usf = sprintf ( "%.04f", $log_bill_ex_usf );
		$USF = $obj->USF_tax;
		$log_bill = $obj->bill + $USF;
		$log_bill = round ( $log_bill, 4 );
		$log_bill = sprintf ( "%.04f", $log_bill );
		$tollfree_portion = substr ( $obj->did, 0, 4 );
		
		if ($tollfree_portion == "1800" || $tollfree_portion == "1866") {
			$access_rate = $obj->rate;
			//	$access_rate += $toll_free_rate;
			$access_rate = round ( $access_rate, 4 );
			$access_rate = sprintf ( "%.04f", $access_rate );
			$access_rate = "$access_rate**";
			$toll_free_used = 1;
		
		//	$local_access = "&nbsp;";
		} else {
			//	$tollfree_access = "&nbsp;";
			$access_rate = $rate;
			$access_rate = round ( $access_rate, 4 );
			$access_rate = sprintf ( "%.04f", $access_rate );
		}
		return $access_rate;
	
	}
	if (! function_exists ( 'EchoWnull' )) {
		function EchoIfNotNull($obj, $isReturn = false) {
			if ($obj != null) {
				echo $obj;
			}
		
		}
	}
}
if (! function_exists ( 'my_crypt' )) {
	function my_crypt($string, $key) {
		if (! $key)
			return "fail";
		if (! $string)
			return "fail";
		
		$iv_size = 6;
		$iv_encryption_index = 3;
		$block = 4;
		$return_value = "";
		mt_srand ( ( double ) microtime () * 1000000 );
		$iv = substr ( mt_rand ( 1000000000, 99999999999 ), 1, $iv_size );
		
		$str_size = strlen ( $string );
		for($i = 0; $i < $str_size; $i ++) {
			//$indx_block_to_use = $i%$block;
			$indx_block_to_use = ( int ) ($i / $block);
			$block_to_use = $iv [$indx_block_to_use];
			$cur_char = $string [$i];
			$return_value .= $key [$block_to_use] [$cur_char];
		}
		
		if (strlen ( $return_value ) != $str_size)
			return "fail";
		
		$return_value_rev = strrev ( $return_value );
		$iv_str = "";
		
		for($i = 0; $i < $iv_size; $i ++) {
			$cur_char = $iv [$i];
			$iv_str .= $key [$iv_encryption_index] [$cur_char];
		}
		
		if (strlen ( $iv_str ) != $iv_size)
			return "fail";
		
		$return_value_rev .= $iv_str;
		
		return base64_encode ( $return_value_rev );
	}
}
if (! function_exists ( 'get_rand_id' )) {
	function get_rand_id($length) {
		$rand_id = "";
		if ($length > 0) {
			for($i = 1; $i <= $length; $i ++) {
				mt_srand ( ( double ) microtime () * 1000000 );
				$num = mt_rand ( 1, 36 );
				$rand_id .= assign_rand_value ( $num );
			}
		}
		return $rand_id;
	}

}
if (! function_exists ( 'assign_rand_value' )) {
	function assign_rand_value($num) {
		// accepts 1 - 36
		switch ($num) {
			case "1" :
				$rand_value = "a";
				break;
			case "2" :
				$rand_value = "b";
				break;
			case "3" :
				$rand_value = "c";
				break;
			case "4" :
				$rand_value = "d";
				break;
			case "5" :
				$rand_value = "e";
				break;
			case "6" :
				$rand_value = "f";
				break;
			case "7" :
				$rand_value = "g";
				break;
			case "8" :
				$rand_value = "h";
				break;
			case "9" :
				$rand_value = "i";
				break;
			case "10" :
				$rand_value = "j";
				break;
			case "11" :
				$rand_value = "k";
				break;
			case "12" :
				$rand_value = "l";
				break;
			case "13" :
				$rand_value = "m";
				break;
			case "14" :
				$rand_value = "n";
				break;
			case "15" :
				$rand_value = "o";
				break;
			case "16" :
				$rand_value = "p";
				break;
			case "17" :
				$rand_value = "q";
				break;
			case "18" :
				$rand_value = "r";
				break;
			case "19" :
				$rand_value = "s";
				break;
			case "20" :
				$rand_value = "t";
				break;
			case "21" :
				$rand_value = "u";
				break;
			case "22" :
				$rand_value = "v";
				break;
			case "23" :
				$rand_value = "w";
				break;
			case "24" :
				$rand_value = "x";
				break;
			case "25" :
				$rand_value = "y";
				break;
			case "26" :
				$rand_value = "z";
				break;
			case "27" :
				$rand_value = "0";
				break;
			case "28" :
				$rand_value = "1";
				break;
			case "29" :
				$rand_value = "2";
				break;
			case "30" :
				$rand_value = "3";
				break;
			case "31" :
				$rand_value = "4";
				break;
			case "32" :
				$rand_value = "5";
				break;
			case "33" :
				$rand_value = "6";
				break;
			case "34" :
				$rand_value = "7";
				break;
			case "35" :
				$rand_value = "8";
				break;
			case "36" :
				$rand_value = "9";
				break;
		}
		return $rand_value;
	}

}
if (! function_exists ( 'my_decrypt' )) {
	function my_decrypt($string, $key) {
		if (! $key)
			return "fail";
		if (! $string)
			return "fail";
		
		$iv_size = 6;
		$iv_encryption_index = 3;
		$block = 4;
		$return_value = "";
		$encrypted_str = base64_decode ( $string );
		
		$iv_str = substr ( $encrypted_str, - $iv_size );
		$iv = "";
		
		for($i = 0; $i < $iv_size; $i ++) {
			$block_str = $key [$iv_encryption_index];
			$pos = strpos ( $block_str, $iv_str [$i] );
			$iv .= $pos;
		}
		
		if (strlen ( $iv ) != $iv_size)
			return "fail";
		
		$encrypted_true_str_rev = substr ( $encrypted_str, 0, - $iv_size );
		$encrypted_true_str = strrev ( $encrypted_true_str_rev );
		$str_size = strlen ( $encrypted_true_str );
		for($i = 0; $i < $str_size; $i ++) {
			//$indx_block_to_use = $i%$block;
			$indx_block_to_use = ( int ) ($i / $block);
			$block_to_use = $iv [$indx_block_to_use];
			$block_str = $key [$block_to_use];
			$pos = strpos ( $block_str, $encrypted_true_str [$i] );
			$return_value .= $pos;
		}
		
		if (strlen ( $return_value ) != $str_size)
			return "fail";
		
		return $return_value;
	}
}

// objectsto tables
if (! function_exists ( 'ObjectToTable' )) {
	function ObjectToTable($objects, $propertys = null, $isHeader = true, $isGSTable = true) {
		$except = array ("setCountryCode", "validations", "strPrpertyForLog", "setProperties", "setOption", "tableName", "primaryKey" );
		if(!empty($objects)){
		$herderObj = is_array ( $objects ) ? $objects [0] : $objects;
		
			
		}else{
			return ;
		}
		$isObjects = is_object ( $objects ) ? true : false;
		$tableName = $isHeader ? "<h3>" . (isset ( $herderObj->tableName ) ? $herderObj->tableName : "") . "</h3>" : "";
		
		$Header = '<thead><tr>';
		$body = '<tbody>';
		foreach ( $herderObj as $head => $val ) {
			if (! in_array ( $head, $except )) {
				$Header .= "<td " . ($isGSTable ? "" : "style='border:1px solid #625D5D; padding:5px;'") . ">" . $head . "</td>";
			}
		}
		$Header .= "</tr></thead>";
		if (! $isObjects) {
			foreach ( $objects as $object ) {
				$body.=GetObjectTd($object,$except,$isGSTable);	
				$body .="</tr><tr>";			
			}
		}else{
			$body.=GetObjectTd($objects,$except,$isGSTable);
		}
		$body .= '</tbody>';
		echo '<br/>' . $tableName . '<table ' . ($isGSTable ? 'class="GSTable"' : 'style="border-collapse:collapse;margin-top:10px;"') . '>' . $Header . $body . '</table>';
	}
	function GetObjectTd($object,$except,$isGSTable) {
		$except = array ("setCountryCode", "validations", "strPrpertyForLog", "setProperties", "setOption", "tableName", "primaryKey" );
		$body="";
		foreach ( $object as $head => $val ) {
			if (! in_array ( $head, $except )) {
				$body .= "<td " . ($isGSTable ? "" : "style='border:1px solid #625D5D;padding:2px;'") . ">" . $val . "</td>";
			}
			
		}
		return $body;
	}

}

function GetFileVersion($FileName) {	
	$handle = fopen ( $FileName, 'rb' );
	if (! $handle)
		return FALSE;
	$Header = fread ( $handle, 64 );
	if (substr ( $Header, 0, 2 ) != 'MZ')
		return FALSE;
	$PEOffset = unpack ( "V", substr ( $Header, 60, 4 ) );
	if ($PEOffset [1] < 64)
		return FALSE;
	fseek ( $handle, $PEOffset [1], SEEK_SET );
	$Header = fread ( $handle, 24 );
	if (substr ( $Header, 0, 2 ) != 'PE')
		return FALSE;
	$Machine = unpack ( "v", substr ( $Header, 4, 2 ) );
	if ($Machine [1] != 332)
		return FALSE;
	$NoSections = unpack ( "v", substr ( $Header, 6, 2 ) );
	$OptHdrSize = unpack ( "v", substr ( $Header, 20, 2 ) );
	fseek ( $handle, $OptHdrSize [1], SEEK_CUR );
	$ResFound = FALSE;
	for($x = 0; x < $NoSections [1]; $x ++) {
		$SecHdr = fread ( $handle, 40 );
		if (substr ( $SecHdr, 0, 5 ) == '.rsrc') { //resource section
			$ResFound = TRUE;
			break;
		}
	}
	if (! $ResFound)
		return FALSE;
	$InfoVirt = unpack ( "V", substr ( $SecHdr, 12, 4 ) );
	$InfoSize = unpack ( "V", substr ( $SecHdr, 16, 4 ) );
	$InfoOff = unpack ( "V", substr ( $SecHdr, 20, 4 ) );
	fseek ( $handle, $InfoOff [1], SEEK_SET );
	$Info = fread ( $handle, $InfoSize [1] );
	$NumDirs = unpack ( "v", substr ( $Info, 14, 2 ) );
	$InfoFound = FALSE;
	for($x = 0; $x < $NumDirs [1]; $x ++) {
		$Type = unpack ( "V", substr ( $Info, ($x * 8) + 16, 4 ) );
		if ($Type [1] == 16) { //FILEINFO resource
			$InfoFound = TRUE;
			$SubOff = unpack ( "V", substr ( $Info, ($x * 8) + 20, 4 ) );
			break;
		}
	}
	if (! $InfoFound)
		return FALSE;
	$SubOff [1] &= 0x7fffffff;
	$InfoOff = unpack ( "V", substr ( $Info, $SubOff [1] + 20, 4 ) ); //offset of first FILEINFO
	$InfoOff [1] &= 0x7fffffff;
	$InfoOff = unpack ( "V", substr ( $Info, $InfoOff [1] + 20, 4 ) ); //offset to data
	$DataOff = unpack ( "V", substr ( $Info, $InfoOff [1], 4 ) );
	$DataSize = unpack ( "V", substr ( $Info, $InfoOff [1] + 4, 4 ) );
	$CodePage = unpack ( "V", substr ( $Info, $InfoOff [1] + 8, 4 ) );
	$DataOff [1] -= $InfoVirt [1];
	$Version = unpack ( "v4", substr ( $Info, $DataOff [1] + 48, 8 ) );
	$x = $Version [2];
	$Version [2] = $Version [1];
	$Version [1] = $x;
	$x = $Version [4];
	$Version [4] = $Version [3];
	$Version [3] = $x;
	return $Version;

}
if (! function_exists ( '_e' )) {
	function _e($str){
		echo $str;
	}
}

if(!function_exists("PostValue")){
	function PostValue($name,$Default=""){
		if(!empty($_POST[$name])){
			return $_POST[$name];
		}
		return $Default;

	}
}
if(!function_exists("RequestValue")){
	function RequestValue($name,$Default=""){
		if(!empty($_REQUEST[$name])){
			return $_REQUEST[$name];
		}
		return $Default;

	}
}
if(!function_exists("GetValue")){
	function GetValue($name,$Default=""){
		if(!empty($_GET[$name])){
			return $_GET[$name];
		}
		return $Default;

	}
}
if(!function_exists("ShowErrorMsg")){
	function ShowErrorMsg($error,$info){?>		
		<div class="row gs-alert">
			<div class="col-md-12">
				<?php if(!empty($error)){?>
				<div class="alert alert-danger" role="alert">
					<?php echo $error;?>
				</div>
				<?php }?>
				<?php if(!empty($info)){?>
				<div class="alert alert-success" role="alert">
					<?php echo $info;?>
				</div>
				<?php }?>	
				</div>	
			</div>
			<?php 
	}
}
//
