<?php 
			
/**
 * Version 1.0.0
 * Creation date: 15/Feb/2015
 * @Written By: S.M. Sarwar Hasan
 *     Genuity Systems
 */						
class Mbooking extends GSModel{
	var $booking_id;
	var $pname;
	var $email;
	var $contact_no;
	
	var $fax_no;
	var $checkInDate;
	var $checkOutDate;
	var $rtype_id;
	
	var $num_room;
	var $num_night;
	var $num_adult;
	var $num_child;
	
	var $status;
	var $creation_date;
	
	private $magic_quotes_active;
	private $real_escape_string_exists;
	
	//foreach($timezones as $key => $zone){
		function __construct() {
			parent::__construct ();
			$this->SetValidation();	
			$this->tableName="booking";
			$this->primaryKey="booking_id";
			
			$this->magic_quotes_active = get_magic_quotes_gpc();
			$this->real_escape_string_exists = function_exists( "mysql_real_escape_string" );
		}
			
	 function Reset(){
		$this->rtype_id=$this->rtype_name=$this->description=$this->status=null;

	}

	public function escape_value( $value ) {
		if( $this->real_escape_string_exists ) { // PHP v4.3.0 or higher
			// undo any magic quote effects so mysql_real_escape_string can do the work
			if( $this->magic_quotes_active ) { $value = stripslashes( $value ); }
			$value = mysql_real_escape_string( $value );
		} else { // before PHP v4.3.0
			// if magic quotes aren't already on then add slashes manually
			if( !$this->magic_quotes_active ) { $value = addslashes( $value ); }
			// if magic quotes are active, then the slashes already exist
		}
		return $value;
	}
	

	
	function SetValidation(){
		$this->validations=array(
			"admin_pid"=>array("Text"=>"admin_pid", "Rule"=>"required|xss_clean"),
			"email"=>array("Text"=>"Email Address", "Rule"=>"required|xss_clean"),
			"password"=>array("Text"=>"Password", "Rule"=>"required|xss_clean"),
			"fname"=>array("Text"=>"First Name", "Rule"=>"required|xss_clean"),
			"lname"=>array("Text"=>"Last Name", "Rule"=>"required|xss_clean"),
			"title"=>array("Text"=>"Title", "Rule"=>"required|xss_clean"),
			//"time_zone"=>array("Text"=>"time_zone", "Rule"=>""),
			//"short_bio"=>array("Text"=>"short_bio", "Rule"=>""),
			//"role"=>array("Text"=>"role", "Rule"=>""),
			"status"=>array("Text"=>"status", "Rule"=>"")
		);
	}
	
	/*Use these time zones: Delete all others...
1. Eastern Standard Time
2. Pacific Standard Time
3. Mountain Standard Time
4. Central Standard Time
*/
	
	 function GetAddForm($isEdit,$label_col=5,$input_col=7,$mainobj=null){
	 	//$tzlist = DateTimeZone::listIdentifiers(DateTimeZone::ALL);GPrint($tzlist);
	 	//http://stackoverflow.com/questions/1727077/generating-a-drop-down-list-of-timezones-with-php
	 	$timezonesArr = array (
	 			'-5' => '[UTC - 5] Eastern Standard Time',
	 			'-8' => '[UTC - 8] Pacific Standard Time',
	 			'-7' => '[UTC - 7] Mountain Standard Time',
	 			'-6' => '[UTC - 6] Central Standard Time'
	 	);	 	
		
				if(!$mainobj){
				$mainobj=$this;
				}
				
				$role = $this->session->GetAdminData ()->role;
				
					?>
					
			 <div class="form-group">
		      	<label class="control-label col-md-<?php echo $label_col;?>" for="fname"><?php _e("First Name"); ?></label>
		      	<div class="col-md-<?php echo $input_col;?>">                   			     	
		      		<input type="text" maxlength="50"  value="<?php echo  $mainobj->GetPostValue("fname");?>" class="form-control" id="fname" name="fname" placeholder="First Name" data-bv-notempty="true" 	data-bv-notempty-message="<?php  _e("First Name is required");?>">
		      	</div>
		      </div> 
			
			 <div class="form-group">
		      	<label class="control-label col-md-<?php echo $label_col;?>" for="lname"><?php _e("Last Name"); ?></label>
		      	<div class="col-md-<?php echo $input_col;?>">                   			     	
		      		<input type="text" maxlength="50"  value="<?php echo  $mainobj->GetPostValue("lname");?>" class="form-control" id="lname" name="lname" placeholder="Last Name" data-bv-notempty="true" 	data-bv-notempty-message="<?php  _e("Last Name is required");?>">
		      	</div>
		      </div> 
		      
		      
		      <?php if($role == 'S'){?>
		      <div class="form-group">
		      	<label class="control-label col-md-<?php echo $label_col;?>" for="role"><?php _e("Role"); ?></label>
		      	<div class="col-md-<?php echo $input_col;?>">
	      			<select name="role" class="form-control"> 
						<option <?php echo $mainobj->role=="V"?' selected="selected" ':"";?> value="V">Volunteer</option>
						<option <?php echo $mainobj->role=="A"?' selected="selected" ':"";?> value="A">Admin</option>
						<option <?php echo $mainobj->role=="S"?' selected="selected" ':"";?> value="S">Super Admin</option>
					</select>		      	
		      	</div>
		     </div>	
		     <?php }?>	
		     
		    <?php if($role == 'A'){?>
		      <div class="form-group">
		      	<label class="control-label col-md-<?php echo $label_col;?>" for="role"><?php _e("Role"); ?></label>
		      	<div class="col-md-<?php echo $input_col;?>">
	      			<select name="role" class="form-control"> 
						<option <?php echo $mainobj->role=="V"?' selected="selected" ':"";?> value="V">Volunteer</option>
					</select>		      	
		      	</div>
		     </div>	
		     <?php }?>					
			
			 <div class="form-group">
		      	<label class="control-label col-md-<?php echo $label_col;?>" for="email"><?php _e("Email Address"); ?></label>
		      	<div class="col-md-<?php echo $input_col;?>">                   			     	
		      		<input type="text" maxlength="50"  value="<?php echo  $mainobj->GetPostValue("email");?>" class="form-control" id="email" name="email" placeholder="Email Address" data-bv-notempty="true" 	data-bv-notempty-message="<?php  _e("Email Address is required");?>">
		      	</div>
		      </div> 
			
			 <?php if(!$isEdit){ ?>
			 <div class="form-group">
		      	<label class="control-label col-md-<?php echo $label_col;?>" for="password"><?php _e("Password"); ?></label>
		      	<div class="col-md-<?php echo $input_col;?>">                   			     	
		      		<input type="text" maxlength="32"  value="<?php echo  $mainobj->GetPostValue("password");?>" class="form-control" id="password" name="password" placeholder="Password" data-bv-notempty="true" 	data-bv-notempty-message="<?php  _e("Password is required");?>">
		      	</div>
		      </div> 
		      <?php }?>
			
			 <div class="form-group">
		      	<label class="control-label col-md-<?php echo $label_col;?>" for="title"><?php _e("Title"); ?></label>
		      	<div class="col-md-<?php echo $input_col;?>">                   			     	
		      		<input type="text" maxlength="50"  value="<?php echo  $mainobj->GetPostValue("title");?>" class="form-control" id="title" name="title" placeholder="Title" data-bv-notempty="true" 	data-bv-notempty-message="<?php  _e("Title is required");?>">
		      	</div>
		      </div> 
			
			 <div class="form-group">
		      	<label class="control-label col-md-<?php echo $label_col;?>" for="time_zone"><?php _e("Time Zone"); ?></label>
		      	<div class="col-md-<?php echo $input_col;?>">    
	      			<select name="time_zone" class="form-control">
						<?php foreach ($timezonesArr as $key => $zone) { ?>
							<option <?php echo $mainobj->time_zone==$key?' selected="selected" ':"";?>  value="<?php echo $key;?>"><?php echo $zone;?></option>
						<?php } ?>
					</select>		      	               			     	
		      	</div>
		      </div> 
			
			 <div class="form-group">
		      	<label class="control-label col-md-<?php echo $label_col;?>" for="short_bio"><?php _e("Short Biography"); ?></label>
		      	<div class="col-md-<?php echo $input_col;?>">                   			     	
		      		<textarea class="form-control" id="short_bio" name="short_bio" placeholder="Enter ..." rows="3" ><?php echo  $mainobj->GetPostValue("short_bio");?></textarea>
		      	</div>
		      </div> 
		      
		     <?php if($isEdit){ ?> 
			 <div class="form-group">
		      	<label class="control-label col-md-<?php echo $label_col;?>" for="status"><?php _e("Status"); ?></label>
		      	<div class="col-md-<?php echo $input_col;?>">
	      			<select name="status" class="form-control"> 
						<option <?php echo $mainobj->status=="A"?' selected="selected" ':"";?> value="A">Active</option>
						<option <?php echo $mainobj->status=="I"?' selected="selected" ':"";?> value="I">Inactive</option>
					</select>		      	
		      	</div>
		     </div>		      
			<?php }?>
		      
		      <div class="form-group">		      	
		      	
		      	<div class="col-md-9 text-right">			      	
					<div class="fileUpload btn btn-primary m-r-zero">
					    <span>Add photo</span>
					    <input id="uploadBtn" name="file_upload" type="file" class="upload" />
					</div>	
					<br/><input id="uploadFile" class="form-control" placeholder="Choose File" disabled="disabled" />	      	
		      	</div>	
		      	<div class="col-md-3 text-left">
		      		<?php 
		      			$image_link=base_url()."img/admin/user.png";
						if(file_exists(BASEPATH."../img/admin/".$mainobj->admin_pid.".jpg")){
							$image_link=base_url()."img/admin/".$mainobj->admin_pid.".jpg?v=".filemtime(BASEPATH."../img/admin/".$mainobj->admin_pid.".jpg");
						}
					?>
		      	<img id="inst_img" style="height:100px;" class="img-thumbnail" border="0" alt="<?php echo $mainobj->fname;?>" title="<?php echo $mainobj->fname;?>" src="<?php echo $image_link;?>">
		      	</div>
					
		      </div> 
			<script type="text/javascript">
				document.getElementById("uploadBtn").onchange = function () {
				    document.getElementById("uploadFile").value = this.value;
				    
				};
				$("#uploadBtn").change(function(){
				    readURL(this,"#inst_img");				  
				});
			</script>		      
			
			<?php 
	}
	
	
	function SelectJoin($QueryString = "", $orderBy = '', $order = 'asc', $limit = 0, $limitStart = 0) {
		if ($this->tableName == null) {
			$this->AddSystemLog ( $this->msg->GetMsg ( 's002' ) );
			return false;
		}
		if ($QueryString != ""){
			$this->GetSelectDB ()->Select ( $QueryString );
		}else {
			$this->GetSelectDB ()->Select ( $this->tableName.".*, rt.rtype_name" );
			//$this->GetSelectDB ()->Select ( $this->tableName.".*, t.*, e.*" );
		}
		$this->GetSelectDB ()->join("room_type AS rt", "rt.rtype_id=".$this->tableName.".rtype_id", "left");
		foreach ( $this->setProperties as $key => $value ) {
			if (isset ( $this->setOption [$key] )) {
				$this->GetSelectDB ()->where ( $this->tableName.".".$this->$key, '', $this->setOption [$key] );
			} else {
				$this->GetSelectDB ()->where ( $this->tableName.".".$key, $this->$key );
			}
	
		}
		$pkey=$this->primaryKey;
		if(isset($this->setOption[$pkey])){
			$this->GetSelectDB ()->where ( $this->tableName.".".$this->$pkey, '', $this->setOption [$pkey] );
		}else{
			if(!empty($this->$pkey)){
				$this->GetSelectDB ()->where ($this->tableName.".".$pkey,$this->$pkey);
			}
		}
		if ($orderBy != '' && property_exists ( $this, $orderBy )) {
			if ($order == '')
				$order = 'asc';
			$this->GetSelectDB ()->order_by ( $orderBy, $order );
		}
		if ($limit > 0) {
			$this->GetSelectDB ()->limit ( $limit, $limitStart );
		}
		$data = $this->GetSelectDB ()->get ( "booking" )->result ();//here to assign FROM TABLE_NAME
		if (count ( $data ) > 0) {
			$allData = null;
			$i = 0;
			foreach ( $data as $tm ) {
				$allData [$i ++] = $this->BindObject ( $tm, true );
			}
			$this->AddDebugMsg ( "SelectAll of " . get_class ( $this ) . " is found data" );
			return $allData;
		} else {
			$this->AddDebugMsg ( "SelectAll of " . get_class ( $this ) . " return null for  no data found", StatusError );
			return array();
		}
	
	}
}





?>