<?php
class Mlog extends CI_Model {
	private static $info=array();
	private static $error=array();
	private static $systemLog;
	private static $Feature;
	private static $debugMsg;
	private $languageName;
	function __construct() {
		parent::__construct ();
		$this->load->library ( "session" );
	
	}
	static function ResetDebugMsg($session = null) {
		Mlog::$debugMsg = "";
		if ($session) {
			$session->UnsetSession ( "debugMsg" );
		}
	}
	static function AddDebugMsg($str, $status, $sessionObj, $isSession = false) {
		if (! IsDebugMode)
			return;
		if ($isSession) {
			$oldSessionMsg = $sessionObj->GetSession ( "debugMsg", true );
			$sessionObj->SetSession ( "debugMsg", $oldSessionMsg . "<p class=\"$status\">" . $str . "</p>" );
		} else {
			Mlog::$debugMsg .= "<p class=\"$status\">" . $str . "</p>";
		}
	}
	static function AddNewFeature($str, $sessionObj, $isSession = false, $PageMathod = '') {
		if ($isSession) {
			$oldSessionMsg = $sessionObj->GetSession ( "sysFeature" . $PageMathod, true );
			$sessionObj->SetSession ( "sysFeature" . $PageMathod, $oldSessionMsg . "<li class=''><div>" . $str . "</div></li>" );
		} else {
			Mlog::$Feature .= "<li class=''><div>" . $str . "</div></li>";
		}
	}
	static function AddSystemLog($str, $sessionObj, $isSession = false) {
		if ($isSession) {
			$oldSessionMsg = $sessionObj->GetSession ( "sysLog", true );
			$sessionObj->SetSession ( "sysLog", $oldSessionMsg . "<p>" . $str . "</p>" );
		} else {
			Mlog::$systemLog .= "<p>" . $str . "</p>";
		}
	}
	static function AddError($error, $sessionObj, $isSession = false,$isPTagAdded=false) {
		$error=$isPTagAdded?$error:"<p>$error</p>";
		if ($isSession) {
			$oldSessionMsg = $sessionObj->GetSession ( "error", true );
			if(!is_array($oldSessionMsg)){
				$oldSessionMsg=array();
			}
			array_push($oldSessionMsg, $error);			
			$sessionObj->SetSession ( "error", $oldSessionMsg);
		} else {			
			if(!is_array(Mlog::$error)){
				Mlog::$error=array();
			}
			array_push(Mlog::$error, $error);
		}
	}
	static function AddInfo($info, $sessionObj, $isSession = false,$isPTagAdded=false) {
			$error=$isPTagAdded?$info:"<p>$info</p>";
			if ($isSession) {
				$oldSessionMsg = $sessionObj->GetSession ( "info", true );
				if(!is_array($oldSessionMsg)){
					$oldSessionMsg=array();
				}
				array_push($oldSessionMsg, $error);			
				$sessionObj->SetSession ( "info", $oldSessionMsg);
			} else {			
				if(!is_array(Mlog::$error)){
					Mlog::$info=array();
				}
				array_push(Mlog::$info, $error);
			}
		}
	
	static function GetSystemLog($sessionObj = null) {
		$sMsg = $sessionObj ? $sessionObj->GetSession ( "sysLog", true ) : null;
		if (! empty ( Mlog::$systemLog ) && $sMsg) {
			
			return "<div class='sysLog'>" . $sMsg . Mlog::$systemLog . "</div>";
		} else {
			return null;
		}
	
	}
	static function GetError($sessionObj = null,$isArrayReturn=false) {
		$sMsg = $sessionObj ? $sessionObj->GetSession ( "error", true ) : null;
		if (! empty ( Mlog::$error ) || $sMsg) {
			if($isArrayReturn){
				$result = array_merge((array)Mlog::$error, (array)$sMsg);
				return  $result;
			}
			$returnError="";	
			$returnError.=implode("", Mlog::$error );
			if(is_array($sMsg)){
				$returnError.=	implode("", $sMsg );
			}
			return "<div class='errorMsg'>" .$returnError. "</div>";
		} else {
			return null;
		}
	}
	static function GetInfo($sessionObj = null,$isArrayReturn=false) {
		$sMsg = $sessionObj ? $sessionObj->GetSession ( "info", true ) : null;
		if (! empty ( Mlog::$info ) || $sMsg) {
			if($isArrayReturn){
				$result = array_merge((array)Mlog::$info, (array)$sMsg);
				return  $result;
			}
			$returnInfo="";	
			$returnInfo.=implode("", Mlog::$info );
			if(is_array($sMsg)){
				$returnInfo.=	implode("", $sMsg );
			}
			return "<div class='infoMsg'>" .$returnInfo. "</div>";
		} else {
			return null;
		}
	}

	static function GetFeature($sessionObj = null, $PageMathod = '', $isUnset = false) {
		$sMsg = $sessionObj ? $sessionObj->GetSession ( "sysFeature" . $PageMathod, $isUnset ) : null;
		
		if (! empty ( Mlog::$Feature ) || $sMsg) {
			return "<ul class='Features'>" . $sMsg . Mlog::$Feature . "</ul>";
		} else {
			return null;
		}
	}
	static function GetDebugMsg($sessionObj = null) {
		if (! IsDebugMode)
			return null;
		$sMsg = $sessionObj ? $sessionObj->GetSession ( "debugMsg", true ) : null;
		if (! empty ( Mlog::$debugMsg ) || $sMsg) {
			return "<div class='debugMsg'>" . $sMsg . Mlog::$debugMsg . "</div>";
		} else {
			return null;
		}
	}
	
	
	/**
	 * Insert Log into Database ...
	 * @param  String $msg	
	 * @param String $page
	 * @param String $value
	 * @param   String $type
	 * where type can be (V=View,A=ADD,U=Update)	
	 */
	function AddLog($msg = '', $parm = '', $value = "", $type = "V") {
		return ;
		$uType = $this->session->GetCurrentUserType ();		
		$userType = "U";
		$userId = "";
		$type = strtoupper ( $type );
		if ($uType == "CU") {
			$userId = $this->session->GetUserData ()->accountId;
			if ($type == "V" && IsUserViewLog) {
				$userType = "U";
			} elseif ($type == "U" && IsUserUpdateLog) {
				$userType = "U";
			} elseif ($type == "A" && IsUserInsertLog) {
				$userType = "U";
			} elseif ($type == "D" && IsUserDeleteLog) {
				$userType = "U";
			} elseif ($type == "O" && IsUserDownloadLog) {
				$userType = "U";
			} elseif ($type == "P" && IsUserUploadLog) {
				$userType = "U";
			} elseif ($type == "C" && IsUserCommonLog) {
				$userType = "U";
			} elseif ($type == "S" && IsUserShareLog) {
				$userType = "U";
			} else {
				return true;
			}		
		
		}elseif ($uType == "AD") {
			$userId = $this->session->GetAdminData ()->userid;
			if ($type == "V" && IsAdminViewLog) {
				$userType = "A";
			} elseif ($type == "U" && IsAdminUpdateLog) {
				$userType = "A";
			} elseif ($type == "A" && IsAdminInsertLog) {
				$userType = "A";
			} elseif ($type == "D" && IsAdminDeleteLog) {
				$userType = "A";
			} elseif ($type == "O" && IsAdminDownloadLog) {
				$userType = "A";
			} elseif ($type == "P" && IsAdminUploadLog) {
				$userType = "A";
			} elseif ($type == "C" && IsAdminCommonLog) {
				$userType = "A";
			} else {
				return true;
			}
		}
		if ($this->InsertLog ( $userId, $userType, $msg, $parm, $value, $type )) {
			return true;
		}
		return false;
	}
	
	private function InsertLog($userId, $userType, $msg = '', $parm = '', $value = "", $type = "V") {
		$this->load->model ( 'database/Mdatamoat_log' );
		$datamtLog = new Mdatamoat_log ();
		//$datamtLog->changed_msg ( $msg );
		$datamtLog->account_id ( $userId );
		$datamtLog->userType ( $userType );
		$datamtLog->changed_page ( $this->router->method );
		$datamtLog->pageURI ( $this->uri->uri_string () );
		$datamtLog->date_time ( date ( "Y-m-d H:i:s" ) );
		$datamtLog->msg_code ( $msg );
		$datamtLog->msg_param ( $parm );
		$uData = $this->session->GetUserData ();
		if (! empty ( $uData->userEmail )) {
			$datamtLog->userEmail ( $uData->userEmail );
		}
		$datamtLog->changed_type ( $type );
		$datamtLog->changed_value ( $value );
		$datamtLog->ip ( $this->input->ip_address () );
		
		if ($datamtLog->Save ( false )) {
			return true;
		} else {			
			return false;
		}
	}

}