<?php
class GSEncryption
{
	static function hex2bin($h)
	{
		if (!is_string($h)) return null;
		$r='';
		$len = strlen($h) - 1;
		for ($a=0; $a<$len; $a+=2) {
			$r.=chr(hexdec($h{$a}.$h{($a+1)}));
		}
		return $r;
	}

	static function AESDecrypt($str, $key, $iv)
	{
	    $str = self::hex2bin($str);
	    $block = mcrypt_get_block_size(MCRYPT_RIJNDAEL_128, MCRYPT_MODE_CBC);
	
		if (strlen($iv) < $block) return '';
	    $str = mcrypt_decrypt(MCRYPT_RIJNDAEL_128, $key, $str, MCRYPT_MODE_CBC, $iv);

	    $pad = ord($str[($len = strlen($str)) - 1]);
	    return substr($str, 0, strlen($str) - $pad);
	}

	static function AESEncrypt($str, $key, $iv)
	{
		$block = mcrypt_get_block_size(MCRYPT_RIJNDAEL_128, MCRYPT_MODE_CBC);
		$pad = $block - (strlen($str) % $block);
		$str .= str_repeat(chr($pad), $pad);

		$dec = mcrypt_encrypt(MCRYPT_RIJNDAEL_128, $key, $str, MCRYPT_MODE_CBC, $iv);
		$dec = bin2hex($dec);
	
	    return $dec;
	}
	
	static function PBXCardEncrypt($cc_number,$cc_name,$exp_date,$cvc,$last4,$zip,$account_id){
		$cc_name=str_replace("_", " ", $cc_name);
		$cc_number=str_replace("_", "", $cc_number);
		$cvc=str_replace("_", "", $cvc);
		$zip=str_replace("_", "-", $zip);
		$exp_date=str_replace("_", "", $exp_date);		
		$toEncStr=$cc_name."_".$cc_number."_".$cvc."_".$zip."_".$exp_date;
		$str=$account_id."_".$exp_date."_".$last4;
		$md=md5($str);		
		$iv=substr($md,0,16);
		$key=substr($md,16,16);	
		return self::AESEncrypt($toEncStr, $key, $iv);
	}
	static function PBXCardDecrypt($toDecrypt,$exp_date,$last4,$account_id){
		$str=$account_id."_".$exp_date."_".$last4;
		$md=md5($str);		
		$iv=substr($md,0,16);
		$key=substr($md,16,16);	
		return self::AESDecrypt($toDecrypt, $key, $iv);
	}
	static function PBXCardDecryptObj($toDecrypt,$exp_date,$last4,$account_id){
		$str=self::PBXCardDecrypt($toDecrypt, $exp_date, $last4, $account_id);		
		$returnObj=new stdClass();
		$strArray=explode("_", $str);	
		if(count($strArray)>=4){
			$returnObj->cc_name=trim($strArray[0]);
			$returnObj->cc_number=trim($strArray[1]);
			$returnObj->cc_cvc=trim($strArray[2]);
			$returnObj->cc_zip=trim($strArray[3]);			
			$returnObj->exp_date=$exp_date;
			if(empty($returnObj->exp_date) && !empty($returnObj->cc_name)){
				$returnObj->exp_date=$exp_date;
			}
			return $returnObj;
		}else{
			return null;
		}
	}
	static function GSGlobalEncrypt($toEncrypt){
		$key=md5('gtalkpbx');
		$str=GSEncryption::AESEncrypt($toEncrypt, substr($key,0,16), substr($key,-16));
		return $str;
	}
	static function GSGlobalDecrypt($toDecrypt){
		$key=md5('gtalkpbx');
		$str=GSEncryption::AESDecrypt($toDecrypt, substr($key,0,16), substr($key,-16));
		return $str;
		
	}

	
}
